#ifndef lint
static char rcsid[] = "$Id: md5wrapper.c,v 1.1.1.1 92/11/02 17:53:07 genek Exp $";
#endif

/*
 * md5wrapper.c
 *
 *	signature function hook for MD5 (the RSA Data Security, Inc. MD5 
 *	Message Digesting Algorithm) for Tripwire.
 *
 *	The original MD5 code is contained in md5.c in its entirety.
 *
 * Gene Kim
 * Purdue University
 * September 27, 1992
 */

#include "../../include/config.h"
#include <stdio.h>
#include <sys/types.h>
#ifdef STDLIBH
#include <stdlib.h>
#include <unistd.h>
#endif
#ifdef STRINGH
#include <string.h>
#else
#include <strings.h>
#endif
#include "../../include/sigs.h"
#include "md5.h"
#define BUFSIZE 4096

static MD5_CTX mdbucket;			/* MD5 data structure */

char *ltob64();

/*
 * int
 * pf_signature(int fd_in, char *ps_signature, int siglen)
 *
 *	fd_in: 		pointer to input file descriptor
 *	ps_signature: 	pointer to array where signature will be stored
 *	siglen: 	length of the signature array (for overflow checking)
 */

int 
sig_md5_get (fd_in, ps_signature, siglen)
    int fd_in;
    char *ps_signature;
    int siglen; 
{
    unsigned char buffer[BUFSIZE];
    int		readin;
    unsigned long int words;
    int 	i;
    MD5_CTX	*mdbuf;
    char	s[128];
    char	sword[128];

    mdbuf = &mdbucket;

    ps_signature[0] = '\0';

    /* rewind the file descriptor */
    if (lseek(fd_in, 0, SEEK_SET) < 0) {
	perror("sig_md5_get: lseek()");
	exit(1);
    }
     
    MD5Init (mdbuf);

    while ((readin = read(fd_in, (char *)buffer, (off_t) BUFSIZE)) == BUFSIZE) {
	MD5Update(mdbuf, buffer, BUFSIZE);
    }
    if (readin < 0) {
	perror("sig_md5_get: read()");
	exit(1);
    }
    if (readin > 0) {
	MD5Update(mdbuf, buffer, (unsigned)readin);
    }
    MD5Final (mdbuf);

    words = 0L;
    for (i = 0; i < 16; i++) {
	words = (words << 8) | mdbuf->digest[i];
	if ((i+1) % 4 == 0 && i != 0 && i != 15) {
	    /* printf("%08lx", words); */
	    sprintf(s, "%6s", ltob64(words, sword));
	    strcat(ps_signature, s);
	    words = 0L;
	}
    }
    /* printf("%04lx", words); */
    sprintf(s, "%6s", ltob64(words, sword));
    strcat(ps_signature, s);
    return 0;
}
