%{
/* $Id: config.pre.l,v 1.1.1.1 92/11/02 17:54:21 genek Exp $ */

/*
 * config.pre.l
 *
 *	lexical analyzer for preprocessing tw.config files.
 *
 *	note that escaped sequences in the <string> token must be 
 *	expanded manually.
 *
 * Gene Kim
 * Purdue University
 * October 4, 1992
 */

			/* 
			 * note that strings can contain '@'s, but they
			 * cannot start with them! 
			 *
			 * similarly, we can have #'s in strings, but they
			 * cannot be the first character! 
			 */

%}

WS			[ \t]
COMMENT			[#]
EOL			[\n]
DIRECTIVE		@{2,2}
STRING			([^ \t\n\#\@\(\)]|\\.)+([^ \t\n\(\)]|\\.)*
LPAREN			[\(]
RPAREN			[\)]
ANDAND			\&{2,2}
OROR			\|{2,2}
BSLASH			[\\]

%%

{WS}+			{ /* eat spaces */ }
{BSLASH}{EOL}		{   
			    /* eat line continuations */ 
			    linenumber++; 
			}
{COMMENT}[^\n]*		{ /* eat comments */ }

^{DIRECTIVE}{WS}*include	{ return INCLUDE; }
^{DIRECTIVE}{WS}*define		{ return DEFINE; }
^{DIRECTIVE}{WS}*undef		{ return UNDEF; }
^{DIRECTIVE}{WS}*ifdef		{ return IFDEF; }
^{DIRECTIVE}{WS}*ifndef		{ return IFNDEF; }
^{DIRECTIVE}{WS}*ifhost		{ return IFHOST; }
^{DIRECTIVE}{WS}*ifnhost	{ return IFNHOST; }
^{DIRECTIVE}{WS}*contents	{ return CONTENTS; }
^{DIRECTIVE}{WS}*dbaseversion	{ return DBASEVERSION; }
^{DIRECTIVE}{WS}*else		{ return ELSE; }
^{DIRECTIVE}{WS}*endif		{ return ENDIF; }
^{DIRECTIVE}{WS}*echo		{ return ECHOTHIS; }
{DIRECTIVE}			{ return DIRECTIVE; }

{EOL}			{ linenumber++; return EOL; }
{ANDAND}		{ return ANDAND; }
{OROR}			{ return OROR; }
{LPAREN}		{ return LPAREN; }
{RPAREN}		{ return RPAREN; }
{STRING}		{
			    yytext[yyleng] = '\0';
			    yylval.string = yytext;
			    if (yaccdebuglevel > 10) 
				printf("--(STRING)--> %s\n", yytext);
			    return STRING;
			}

