#ifndef lint
static char rcsid[] = "$Id: dbase.update.c,v 1.2 92/11/03 02:43:43 genek Exp $";
#endif

/*
 * dbase.update.c
 *
 *	build the preen.database file with the list of files that
 *	was generated by config.parse.c
 *
 * Gene Kim
 * Purdue University
 */

#include "../include/config.h"
#include <stdio.h>
#include <fcntl.h>
#ifdef STDLIBH
# include <stdlib.h>
#endif
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef STRINGH
#include <string.h>
#else
#include <strings.h>
#endif
#include <errno.h>
#include "../include/list.h"
#include "../include/tripwire.h"

/*
 * database_update_markentries (struct list **pp_list, int flagentry)
 *
 *	mark all entries with the given (flagentry) as FLAG_UPDATE.
 */

void
database_update_markentries (pp_list, flagentry)
    struct list **pp_list;
    int flagentry;
{
    struct list_elem *p_fileentry;
    char trash[1024];
    int entry;
    int err;

    /* use pp_list as key */
    if (list_open(pp_list) < 0) {
	fputs("database_update: list_open() failed!\n", stderr);
	exit(1);
    }

    /* foreach file entry */
    while ((p_fileentry = list_get(pp_list)) != NULL) {
	if ((err = sscanf(p_fileentry->varvalue, "%d %s", &entry, trash)) < 2) {
	    fprintf(stderr, "database_update: sscanf() parse error, returned %d!\n", err);
	    exit(1);
	}
	/* flag if entry number match */
	if (entry == flagentry) {
	    list_setflag(p_fileentry->varname, FLAG_UPDATE, pp_list);
	}
    }

    /* close up the list */
    if (list_close(pp_list) < 0) {
	fputs("database_update: list_close() failed!\n", stderr);
	exit(1);
    }
}

