/* $Id: list.h,v 1.2 1993/08/19 05:27:27 genek Exp $ */

#define LIST_HASHSZ	17011

/* linked list element */
struct list_elem {
    char 	*varname;
    char	*varvalue;
    int		priority;
    struct list_elem	*next;
    struct list_elem	*prev;
    int		flag;
};

/* hash table structure */
struct list_hash {
    char	*key;			/* hashed string */
    int		used;			/* table used or not */
    struct list_elem	*lptr;		/* pointer to entry on list */
    struct list_hash	*next;		/* pointer to next entry on chain */
};

/* linked list pointer, with head and tail */
struct list {
    struct list_elem	*p_head;
    struct list_elem	*p_tail;
    struct list_hash	hashtable[LIST_HASHSZ];
};

/* prototypes */
/* Do not remove this line.  Protyping depends on it! */
#if defined(__STDC__) || defined(__cplusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif

/* list.c */
void list_set P_((char *pc_name, char *pc_value, int priority, struct list **pp_list));
char *list_lookup P_((char *pc_name, struct list **pp_list));
int list_isthere P_((char *pc_name, struct list **pp_list));
void list_unset P_((char *pc_name, struct list **pp_list));
int list_setflag P_((char *pc_name, int flag, struct list **pp_list));
int list_getflag P_((char *pc_name, struct list **pp_list));
void list_print P_((struct list **pp_list));
void list_reset P_((struct list **pp_list));
int list_init P_((void));
int list_open P_((struct list **pp_list));
struct list_elem *list_get P_((struct list **pp_list));
int list_close P_((struct list **pp_list));

#undef P_
