#ifndef lint
static char rcsid[] = "$Id: md4wrapper.c,v 1.5 1993/12/15 16:50:11 genek Exp $";
#endif

/*
 * md4wrapper.c
 *
 *	signature function hook for MD4 (the RSA Data Security, Inc. MD4 
 *	Message Digesting Algorithm) for Tripwire.
 *
 *	The original MD4 code is contained in md4.c in its entirety.
 *
 * Gene Kim
 * Purdue University
 * October 14, 1992 
 */

#include "../../include/config.h"
#include <stdio.h>
#include <sys/types.h>
#ifdef STDLIBH
#include <stdlib.h>
#include <unistd.h>
#endif
#ifdef STRINGH
#include <string.h>
#else
#include <strings.h>
#endif
#include "../../include/sigs.h"
#include "md4.h"
#define BUFSIZE 64			/* limit of in-struct buffer size */

static MDstruct mdbucket;			/* MD4 data structure */

char *pltob64();

/*
 * int
 * pf_signature(int fd_in, char *ps_signature, int siglen)
 *
 *	fd_in: 		pointer to input file descriptor
 *	ps_signature: 	pointer to array where signature will be stored
 *	siglen: 	length of the signature array (for overflow checking)
 */

int 
sig_md4_get (fd_in, ps_signature, siglen)
    int fd_in;
    char *ps_signature;
    int siglen; 
{
    unsigned char buffer[BUFSIZE];
    int		readin = -1;
    unsigned long int words;
    int 	i;
    MDstruct	*mdbuf;
    char	s[128];
    char	sword[128];

    mdbuf = &mdbucket;

    ps_signature[0] = '\0';

    /* rewind the file descriptor */
    if (lseek(fd_in, 0, SEEK_SET) < 0) {
	perror("sig_md4_get: lseek()");
	exit(1);
    }
     
    MDbegin (mdbuf);

    while ((readin = read(fd_in, (char *)buffer, (off_t) BUFSIZE)) > 0) {
	MDupdate(mdbuf, buffer, readin*8);
    }
    if (readin < 0) {
	perror("sig_md4_get: read()");
	exit(1);
    }
    MDupdate(mdbuf, buffer, (unsigned)readin);

    words = 0L;
    if (printhex) {
	MDsprint(ps_signature, mdbuf);
    } else {
	MDsprint64(ps_signature, mdbuf);
    }
    return 0;
}
