#ifndef lint
static char rcsid[] = "$Id: shawrapper.c,v 1.3 1993/12/15 18:28:05 genek Exp $";
#endif

/*
 * shawrapper.c
 *
 *	signature function hook for SHA for Tripwire.
 *
 *	The original SHA code is contained in sha.c in its entirety.
 *
 * Gene Kim
 * Purdue University
 * August 10, 1993
 */

#include "../../include/config.h"
#include <stdio.h>
#include <sys/types.h>
#ifdef STDLIBH
#include <stdlib.h>
#include <unistd.h>
#endif
#ifdef STRINGH
#include <string.h>
#else
#include <strings.h>
#endif
#include "../../include/sigs.h"
#include "sha.h"

char *pltob64();

/*
 * int
 * pf_signature(int fd_in, char *ps_signature, int siglen)
 *
 *	fd_in: 		pointer to input file descriptor
 *	ps_signature: 	pointer to array where signature will be stored
 *	siglen: 	length of the signature array (for overflow checking)
 */


#define BLOCKSIZE 		SHS_BLOCKSIZE

int 
sig_sha_get (fd_in, ps_signature, siglen)
    int fd_in;
    char *ps_signature;
    int siglen; 
{
    SHS_INFO shsInfo;
    unsigned char buffer[BLOCKSIZE];
    int readin = -1;
    int i;
    char s[128], sword[128];

    ps_signature[0] = '\0';

    /* rewind the file descriptor */
    if (lseek(fd_in, 0, SEEK_SET) < 0) {
	perror("sig_sha_get: lseek()");
	exit(1);
    }
     
    shsInit( &shsInfo );

    while ((readin = read(fd_in, (char *)buffer, (off_t) BLOCKSIZE)) == BLOCKSIZE) {
	shsUpdate(&shsInfo, buffer, readin);
    }
    if (readin < 0) {
	perror("sig_sha_get: read()");
	exit(1);
    }
    if (readin >= 0) {
	shsUpdate(&shsInfo, buffer, readin);
    }


    shsFinal( &shsInfo );

    /* print out the signature */
    if (printhex) {
	for (i = 0; i < 5; i++) {
	    sprintf(s, "%08lx", shsInfo.digest[i]); 
	    strcat(ps_signature, s);
	}
    }
    /* base 64 */
    else {
	pltob64(shsInfo.digest, ps_signature, 5);
    }
    return 0;
}
