#include "../include/config.h"
#include <stdio.h>
#include <fcntl.h>
#ifdef STDLIBH
# include <stdlib.h>
#endif
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifndef XENIX
# include <sys/time.h>
#else
# include <time.h>
#endif 	/* XENIX */
#ifdef DIRENT
# include <dirent.h>
#else
# ifndef XENIX
#  include <sys/dir.h>
# else		/* XENIX */
#  include <sys/ndir.h>
# endif		/* XENIX */
#endif	/* DIRENT */
#if (defined(SYSV) && (SYSV < 3))
# include <limits.h>
#endif	/* SVR2 */
#ifdef STRINGH
#include <string.h>
#else
#include <strings.h>
#endif
#include "../include/list.h"
#include "../include/tripwire.h"

/* 
 * twconvert
 *
 *	convert v1.0 Tripwire databases to v1.1
 *
 * Gene Kim
 * $Id: twconvert.c,v 1.2 1993/12/15 18:28:09 genek Exp $
 */


void b64_convert();
int dbaseformat = 1;
int debuglevel = 0;

#define NVEC 14
int
main(argc, argv)
    int argc;
    char *argv[];
{

/* filename: (entrynumber, ignorevec, st_mode, st_ino, st_nlink,
 *		st_uid, st_gid, st_size,
 *		ltob64(statbuf->st_atime, vec64_a),
 *		ltob64(statbuf->st_mtime, vec64_m),
 *		ltob64(statbuf->st_ctime, vec64_c), sig0, sig1, ..., sig9
 */

    char s[2048], t[2048];
    char filename[1024], entrynum[128], st_mode[128], 
		st_ino[128], 
		st_nlink[128],
 		st_uid[128], st_gid[128], st_size[128],
		vec64[NVEC][128];
    int err, i, ver;
    int linenumber = 0;
    char *pc;

    while (fgets(s, sizeof(s), stdin) != NULL) {
	linenumber++;
	if (strncmp(s, "@@dbaseversion", strlen("@@dbaseversion")) == 0) {
	    int ver;
	    char trash[1024];
	    sscanf(s, "%s %d", trash, &ver); 
	    if (ver != 1 && ver != 2) {
		fprintf(stderr, "unknown version %d!\n", ver);
		exit(1);
	    }
	    fprintf(stderr, "Converting from dbaseformat %d to %d\n", ver,
		DB_VERSION_NUM);
	    {
#ifndef NOGETTIMEOFDAY
		    struct timezone tzone;
		    struct timeval tval;
#else
		    long tval;
#endif	/* XENIX */
		char timestring[30];

#ifndef NOGETTIMEOFDAY
    if (gettimeofday(&tval, &tzone) < 0)
        die_with_err("gettimeofday()", (char *) NULL);
#else
    tval = time((long *) 0);
#endif	/* XENIX */
		strncpy(timestring, ctime((time_t *)&tval), 26);
		printf("# Converted by twconvert, release version %s on %s",
					    VERSION_NUM, timestring);
		printf("@@dbaseversion %d\n", DB_VERSION_NUM);
	    }
	    dbaseformat = ver;
	    continue;
	}
	if (s[0] == '#' || s[0] == '@') {
	    fputs(s, stdout);
	    continue;
	}
	if ((err = sscanf(s, "%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s", 
		    filename, entrynum, vec64[13], st_mode, st_ino, 
		    st_nlink,
		    st_uid, st_gid, st_size,
		    vec64[0],
		    vec64[1],
		    vec64[2],
		    vec64[3],
		    vec64[4],
		    vec64[5],
		    vec64[6],
		    vec64[7],
		    vec64[8],
		    vec64[9],
		    vec64[10],
		    vec64[11],
		    vec64[12])) != 22) {
	    fputs(s, stdout);
	    continue;
	}

	/* convert */
	for (i = 0; i < NVEC; i++) {
	    if (dbaseformat == 1)
		b64_convert(vec64[i]);
	    /* now pack it */
	    b64_pack(vec64[i]);
	}
	sprintf(t, "%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s \n", 
		    filename, entrynum, vec64[13], st_mode, st_ino, 
		    st_nlink,
		    st_uid, st_gid, st_size,
		    vec64[0],
		    vec64[1],
		    vec64[2],
		    vec64[3],
		    vec64[4],
		    vec64[5],
		    vec64[6],
		    vec64[7],
		    vec64[8],
		    vec64[9],
		    vec64[10],
		    vec64[11],
		    vec64[12]);
	fputs(t, stdout);
    }
    exit(0);
}

static char new64vec[] =
  "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz:.";
static char old64vec[] =
  "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

void
b64_convert(s)
    char *s;
{
    int i;
    char *pc;
    char tmp[64];

    if (strcmp(s, "0") == 0) {
	return;
    }

    strcpy(tmp, s);

    for (pc = s; *pc; pc++) {
	/* search old vector */
	for (i = 0; i < 64; i++) {
	    if (old64vec[i] == *pc) {
		*pc = new64vec[i];
		break;
	    }
	}
    }

    /*
    fprintf(stderr, "(%s) --> (%s)\n", tmp, s);
    */
}


b64_pack(s)
    char *s;
{
    /* get group of 6 chars, convert into long, then pack the whole
     * thing into one vec
     */

    char new[1024], *pc;
    int i, numl = 0;
    long larray[100];

    if (strcmp(s, "0") == 0)
	return;

    pc = s;
    while (*pc) {
	strncpy(new, pc, 6);
	larray[numl++] = b64tol(s);
	pc += 6;
    }
    pltob64((unsigned long *) larray, (char *) new, numl);
    /*
    if (strcmp(s, new) != 0)
	fprintf(stderr, "%s <---> %s\n", s, new);
    */
    strcpy(s, new);
}
