/* conf-ptx2.h 
 *
 *	Tripwire configuration file
 *
 * Michael Perrone -- a4mp@loki.cc.pdx.edu 
 * Portland State University                 
 */

/* include file for bsd types such as u_long */

#include <netinet/in_systm.h>


/***
 *** Operating System specifics
 ***	
 ***	If the answer to a question in the comment is "Yes", then
 ***	change the corresponding "#undef" to a "#define"
 ***/

/*
 * Even though ptx 2 is based on SVR4, there is some stuff
 * missing that tripwire expects for SYSV = 4
 */

#define SYSV 3

/*
 * ptx has never had this - use system call "time"
 */

#define NOGETTIMEOFDAY

/* 
 * does your system have a <malloc.h> like System V? 
 * ptx does
 */

#define MALLOCH 	

/* 
 * does your system have a <stdlib.h> like POSIX says you should? 
 * ptx has stdlib.h
 */

#define STDLIBH

/*
 * does your system use readdir(3) that returns (struct dirent *)?
 * ptx does
 */

#define DIRENT

/*
 * is #include <string.h> ok?  (as opposed to <strings.h>)
 * ptx uses <strings.h>
 */

#define STRINGH
 
/* 
 * does your system have gethostname(2) (instead of uname(2))?
 * ptx provides both calls.
 */

#undef GETHOSTNAME

