#!/bin/sh

# $Id: test1.sh,v 1.12 1993/12/15 17:03:45 genek Exp $ 

HOSTNAME=hostname
# check to see if we ran from top-level makefile!
if [ $# -ne 1 ]
then 
   echo "Sorry!  You must run this test from the top-level Makefile!"
   exit 1
fi

HOSTNAME=$1
ME=$0

cat << GHK
=== $ME: DESCRIPTION

    This shell script tests all the Tripwire signature routines.
Consequently, this test may take awhile to complete, because even the
slowest signature routines are exercised.  On a 200 MHz Intel Pentium 
machine, this test takes 15 seconds to complete. 

    This test suite will ascertain whether the byte-ordering and 
machine-dependent routines are working correctly.

GHK

echo "=== $ME: BEGIN ==="
echo ''

echo creating: ./tw.db_TEST.@
echo creating: ./@tw.config

HOST=`$HOSTNAME`
CURRPATH=`pwd`
CURRPATH=`echo $CURRPATH | sed s,/tests$,,`

sed s,/build,$CURRPATH, < ./tw.db_TEST > ./tw.db_TEST.@; 
sed s,/build,$CURRPATH, < ./tw.conf.test > ./@tw.config; 

../src/tripwire -loosedir -c ./@tw.config -d ./tw.db_TEST.@; 

echo "=== $ME: END ===" 
echo ''

echo removing: ./tests/tw.db_TEST.@
echo removing: @tw.config
rm ./tw.db_TEST.@
rm ./@tw.config
