/* ttywatch.h -- log output from TTYs, based on robin.c from the book
 * Linux Application Development, by Michael K. Johnson and Erik W. Troan
 *
 * Copyright  2000 Michael K. Johnson <johnsonm@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __TTYTWATCH_H__
#define __TTYTWATCH_H__

#include <termios.h>
#include <dlfcn.h>

typedef struct machine machine;
struct machine {
	char *name;
	char *devpath;
	void (*process_line)(machine *m, char *data);
	void *modhandle;
	int dev_fd;
	int log_fd;
	speed_t speed;
	struct termios ots;
	struct termios ts;
};

#endif /* __TTYTWATCH_H__ */
