Name: ttywatch
Version: 0.4
Release: 1
Summary: Log output of arbitrarily many devices
Copyright: GPL
Group: System Environment/Daemons
Source: ttywatch-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-root
Prereq: /sbin/chkconfig

%description
ttywatch was originally designed to log serial console output from
lots of Linux machines on a single monitor machine.  It handles
log rotation correctly and can be configured both in a configuration
file and on the command line -- and you can mix-and-match at your
convenience.

%package devel
Summary: Build modules for the ttywatch daemon
Group: Development/System

%description devel
Includes the ttywatch.h header file used to build ttywatch modules.

%prep
%setup

%build
make

%install
[ "$RPM_BUILD_ROOT" = "/" ] && {
	echo 'this package must build in a buildroot' >&2
	exit 1
}

[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

make install TOPDIR=$RPM_BUILD_ROOT

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add ttywatch

%preun
if [ "$1" = 0 ]; then
    service ttywatch stop > /dev/null 2>&1
    /sbin/chkconfig --del ttywatch
fi

%postun
if [ "$1" -ge "1" ]; then
    service ttywatch condrestart > /dev/null 2>&1
fi

%files
%defattr(-,root,root)
%attr(0755,root,root) /usr/sbin/*
%attr(0755,root,root) /etc/rc.d/init.d/ttywatch
%config(noreplace) %attr(0644,root,root) /etc/ttywatch.conf
%config(noreplace) %attr(0644,root,root) /etc/logrotate.d/ttywatch
%attr(0644,root,root) /usr/share/man/man*/*
%dir %attr(0700,root,root) /var/log/ttywatch

%files devel
%defattr(-,root,root)
%attr(0644,root,root) /usr/include/*

%changelog
* Mon Dec 04 2000 Michael K. Johnson <johnsonm@redhat.com>
- Added facility for log modules.
- Added -devel package for building log modules

* Wed Nov 01 2000 Michael K. Johnson <johnsonm@redhat.com>
- Releasing 0.3
- Fixed log file re-opening to use the .log suffix

- Releasing 0.2, first public version
- License notice added
- Code cleanup
- Nested config files fixed
- Documentation touch-ups

* Thu Sep 15 2000 Michael K. Johnson <johnsonm@redhat.com>
- initial version
