/* ttywatch.h -- log output from TTYs, based on robin.c from the book
 * Linux Application Development, by Michael K. Johnson and Erik W. Troan
 *
 * Copyright  2000 Michael K. Johnson <johnsonm@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __TTYTWATCH_H__
#define __TTYTWATCH_H__

#include <termios.h>
#include <dlfcn.h>
#include <glib.h>

/* this should really be in telnet.h, but need to short-circuit
 * the dependency
 */
typedef enum {
	TS_DATA = 0,
	TS_IAC,
	TS_SB,
	TS_SB_IAC,
} telnet_state;

typedef struct net_conn net_conn;
struct net_conn {
	struct machine *m;
	int fd;
	telnet_state ts;
};

typedef struct machine machine;
struct machine {
	char *name;
	char *devpath;
	char *ipport;
	char *ipaddr;
	int logspew;
	void (*process_line)(machine *m, char *data);
	void *modhandle;
	int dev_fd;
	int log_fd;
	int accept_fd;
	GSList *net_conns;
	speed_t speed;
	struct termios ots;
	struct termios ts;
};

#if DEBUGGING
#define D printf
#else
#define D(...) do { } while (0)
#endif

#endif /* __TTYTWATCH_H__ */
