/* socket.c -- socket handling for ttywatch
 *
 * Copyright  2001 Michael K. Johnson <johnsonm@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "errors.h"

int
socket_listen(char *port, char *localaddr) {
    int sock;
    struct sockaddr_in addr;
    int i;

    sock = socket(PF_INET, SOCK_STREAM, 0);
    if (sock == -1) return 0;

    i=1;
    setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &i, sizeof(i));

    addr.sin_family = AF_INET;
    addr.sin_port = htons(atoi(port));
    if (localaddr) {
	if (!inet_aton(localaddr, &addr.sin_addr)) {
	    warn(NULL, "could not parse local address %s for port %s",
	         localaddr, port);
	    return 0;
	}
    } else {
	memset(&addr.sin_addr, '\0', sizeof(addr.sin_addr));
    }

    if (bind(sock, (struct sockaddr *)&addr, sizeof(addr))) {
	warn(NULL, "bind failed for port %s, addr %s", port,
	     localaddr ? localaddr : "unbound");
	return 0;
    }

    if (listen(sock, 5)) die ("listen failed\n");

    return (sock);
}

int
socket_accept(int sock) {
    struct sockaddr_in addr;
    socklen_t addrlen = sizeof(addr);
    int conn;

    conn = accept(sock, (struct sockaddr *)&addr, &addrlen);
    if (conn == -1) {
	warn(NULL, "accept failed on socket %d", sock);
	return 0;
    }

    /* this is where we would do authentication if we cared
     * feel free to add PAM authentication here if you care
     * However, if you do, you will have to move telnet
     * protocol setup here as well, and then use the telnet
     * protocol functions to do the authentication.
     */

    return conn;
}
