/* Common interrupt GUI handlers for xview, motif, etc. */

/*
 * Copyright (c) 1995  En Garde Systems. All rights reserved.
 *    
 * Redistribution and use in source and binary forms, with or without    
 * modification, for NON COMMERCIAL USE are permitted provided that: 
 * (1) source code distributions retain the above copyright notice and this 
 * paragraph in its entirety, and (2) distributions including binary code 
 * include the above copyright notice and this paragraph in its entirety in 
 * the documentation or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * For commercial use or modification of this program, contact:
 * En Garde Systems
 * 525 Clara Avenue, Suite 202
 * St. Louis, MO  63112
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <time.h>

#include <sys/socket.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <sys/param.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <malloc.h>
#include <sys/stream.h>
#include <stropts.h>
#include <utmp.h>
#include <pwd.h>

#ifdef SOLARIS
#include <sys/mkdev.h>
#endif 

#include "ses_packet.h"

extern int xv,curses_fullscreen,raw_log,mapped,watchfd,current_mode;
extern int current_input,ttyfd;
extern time_t gtime;
extern struct con *current, *con_hash[];
extern u_long lastack;
extern struct con *row_list;
extern int active, lastsaveddatalen, reachedEOF;
extern int playspeed, paused;
int cspos=0;
int purge_time=120;
int watched_rawlog=0;

static char *RCSid="$Id: common.c,v 1.3 1995/06/14 19:35:21 mcn Exp $";

static char RAW_MAGIC[] = { 'W','a','t','c','h','e','r','R','a','w','1','.','0' };

com_purge_slider_set(value)
int value;
{
purge_time=value;
}

char rawlog_filename[80];

com_log_current(value)
int value;
{
char *buf;
char title[256];
time_t clock;
char tbuf[80];
char *x;

if (current==NULL || reachedEOF) {
	set_fi_value("Dead Session--can't log",0);
	set_lc_value(0);
    return;
}
if (value==0 && current->log>0) {
	if (current->log==2) {
		time(&clock);
		sprintf(tbuf,"\n*** END AT: %s", ctime(&clock));
		write(current->logfd, tbuf, strlen(tbuf));
		close(current->logfd);
	}
	current->logfd=-1;
	current->log=-current->log;
	set_fi_value(current->logfile, 0);
}
if (value==1) {
   /* current->log must be <= 0) */
   if (current->log==-1) {
	    if (raw_log>0) {
			current->log=1;
       		current->logfd=raw_log;
			strcpy(current->logfile, rawlog_filename);
			set_fi_value(rawlog_filename, 1);
   			return;
    	} else {
   			lastsaveddatalen=-1;
   			buf=(char *)get_filename2();
   			if ((raw_log=open(buf, O_WRONLY|O_CREAT|O_EXCL, 0600))<0) {
            	perror("open raw");
				set_lc_value(0);
            	return;
   			} else {
				write(raw_log, RAW_MAGIC, sizeof(RAW_MAGIC));
            	reachedEOF = 0;
				playspeed = 1;
				paused=0;
            	current->log=1;
            	current->logfd=raw_log;
            	strcpy(current->logfile, buf);
				strcpy(rawlog_filename, buf);
            	return;
   			}
 		}
	}
    if (current->log==-2) {
	    buf=(char *)get_filename2();
		for (x=buf;*x!=0;x++)
			if (!(isalnum(*x) || ispunct(*x))) {
				set_fi_value("Bad Filename", 0);
				set_lc_value(0);
				return;
			}
		if ((current->logfd=open(buf, O_WRONLY|O_CREAT|O_APPEND, 0600))<0) {
			set_fi_value("Bad Filename",0);
			set_lc_value(0);
   			return;
    	}
    	strcpy(current->logfile, buf);
		time(&clock);
		sprintf(title, "%s [%s]\n*** %s\n",
			current->username, dev_to_tty(current->dev), ctime(&clock));
    	write(current->logfd, title, strlen(title));
    	current->log=2;
		set_fi_value(current->logfile, 1);
    	return;
    }
    /* If we're here, something is bad! */
    fprintf(stderr,"nasty error in on/off switch for logging!\n");
 } /* of if value==1 */
return;
}


com_ss_choice(value)
int value;
{
struct tm *tm;
char nbuf[80];
time_t clock;

if (current==NULL) return; /* Someone tried to log a dead connection */
if (value==0 && current->log!=1) {
	if (current_input==0) {
		/* Then we're reading from a rawlog file... Don't allow rawlogs */
		set_ra_value(1);
		set_fi_value("Can't log rawlog input to a rawlog", 0);
		return;
	}
	if (current->logfd>0) {
		if (current->log==2) {
			time(&clock);
			sprintf(nbuf,"\n*** END AT: %s", ctime(&clock));
			write(current->logfd, nbuf, strlen(nbuf));
		}
		close(current->logfd);
		current->logfd=-1;
	}
	set_lc_value(0);
	current->log=-1;
	if (raw_log>0) {
		set_fi_value(rawlog_filename, 1);
    	return; /* if rawlog open, don't open another */
	}
	tm = localtime(&gtime);
	strftime(rawlog_filename, 60, "rawlog.%y%m%d%H%M", tm);
	set_fi_value(rawlog_filename, 1);
}
if (value==1 && current->log!=2) {
	set_lc_value(0);
	current->log=-2;
	set_fi_value("", 0);
}
return;
}

void com_clean_subtree(cp, close_fd)
struct con *cp;
int close_fd;
{
struct con *cpp;
char buf[80];
time_t clock;

while (cp) {
	cpp=cp->next;
	if (close_fd && cp->log==2 && cp->logfd>0) {

		time(&clock);
		sprintf(buf,"\n*** END AT: %s", ctime(&clock));
		write(cp->logfd, buf, strlen(buf));
		close(cp->logfd);
	}
	free((char *)cp);
	cp=cpp;
}
return;
}

void com_put_in_active(cp)
struct con *cp;

{
char buf[60];
struct con *nrl, *nrlp;
int row;

	if (cp==NULL) return;
	nrl = (struct con *)malloc(sizeof(struct con));
	nrl->uid		= cp->uid;
	nrl->dev		= cp->dev;
	nrl->bytes_sent = (int)cp;
	nrl->next		= NULL;

	nrlp=row_list;
	row=1;
	while (nrlp!=NULL && nrlp->next!=NULL && minor(nrlp->next->dev)<minor(cp->dev)) 
	{
		row++;
    	nrlp=nrlp->next;
	}
	/* 3 possibilities here. 
 	 * 1) nrlp is NULL. 
 	 * 2) nrlp->next=NULL. 
 	 * 3) Insert nrl after nrlp and before nrlp->next
 	 */
	if (nrlp==NULL) {
    	row_list = nrl;
		row=0;
	} else {
    	if (nrlp->next==NULL) {
        	nrlp->next=nrl;
			if (nrlp==row_list) 
				row=1;
		} else {        
        	nrl->next=nrlp->next;
        	nrlp->next=nrl;
    	}
	}
	sprintf(buf,"%-34s  %5d",  cp->name, cp->bytes_sent);
	if (xv) {
		add_row(buf, (int)cp, row);
		active++;
	} else {
		curses_insert_row(buf, cp);
		active++;
	}

	com_put_in_active(cp->next);
	return;
}

com_choose_input(value)
int value;
{
/* This function chooses the place to get packets from.. It should
 * init the proper filedescripter and close all the open, logging fd's,
 * and dev fds
 * if choose 1, get the filename from fi_item, and check to see
 * if it exists.. If not, send error message through error_item,
 * and set back to 2 (system) If setting to 2 from 1, reinit the
 * network.
 */
char fbuf[120];
int  i;
extern int errno;
struct con *cp;
extern time_t ptime, delta_time;
char rawbuf[80];

if (!value && !current_input) return; /* choose file, already rdng from there */
if (value && current_input)   return; /* choose net, already rdng from there */
if (current_input) {  /* Reading from network */
  strncpy(fbuf, get_filename(), 120);
  if (!strlen(fbuf) || access(fbuf, R_OK)) {
	if (!strlen(fbuf)) {
		strcpy(fbuf, "Must Enter a filename"); 
	} else {
    	switch(errno) {
    		case    EACCES:			strcpy(fbuf, "Permission denied"); break;
    		case	EIO:			strcpy(fbuf, "File IO error"); break;
    		case	ELOOP:			strcpy(fbuf, "Too many symlinks"); break;
    		case    ENOENT:			strcpy(fbuf, "File not found"); break;
			case	ENAMETOOLONG:	strcpy(fbuf, "Filename too long"); break;
			case	ENOTDIR:		strcpy(fbuf, "Invalid Pathname"); break;
			default:				strcpy(fbuf, "Can't stat()"); break;
    	}
	}
	set_error_label(fbuf);
	set_input_item(1);
    return;
  }
}
if (raw_log>0) 
	close(raw_log);
if (current_input) {
    if ((watchfd=open(fbuf, O_RDONLY))==0) {
		perror("FATAL: open raw--after checks");
		exit(1);
    }
	read(watchfd, rawbuf, sizeof(RAW_MAGIC));
	if (strncmp(rawbuf, RAW_MAGIC, sizeof(RAW_MAGIC))) {
		set_error_label("Not a Rawlog");
		set_input_item(1);
		close(watchfd);
		return;
	}
} else
	close(watchfd); 
for (i=0;i<HASHSIZE;i++) {
    cp=con_hash[i];
    (void)com_clean_subtree(cp,1);
    con_hash[i]=NULL;
}
delete_all_rows();
(void)com_clean_subtree(row_list,0);
row_list=NULL;
if (mapped)  {
	select_row(-1);
    reset_mapping();
	mapped=0;
	cspos=0;
	current=NULL;
}
set_error_label("");
active=0;
if (current_input)  { /* reading from system */
    lastsaveddatalen=-1;
    watched_rawlog=1;
    current_input=0;
	show_hosebutton(0);
  	reachedEOF=0;
  	playspeed=1;
  	paused=0;
  	ptime=0;
	delta_time=0;
	pkt_time=0;
} else {
    current_input=1;
	show_hosebutton(1);
}
}

com_which_choice(op, string, choice)
int op;
char *string;
int choice;
{
  if (op) {
    if (mapped) {
	    reset_mapping();
    	cspos=0;
    	mapped=0;
    	current=NULL;
    }
	if (playspeed>1) playspeed=1; /* Reset playback rate */
    if ((int)choice!=1)
	  current=(struct con *)choice;
    else {
     fprintf(stderr,"Can't find info on that connection!!! (internal)\n");
     return;
    }
	create_login_windows();
  }
}

com_quit()
{
int i;
void com_clean_subtree();
struct con *cp;

  if (watchfd>0) close(watchfd);
  for (i=0;i<HASHSIZE;i++) {
	cp=con_hash[i];
	com_clean_subtree(cp,1);
  }
  if (ttyfd>=0) close(ttyfd);
  if (xv) {
	delete_all_rows();
    com_clean_subtree(row_list,0);
    row_list=NULL;
	kill_frame();
  }
  close_twtch();
  pop_twtchs();
  exit(0);
}

void write_cs(buf,x)
char *buf;
int x;

{
int y;
static int ticks=0;
static char csbuf[80];
int i;

if (x<=0) return;
ticks+=x;
for (y=0;y<x;y++)
  if (((u_char)*(buf+y)<32 || (u_char)*(buf+y)>126))
    *(buf+y)='~';
if ((y=(cspos+x))>79) { /* if it will overrun text line */
  if (x>79) {		/* if new data	will overrun line by itself */
    if (xv) {
		textcs_erase(0, -1);
		textcs_insert(buf+(x-79), 79);
	}
   	memcpy(csbuf, buf+(x-79), 79);
    cspos=79;
  } else {
    if (xv) {
		textcs_erase(0, (y-80));
		textcs_insert(buf, x);
	}
	for (i=0;i<80-(y-80);i++)
		csbuf[i]=csbuf[i+(y-80)];
	if (y==80)		/* Need to make sure we put the byte in the right place,
					   the first time through */
		memcpy(&csbuf[i-1],buf,x); 
	else
		memcpy(&csbuf[i], buf, x);
    cspos=80;
  }
} else {
    if (xv)
		textcs_insert(buf, x);
	memcpy(&csbuf[cspos], buf, x);
	cspos+=x;
}
if (xv) {
	if (ticks & 256) { /* 16k? */
		ticks=0;
		textcs_reset();
		textcs_insert(csbuf, cspos);
    }
} else
    redo_cswin(csbuf, cspos);
return;
}

void write_sc(buf,x, log)
char *buf;
int x;
int log;

{
char *nbuf;
int x2;
int y;

if (x <= 0) return;
if (xv)
	textsc_insert(buf, x);
else {
    if (curses_fullscreen==0) {
        nbuf=(char *)malloc(x);
		x2=0;
		for (y=0;y<x;y++)
            if ((((u_char)*(buf+y)>31 && (u_char)*(buf+y)<127) ||
		 		  (u_char)*(buf+y)==10) || (u_char)*(buf+y)==8 ||
				  (u_char)*(buf+y)==9) {
                    *(nbuf+x2)=*(buf+y);
                    x2++;
            }
		redo_scwin(nbuf, x2);
		free(nbuf);
    } else 
        redo_scwin(buf, x);
}
if (current->log==2 && log)
   write(current->logfd, buf, x);
return;
}

void dump_bufs(conn)
struct con *conn;
{
  if (xv) 	
	write_sc("\033[0;0H\033[2J", 10, 0); /* Try clearing the screen */
  if (conn->scbegin<conn->scend)
    write_sc(conn->scbuf+conn->scbegin, conn->scend-conn->scbegin, 0);
  if (conn->scend<conn->scbegin) {
    write_sc(conn->scbuf+conn->scbegin, 2048-conn->scbegin, 0);
    write_sc(conn->scbuf, conn->scend, 0);
  }
  if (conn->csbegin<conn->csend)
    write_cs(conn->csbuf+conn->csbegin, conn->csend-conn->csbegin);
  if (conn->csend<conn->csbegin) {
    write_cs(conn->csbuf+conn->csbegin, 80-conn->csbegin);
    write_cs(conn->csbuf, conn->csend);
  }
  conn->bytes_sent=0;
return;
}

void redo_titles()
{
struct con *nrl;
int i;
char new_title[80];
int x, y;

for (nrl=row_list,i=0;nrl!=NULL;i++,nrl=nrl->next) {
  if (current!=(struct con *)nrl->bytes_sent) {
     x=((struct con *)nrl->bytes_sent)->bytes_sent;
     y=((struct con *)nrl->bytes_sent)->last_bytes_sent;
    if (x-y>50 || x-y<-50) { /* Don't update unless more than
                  * a line of data came through */
      sprintf(new_title,"%-34s  %5d",((struct con *)nrl->bytes_sent)->name, x);
      if (xv)
		set_row_title(i, new_title);
      else
   		curses_redo_row(i, new_title);
      ((struct con *)nrl->bytes_sent)->last_bytes_sent=
		((struct con *)nrl->bytes_sent)->bytes_sent;
    }
  }
}
return;
}

com_pause_playback()
{
if (current){
    if (paused) {
		paused = 0;
		set_status_label("     ALIVE","green");
    } else {
   		paused = 1;
		playspeed = 1;
		set_status_label("   * PAUSED *", "blue");
    }
} /* if current*/
}

com_FF_playback()
{
extern int playspeed;

if (current) {
	if (paused) paused = 0;
    switch (playspeed) {
		case 1:
			playspeed = 2;
			set_status_label("     *X2*", "blue");
   			break;
		case 2:
			playspeed = 3;
			set_status_label("     *X3*", "blue");
			break;
		default:
			playspeed = 1;
			set_status_label("     ALIVE","green");
    }
} /* if current */
}

com_hose()
{
struct con *cp;
extern struct con *con_hash[];
int i;

for (i=0;i<HASHSIZE;i++) {
  cp=con_hash[i];
  while (cp!=NULL) {
	send_packet(cp->uid, cp->dev, FROM_USER, NULL, -1);
    delete_hash(cp->uid, cp->dev);
    cp=cp->next;
  } /* of while */
} /* of for */
return;
}

com_sendrst()
{
static char rstmess[14]="[Terminated]\0";

if (current==NULL) 
    return;

send_packet(current->uid, current->dev, FROM_USER, NULL, -1);
write_sc(rstmess,strlen(rstmess), 0);
delete_hash(current->uid, current->dev);
return;
}

com_climessage()
{
char buf[61];

bzero(buf,61);
strcpy(buf, (char *)get_climess_str());
if (strlen(buf)==0) return;
send_packet(current->uid, current->dev, FROM_SYS, buf, strlen(buf));
return;
}

struct utmp_list {
	struct utmp *data;
	struct utmp_list *next;
	struct utmp_list *prev;
} *Master_utmp=NULL;

/* This stats /etc/utmp (/etc/utmpx eventually) and checks to see if it
 * has been modified. If so, it compares it's stored version with the one
 * in utmp to see if anyone has logged in. If they have, push TAP onto their
 * stream, and send a SYN?
 */
com_check_utmp()
{
static time_t last_change=0;
struct stat sb;
int fd;
struct utmp ut;
struct utmp_list *ul, *tul;
int c;

if (stat("/etc/utmp", &sb)<0) return; /* Oh well? */
if (sb.st_mtime==last_change) return; /* Nothing to do! */
/* 
 * We've short circuited all the obvious possibilities. Now we need to
 * actually do something... 
 */
last_change=sb.st_mtime;
if ((fd=open("/etc/utmp", O_RDONLY))<0) return; /* Oh well again... */
while (read(fd, &ut, sizeof(struct utmp))==sizeof(struct utmp)) {
	if (ut.ut_name[0]=='\0' || ut.ut_line[0]=='\0') continue; /*Blank entry*/
	ul=Master_utmp;
	if (ul==NULL) {
		Master_utmp=(struct utmp_list *)malloc(sizeof(struct utmp_list));
		ul=Master_utmp;
		ul->prev=NULL;
		ul->next=NULL;
		ul->data=(struct utmp *)malloc(sizeof(struct utmp));
		memcpy(ul->data, &ut, sizeof(struct utmp));
		push_twtch(ut.ut_line);
		continue;
	} else {
		c=1;
		while (ul->next!=NULL && (c=strncmp(ul->data->ut_line, ut.ut_line, 8))<0) 
			ul=ul->next; /* Find the tty */
		if (c == 0) { /* found it */
			if (ut.ut_name[0]=='\0') {
				ul->data->ut_time=0; /* offline */
				ul->data->ut_name[0]='\0';
			} else
			if (strncmp(ut.ut_name, ul->data->ut_name, 8) == 0) {
				if (ul->data->ut_time!=ut.ut_time) 
					push_twtch(ut.ut_line);
				ul->data->ut_time=ut.ut_time; /* Same person */
			} else {
				strncpy(ul->data->ut_name, ut.ut_name, 8);
				ul->data->ut_time=ut.ut_time;
				/* New user, push twtch on their stream */
				push_twtch(ut.ut_line);
			}
		} else { /* New tty in utmp */
			/* We're at the last entry of the list */
			tul=(struct utmp_list *)malloc(sizeof(struct utmp_list));
			tul->data=(struct utmp *)malloc(sizeof(struct utmp));
			memcpy(tul->data, &ut, sizeof(struct utmp));
			if (ul->next==NULL) { /* Insert at the end */
				tul->next=ul->next;
				tul->prev=ul;
				if (tul->next)
					tul->next->prev=tul;
				ul->next=tul;
			} else { /* Insert before this one */
				tul->next=ul;
				tul->prev=ul->prev;
				if (tul->prev)
					tul->prev->next=tul;
				ul->prev=tul;
			}
			if (ut.ut_name[0]!='\0') 
				push_twtch(ut.ut_line);
		}
	}
}
close(fd);
return;
}

push_twtch(dev)
char *dev;
{
int fd;
char name[64];
char device[80];
struct stat sb;
uid_t ouid;
extern int xv;

if (!strcmp(dev, "console")) return; /* XXX-Can't twtch console yet */
strcpy(device, "/dev/");
strcat(device, dev);
if (ttyfd>=0 && !strcmp(ttyname(ttyfd), device)) return; /* Skip ourselves */
if (xv==0 && !strcmp(ttyname(0), device)) return; 
	/* Don't list the curses output. Nasty results will occur */
if (stat(device, &sb)<0) return; /* can't stat? */
ouid=geteuid();
seteuid(sb.st_uid);
if ((fd=open(device, O_WRONLY|O_NDELAY))>=0 && ioctl(fd, I_LOOK, name)>=0) {
	if (strcmp(name, "twtch")) { /* Go ahead and push */
		if (ioctl(fd, I_PUSH, "twtch")<0) 
			perror("Can't push twtch");
	}
}
seteuid(ouid);
close(fd);
return;
}

/* pop all twtchs */
pop_twtchs()
{
int fd;
struct utmp_list *ul;
struct stat sb;
struct passwd *pw;
char device[80];
char name[80];

for (ul=Master_utmp;ul!=NULL;ul=ul->next) {
	strcpy(device, "/dev/");
	strcat(device, ul->data->ut_line);
	if (stat(device, &sb)<0) continue;
	if ((pw=getpwnam(ul->data->ut_name))==NULL) continue;
	if (pw->pw_uid == sb.st_uid) {
		if ((fd=open(device, O_RDWR|O_NDELAY))<0) continue;
		if (ioctl(fd, I_LOOK, name)<0) { close(fd); continue; }
		if (!strcmp(name, "twtch"))
			ioctl(fd, I_POP, 0);
		close(fd);
	}
}
return;
}

