/* Hash Functions */

/*
 * Copyright (c) 1995  En Garde Systems. All rights reserved.
 *    
 * Redistribution and use in source and binary forms, with or without    
 * modification, for NON COMMERCIAL USE are permitted provided that: 
 * (1) source code distributions retain the above copyright notice and this 
 * paragraph in its entirety, and (2) distributions including binary code 
 * include the above copyright notice and this paragraph in its entirety in 
 * the documentation or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * For commercial use or modification of this program, contact:
 * En Garde Systems
 * 525 Clara Avenue, Suite 202
 * St. Louis, MO  63112
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <sys/time.h>
#include <time.h>

#include <math.h>
#include <fcntl.h>
#include <sys/param.h>

#include <sys/stropts.h>
#include <errno.h>
#include <unistd.h>
#include <malloc.h>
#include <pwd.h>

#ifdef SOLARIS
#include <sys/mkdev.h>
#endif

#include "ses_packet.h"

extern int current_mode;

extern struct con *con_hash[HASHSIZE];
extern struct con *current;
extern int raw_log, erase_issyn;
extern time_t gtime;
extern int reachedEOF;
extern int lastsaveddatalen;
extern int xv;

struct con *row_list=NULL;
int active=0;

static char *RCSid="$Id: hash.c,v 1.4 1995/06/14 04:41:09 mcn Exp $";

int hash(uid, dev)
uid_t uid;
dev_t dev;

{
int result;
/* 
 * Simple hash algorithm... Add up dev and uid, modulo HASHSIZE.
 * 
 *  (uid % HASHSIZE + dev % HASHSIZE) % HASHSIZE
 */

result = uid % HASHSIZE;
result += dev % HASHSIZE;
result = result % HASHSIZE;
return result;
}

delete_hash(uid, dev)
uid_t uid;
dev_t dev;

{
int x;
struct con *cp, *pcp, *nrl, *prl;
int found=0, i;

x=hash(uid, dev);
cp=con_hash[x];
pcp=NULL;
while (!found) {
  if (cp==NULL) return;
  if (cp->uid==uid && cp->dev==dev)
		break;
  pcp=cp;
  cp=cp->next;
} /* of while !found */
/* Now the name entry is found and stored in 'cp' */
i=0;
prl=NULL;
nrl=row_list;
while (nrl!=NULL) {
  if (nrl->uid == uid && nrl->dev == dev) {
	i=1;
	break;
  }
  found++;
  prl = nrl;
  nrl = nrl->next;
}
if (i) {
 if (prl) 
   prl->next = nrl->next;
 else
   row_list = nrl->next;
 free((char *)nrl);
 active--;
 if (xv) {
	delete_row(found);
 } else 
	curses_delete_row(found);
}
if (cp==current) {
	if (xv) {
  		if (reachedEOF)
			set_status_label("    * EOF *","red");
  		else
			set_status_label("    * DEAD *","red");
  		select_row(-1);
	}
  	current = NULL;
}
if (pcp) {
  pcp->next = cp->next;
  free((char *)cp);
} else  {
    con_hash[x] = cp->next;
    free((char *)cp);
  }
return;
}

#ifdef SOLARIS
char *dev_to_tty(dev)
dev_t dev;
{
static char buf[16];

switch(major(dev)) {
	case 29: /* /dev/term/{a,b} */
		sprintf(buf, "/dev/term/%c", ((char)(minor(dev) + 'a')));
		break;
	case 24: /* /dev/pts/[0-47] */
		sprintf(buf, "/dev/pts/%d", minor(dev));
		break;
	case 0:
		strcpy(buf, "/dev/console");
		break;
	default:
		strcpy(buf, "UNKNOWN");
		break;
}
return(buf);
}

#else
static char *TtyNumber = "0123456789abcdef";
/* Macros for turning a dev into a /dev/ttyxx */
#define TTYFAMILY(x) ((char)(x) + 'p')
#define TTYNUMBER(x) ((char)(TtyNumber[(x)]))

char *dev_to_tty(dev)
dev_t dev;
{
static char buf[16];

switch(major(dev)) {
	case 12: /* /dev/ttya,/dev/ttyb */
		sprintf(buf, "/dev/tty%c", ((char)(minor(dev)%15) + 'a'));
		break;
	case 20: /* /dev/ttypa->/dev/ttys* */
		sprintf(buf, "/dev/tty%c%c", 
			TTYFAMILY((int)(minor(dev)/16)), TTYNUMBER(minor(dev)%15));
		break;
	case 0: /* /dev/console */
		sprintf(buf, "/dev/console");
		break;
	default:
		strcpy(buf, "UNKNOWN");
		break;
}
return(buf);
}
#endif

add_hash(uid, dev, is_syn, from, data, data_len)
uid_t uid;
dev_t dev;
char from;
char is_syn, *data;
int  data_len;
{
extern int current_input;
char buf[80];
struct con *cp, *nrl, *nrlp;
int x, row;
struct log_packet lp;
struct passwd *pw;

if (data_len==0 && is_syn==0) return; /* If data_len=0,and isn't syn, don'tadd*/
x = hash(uid, dev);
cp = con_hash[x];
while (cp != NULL) {
   if (cp->uid == uid && cp->dev == dev) {
		/* Nothing to add, this is the same entry */
		cp->last_packet = gtime;
	    if (from==FROM_SYS)
			circle_copy(data, data_len, cp->scbuf, 
				&cp->scbegin, &cp->scend, 2048);
	    else 
			circle_copy(data, data_len, cp->csbuf,
				&cp->csbegin, &cp->csend, 80);
	    cp->bytes_sent+=data_len;
	    if (cp->bytes_sent>99999) cp->bytes_sent=99999;
		switch(cp->log) {
	  	 case 1: /* raw */
		     lp.from=from;
		     lp.type=TYPE_DATA;
		     lp.uid=uid;
		     lp.dev=dev;
		     lp.time = gtime;
		     lp.data_len=data_len;
		     lp.last_datalen = lastsaveddatalen;
		     write(raw_log, (char *)&lp, sizeof(struct log_packet));
		     if (data_len>0) {
				write(raw_log, data, data_len);
				lastsaveddatalen = data_len;
		     } else lastsaveddatalen=0;
		     break;
		   case 2: /* text file */
		     if (from==FROM_SYS && data_len>0)
				write(cp->logfd, data, data_len);
		     break;
		   default:
		     break;
		}
		return;
	}
	if (cp->next == NULL) {
		cp->next = (struct con *)malloc(sizeof(struct con));
		cp = cp->next;
		cp->next = NULL;
        break;
   }
   /* If we're here, there must be another entry in the linked list, and
    * the current one is not interesting
    */
   cp = cp->next;
}
if (cp == NULL && is_syn==-1) {
	/* This was an ACK only packet for a NEW connection. toss it */
	return;
}
if (cp == NULL) {
	cp = (struct con *)malloc(sizeof(struct con));
	cp->next = NULL;
	con_hash[x] = cp;
}
cp->uid      = uid;
cp->dev      = dev;
pw=getpwuid(uid);
if (pw!=NULL)
	strncpy(cp->username, pw->pw_name, 15);
else
	strcpy(cp->username, "UNKNOWN");

sprintf(cp->name, "%-16s  [%s]", cp->username, dev_to_tty(dev));
cp->ttystatus = 0; /* Normal */
cp->last_packet = gtime;
bzero(cp->scbuf,2048);
bzero(cp->csbuf,80);
bzero(cp->logfile,60);
cp->log=(-2); /* Text by default */
cp->logfd=-1;
cp->scbegin=0;
cp->scend=0;
cp->csbegin=0;
cp->csend=0;
cp->bytes_sent=((data_len>0) ? data_len:0);
cp->last_bytes_sent=cp->bytes_sent;
cp->next=NULL;

active++;
nrl = (struct con *)malloc(sizeof(struct con));
nrl->uid = uid;
nrl->dev = dev;
nrl->bytes_sent = (int)cp;
nrl->next = NULL;

nrlp=row_list;
row=1;
while (nrlp!=NULL && nrlp->next!=NULL && minor(nrlp->next->dev)<minor(dev)) {
	row++;
	nrlp=nrlp->next;
}
/* 3 possibilities here. 
 * 1) nrlp is NULL. 
 * 2) nrlp->next=NULL. 
 * 3) Insert nrl after nrlp and before nrlp->next
 */
if (row_list==NULL) {
	row_list = nrl;
	row=0;
} else {
	if (nrlp->next==NULL) {
		nrlp->next=nrl;
		if (nrlp==row_list) 
			row=1;
	} else {
		nrl->next=nrlp->next;
		nrlp->next=nrl;
	}
}
sprintf(buf,"%-34s  %5d",cp->name, cp->bytes_sent);
if (xv) {
	add_row(buf, (int)cp, row);
	if (is_syn) {
   		 strcpy(buf,"New con: ");
   		 strcat(buf,cp->name);
		 set_issyn_label(buf);
   		 erase_issyn = (-300);
  	 }
} else 
	curses_insert_row(buf, cp);
return;
}

int circle_copy(from, from_len, to, tobegin, toend, length)
char *from, *to;
int from_len, length;
short *tobegin, *toend;
{
register char *fptr;
register int  flength, remainder;

/* STEP 1: Only take the last bufsize bytes of the buffer. That's all that
 *         will fit into the resultant anyway, so don't bother copying useless
 *         data.
 */
if (from_len>length) {
	fptr=from+(from_len-length);
	flength=length;
} else {
	fptr=from;
	flength=from_len;
}
/* STEP 2: Figure out how much to copy and where */
if ((length-*toend)>flength) {
	/* Then we have enough room to simply "concatenate" the string */
	memcpy(to+*toend, fptr, flength);
	if (*tobegin==(*toend+1)%length) {
		/* Then we used to have a full circular buffer. Continue the trend */
		*toend+=flength;
		*tobegin=((*toend)+1)%length;
	} else 
	/*The begin pointer was still at 0: An un-full buffer. It's still not full*/
		*toend+=flength;
} else {
	/* Complex situation--Copy to end of buffer, and reset and copy rest */
	remainder=length-*toend;
	memcpy(to+*toend, fptr, remainder);
	memcpy(to, fptr+(length-*toend), flength-remainder);
	*toend=flength-remainder;
	*tobegin=(*toend+1)%length;
}
return(0);
}
