/* File Descriptor and initialization for TTY-Watcher */

/*
 * Copyright (c) 1995  En Garde Systems. All rights reserved.
 *    
 * Redistribution and use in source and binary forms, with or without    
 * modification, for NON COMMERCIAL USE are permitted provided that: 
 * (1) source code distributions retain the above copyright notice and this 
 * paragraph in its entirety, and (2) distributions including binary code 
 * include the above copyright notice and this paragraph in its entirety in 
 * the documentation or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * For commercial use or modification of this program, contact:
 * En Garde Systems
 * 525 Clara Avenue, Suite 202
 * St. Louis, MO  63112
 */


#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>

#include <sys/time.h>
#include <time.h>

extern time_t pkt_time;

int twtchfd;

static char *RCSid="$Id: init.c,v 1.1.1.1 1995/06/12 17:38:19 mcn Exp $";

int init()
{
pkt_time=0;

open_twtch();
com_check_utmp();
return(0); /* Fix this so it initializes the streams modules et al. */
}

open_twtch()
{
	if ((twtchfd=open("/dev/twtchc", O_RDWR|O_NDELAY))<0) {
		perror("Can't open twtchc");
		exit(1);
	}
}

close_twtch()
{
	close(twtchfd);
}
