/* main & mainloop part of TTYwatch project.  */

/*
 * Copyright (c) 1995  En Garde Systems. All rights reserved.
 *    
 * Redistribution and use in source and binary forms, with or without    
 * modification, for NON COMMERCIAL USE are permitted provided that: 
 * (1) source code distributions retain the above copyright notice and this 
 * paragraph in its entirety, and (2) distributions including binary code 
 * include the above copyright notice and this paragraph in its entirety in 
 * the documentation or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * For commercial use or modification of this program, contact:
 * En Garde Systems
 * 525 Clara Avenue, Suite 202
 * St. Louis, MO  63112
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/stat.h>

#include <sys/time.h>
#include <time.h>

#include <math.h>
#include <fcntl.h>
#include <sys/param.h>
#include <unistd.h>
#include <pwd.h>

#include "ses_packet.h"

struct con *con_hash[HASHSIZE];
int watchfd;
int erase_issyn=0, current_input=1, mapped=0, raw_log=-1;
int ttyfd=-1,paused=0,playspeed=1;
time_t gtime;
struct con *current=NULL;
int reachedEOF=0;
char *interface=NULL;
extern int com_quit();

int xv=0;

/* in order to properly "rewind" files, we need to save how long the data was */
int lastsaveddatalen=-1;

static char *RCSid="$Id: main.c,v 1.7 1995/06/22 22:46:55 mcn Exp $";

main(argc,argv)
int argc;
char *argv[];
{
void quit(),which_choice(),main_loop(), toggle_purge(), choose_input();
void purge_slider_notify();
extern int init();
int i;
void hose();
struct stat sb;
int lfd;
int disp_usage=0;
int c;

if (getenv("DISPLAY")!=NULL) xv=1;
while ((c = getopt(argc, argv, "?hvc")) != -1) {
	switch(c) {
		case 'h': /* help */
		case 'v': /* version */
		case '?': /* confusion */
			disp_usage++;
			break;
		case 'c': /* curses */
			xv=0;
			break;
		default: /* Shouldn't happen, but... */
			break;
	}
}
if (disp_usage) { /* Display usage and quit */
	fprintf(stderr,"TTY-Watcher version %s\n", VERSION);
	fprintf(stderr,"Usage: %s [-c]\n", argv[0]);
	fprintf(stderr,"-c   turns on curses interface\n");
	exit(0);
}
umask(027);
signal(SIGHUP, SIG_IGN);
signal(SIGINT, com_quit);
for (i = 0;i < HASHSIZE;i++) 
  con_hash[i] = NULL;
if (geteuid()!=0) 
	fprintf(stderr,"NOTE: Running without root privileges will only allow you to monitor yourself.\n");
/* Now, make sure the twtch device is installed */
lfd=-1;
if (stat("/dev/twtchc", &sb)<0 || (lfd=open("/dev/twtchc", O_RDONLY))<0) {
	if (lfd>=0) close(lfd);
	fprintf(stderr,"...Attempting to install twtch module\n");
#ifdef SOLARIS
	if (system("cd twtch;make -f Makefile.solaris;make -f Makefile.solaris doit")!=0 ||
#else
	if (system("cd twtch;make;make doit")!=0 || 
#endif
		stat("/dev/twtchc",&sb)<0 ||
		(lfd=open("/dev/twtchc", O_RDONLY))<0) {
		fprintf(stderr, "...FAILED! You must install the twtch module by hand. See the twtch README.\n");
		exit(1);
	}
}
if (lfd>=0) close(lfd);
time(&gtime);
if (xv)
	create_windows(argc, argv);
else
	init_screen(); /* Init curses stuff */
init();

/* 
 * Yes, the following segment is redundant, but it eliminates the constant
 * checking of 'xv' every iteration of the loop
 */
if (xv)
	while(1) {
		/* Update every update now. Used to be every two updates, but it
		 * doesnt' seem to make any difference on CPU usage... Both block
		 * (momentarily) in a read...
		 */
		update_windows();   /* Update windows */
		main_loop(); /* Handle packets */
	}
else 
	while(1) {
		notify_curses();
		main_loop(); /* Handle packets */
	}
}

u_long lastack=0;
time_t ptime=0, delta_time=0;

void main_loop()
{
int count=0, written=0;
time_t timenow;
register struct ses_packet *packet;
extern struct ses_packet *read_packet(), *read_log();
static int ticks=0;
struct log_packet lp;
char buf[80];
static time_t lasttimeCT=0, lasttimeLP=0;
static int tick_frequency=50; /* Update time every 50 updates */
extern int curses_fullscreen;
fd_set fdset;
struct timeval to;
/* 
 *   call getpacket routine
 *      If it's for a new session, add to active list, and update window
 *      If it's for the connection we have selected, send it to the tty win
 *    return
 *
 *      struct con *current  points to current active connection
 *         NULL means no active
 */
erase_issyn++;
if (current_input) {
	/* FIRST, READ THE PACKET */
   packet = read_packet();

	if (xv==0) {
		/* NEXT, UPDATE OUR IDEA OF TIME */
		if (ticks&tick_frequency) { /* Ocassionally update time - 
								 	 * tick frequency is a power of 2 */
			ticks=0;
			(void)time(&gtime); 
			if (gtime==lasttimeCT)
				tick_frequency<<=1; /* Updating too often (*2) */
			else 
			if (gtime>=(lasttimeCT+2) && tick_frequency>1)
				tick_frequency>>=1; /* Updating too infrequently */
		}
	} /* 
	   * If xv, then let the notify function do it 
	   * XXX-NOTE: This may be fixed with the setitimer stuff in curses
	   */
} else {
	/* FIRST, READ THE PACKET FROM THE LOG */
   packet = read_log(watchfd, &ptime);

   /* IF REACHED EOF, DELETE CURRENT */
   if (!packet && reachedEOF && current)
	delete_hash(current->uid, current->dev);

	/* NEXT, UPDATE OUR IDEA OF TIME */
    if (delta_time==0) { /* Update the packet time. This is confusing... */
        if (ptime==0)
                (void)time(&gtime);
        else {
                gtime=ptime;
                delta_time=time(0)-gtime;
        }
    } else {
		time(&timenow);
		if (!paused) {
			if (gtime+delta_time<timenow)
				gtime++;
			if ((playspeed!=1)&&(!(gtime%playspeed)))
				delta_time-=(playspeed-1);
		} else {
			if (gtime+delta_time<timenow)
				delta_time++;
		}
    }
}
if (gtime!=lasttimeCT && mapped && current) {
	if (xv==1) {
		strftime(buf, 80, "CT: %H:%M:%S", localtime(&gtime));
		set_ct_time_label(buf);
		strftime(buf, 80, "    %D", localtime(&gtime));
		set_ct_date_label(buf);
	}
    lasttimeCT=gtime;
}
ticks++;
/* END OF MAINTENANCE SECTION. Previous section updates clocks, purges,
 * SYN labels, etc, all on a "realtime" basis
 *
 * START OF PACKET HANDLING SECTION */
if (packet) { /* If the current packet isn't a NULL, then handle it! */
	if (packet->data_len==-1) { /* A FIN/RST */
   		delete_hash(packet->uid, packet->dev);
   		return;
	}
 	if (current && current->uid==packet->uid && current->dev==packet->dev) { 
		/* This is the current connection then */
   			if (packet->from==FROM_SYS) {
					circle_copy(packet->data_buffer, packet->data_len,
						current->scbuf, &current->scbegin, &current->scend,
						2048);
					write_sc(packet->data_buffer,packet->data_len, 1);
					if (gtime!=lasttimeLP) {
						if (xv) {
							strftime(buf, 80, "LP: %H:%M:%S", 
								localtime(&gtime));
							set_lt_time_label(buf);
							strftime(buf, 80, "    %D", localtime(&gtime));
							set_lt_date_label(buf);
						}
						lasttimeLP=gtime;
						current->last_packet = gtime;
					}
			} else {
				circle_copy(packet->data_buffer, packet->data_len,
					current->csbuf, &current->csbegin, &current->csend,
					80);
   				write_cs(packet->data_buffer,packet->data_len);
   				if (gtime!=lasttimeLP) {
					if (xv) {
						strftime(buf, 80, "LP: %H:%M:%S",
							localtime(&gtime));
						set_lt_time_label(buf);
						strftime(buf, 80, "    %D", localtime(&gtime));
						set_lt_date_label(buf);
					}
					lasttimeLP=gtime;
					current->last_packet = gtime;
				}
   			}
			/* In all cases... */
			if (current->log==1) {
				lp.from=packet->from;
				lp.type=packet->type;
				lp.uid=packet->uid;
				lp.dev=packet->dev;
				lp.time=gtime;
				lp.data_len=packet->data_len;
				lp.last_datalen = lastsaveddatalen;
        		write(raw_log,(char *)&lp,sizeof(struct log_packet));
				if (lp.data_len>0) {
					write(raw_log, packet->data_buffer, lp.data_len);
					lastsaveddatalen = packet->data_len;
				} else lastsaveddatalen=0;
			}
  			written=1; /* This packet was written out */
	}
	if (written==0) { /* new connection or not the current connection*/
   		switch(packet->data_len) {
			case -2: /* This is a SYN packet */
				add_hash(packet->uid, packet->dev,
					1, (char)packet->from, NULL, 0);
				break;
			default: /* Otherwise, this is mid-connection */
     			add_hash(packet->uid, packet->dev,
					0, (char)packet->from, 
					packet->data_buffer, packet->data_len);
				break;
		}
	}
} /* if (packet) */
if (current && xv==1 && ttyfd>=0) { /* Curses read is handled elsewhere */
	FD_ZERO(&fdset);
	FD_SET(ttyfd, &fdset);
	to.tv_sec=0;
	to.tv_usec=0;
	if (select(255, &fdset, 0, 0, &to)>0) {
		count = read(ttyfd, buf, 80);
		if (count>0)
			send_packet(current->uid, current->dev, FROM_USER, buf, count);
	}
}
return;
}
