/* "Packet" Sender for TTY-Watcher Project */

/*
 * Copyright (c) 1995  En Garde Systems. All rights reserved.
 *    
 * Redistribution and use in source and binary forms, with or without    
 * modification, for NON COMMERCIAL USE are permitted provided that: 
 * (1) source code distributions retain the above copyright notice and this 
 * paragraph in its entirety, and (2) distributions including binary code 
 * include the above copyright notice and this paragraph in its entirety in 
 * the documentation or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * For commercial use or modification of this program, contact:
 * En Garde Systems
 * 525 Clara Avenue, Suite 202
 * St. Louis, MO  63112
 */

/* Functions to write TCP packets into a terminal session watched by
 * watcher */

#include <stdio.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <stropts.h>
#include <sys/stream.h>
#include <string.h>

#include "twtch.h"

static char *RCSid="$Id: sendpacket.c,v 1.2 1995/06/13 22:15:54 jnewman Exp $";

extern int twtchfd;

send_packet(uid, dev, direction, data, data_len)
uid_t uid;
dev_t dev;
char direction;
char *data;
int data_len;
{
char buf[4096];
struct packet *sp;

sp=(struct packet *)buf;
sp->from=direction; /* Either FROM_USER or FROM_SYS */
switch (data_len) {
	case -1:
		sp->type=TYPE_END;
		break;
	case -2:
		sp->type=TYPE_TRM;
		break;
	case -3:
		sp->type=TYPE_RSM;
		break;
	default:
		sp->type=TYPE_DATA;
		break;
}
sp->uid=uid;
sp->dev=dev;
if (data_len>0)
	memcpy(buf+sizeof(struct packet), data, data_len);
else
	data_len=0;

if (write(twtchfd, buf, sizeof(struct packet)+data_len)<0)
	perror("write");
}
