/* Loadable TWTCH STREAMS module */

/*
 * Copyright (c) 1995  En Garde Systems. All rights reserved.
 *    
 * Redistribution and use in source and binary forms, with or without    
 * modification, for NON COMMERCIAL USE are permitted provided that: 
 * (1) source code distributions retain the above copyright notice and this 
 * paragraph in its entirety, and (2) distributions including binary code 
 * include the above copyright notice and this paragraph in its entirety in 
 * the documentation or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * For commercial use or modification of this program, contact:
 * En Garde Systems
 * 525 Clara Avenue, Suite 202
 * St. Louis, MO  63112
 */


/* This is included by the driver */

/*
 * --- MODULE ---
 */

static int twtchopen(q, dev, flag, sflag, cred)
    queue_t *q;
    dev_t   *dev;
    int     flag;
    int sflag;
	cred_t *cred;
{
	register mblk_t *usmp, *nbp;
	register struct user_state *us, *tus;
	register struct packet *sp;
	int s;
    queue_t    *uq = twtch_twtch.twtch_queue;

	if ((usmp=allocb(sizeof(struct user_state), BPRI_MED)) == NULL)
		return(ENOMEM);
	
	usmp->b_wptr += sizeof(struct user_state);
	us = (struct user_state *)usmp->b_rptr;
	us->us_mblk = usmp;
	us->uid = cred->cr_uid;
	us->dev = *dev;
	us->q = q;
	us->pass = 1;
	us->next = NULL;

	s=splstr(); /* Enter "mutex" section */

	/* Put this user_state struct into the list */
	tus=twtch_USP;
	if (tus==NULL) 
		twtch_USP=us;
	else {
		while (tus->next!=NULL && tus->dev!=*dev) tus=tus->next;
		if (tus->dev==*dev) {
			/* Module already pushed for this device */
			freeb(usmp);
			return(0); /* Success anyway */
		}
		tus->next=us;
	}
	splx(s); /* Exit "mutex" section */

	q->q_ptr = (caddr_t)us;
	WR(q)->q_ptr = (caddr_t)us;

	if (uq && (nbp=allocb(sizeof(struct packet), BPRI_MED)) !=NULL) {
	   /* Send up a SYN packet */
		nbp->b_wptr += sizeof(struct packet);
		sp = (struct packet *)nbp->b_rptr;
		sp->from=FROM_SYS;
		sp->type=TYPE_SYN;
		sp->uid=us->uid;
		sp->dev=us->dev;
        putnext(uq,nbp);
	}

    twtchisopen++;
    return(0);  /* return success */
}

/* twtchwput - extremely trivial. If the TAP device is open, then get the
 * pointer to the queue. (uq). If the message going through is of DATA type,
 * simply copy it, and put it into the uq.
 *
 * We probably want to do something different like adding the username and
 * the direction of the message when we copy it or something.
 */

static int twtchwput(q, mp)
    queue_t    *q;
    mblk_t    *mp;
{
    mblk_t    *bp, *nbp;
    queue_t    *uq = twtch_twtch.twtch_queue;
	register struct packet *sp;
	register struct user_state *us=((struct user_state *)q->q_ptr);

    if(uq){     /* dup if twtchc is open */
        if(mp->b_datap->db_type==M_DATA){
            if((bp=dupmsg(mp))!=NULL &&
			   (nbp=allocb(sizeof(struct packet), BPRI_MED)) !=NULL) {
			   /* Duplicate the message and allocate a header block */
				nbp->b_wptr += sizeof(struct packet);
				sp = (struct packet *)nbp->b_rptr;
				sp->from=FROM_SYS;
				sp->type=TYPE_DATA;
				sp->uid=us->uid;
				sp->dev=us->dev;
				linkb(nbp, bp); /* Link bp to the tail of nbp */
                putnext(uq,nbp);
            }
			if (us->pass==0)
				freemsg(mp);
			else
				putnext(q, mp);
			return;
        }
    }
   	putnext(q,mp);
	return;
}

/* Also trivial. See twtchwput above. Just make a copy and pass it to the twtch
 * device!
 */

static int twtchrput(q, mp)
    queue_t    *q;
    mblk_t    *mp;
{
    mblk_t    *bp, *nbp;
    queue_t    *uq = twtch_twtch.twtch_queue;
	register struct packet *sp;
	register struct user_state *us=((struct user_state *)q->q_ptr);

    if(uq){     /* dup if twtchc is open */
        if(mp->b_datap->db_type==M_DATA){
            if((bp=dupmsg(mp))!=NULL && 
			   (nbp=allocb(sizeof(struct packet), BPRI_MED)) !=NULL) {
			   /* Duplicate the message and allocate a header block */
				nbp->b_wptr += sizeof(struct packet);
				sp = (struct packet *)nbp->b_rptr;
				sp->from=FROM_USER;
				sp->type=TYPE_DATA;
				sp->uid=us->uid;
				sp->dev=us->dev;
				linkb(nbp, bp); /* Link bp to the tail of nbp */
                putnext(uq,nbp);
            }
			if (us->pass==0)
				freemsg(mp);
			else
				putnext(q, mp);
			return;
        }
    }
   	putnext(q,mp);
}

static int twtchclose(q, flag)
    queue_t    *q;
    int    flag;
{
	queue_t	*uq = twtch_twtch.twtch_queue;
	register struct packet *sp;
	register struct user_state *ssp, *tsp;
	register mblk_t *bp;
	int s;

    twtchisopen--;
	ssp=(struct user_state *)q->q_ptr;
	if (uq) {
		if ((bp = allocb(sizeof(struct packet), BPRI_MED))==NULL) 
			return ENOMEM;
		bp->b_wptr += sizeof(struct packet);
		sp = (struct packet *)bp->b_rptr;
		sp->from=FROM_SYS;
		sp->type=TYPE_END;
		sp->uid=((struct user_state *)q->q_ptr)->uid;
		sp->dev=((struct user_state *)q->q_ptr)->dev;

		putnext(uq, bp);
	}
	s=splstr();

	tsp=twtch_USP; /* Remove this person from this list */
	if (tsp==ssp)
		twtch_USP=twtch_USP->next;
	else {
		while (tsp->next!=ssp) tsp=tsp->next;
		tsp->next=ssp->next;
	}
	splx(s);

	freeb(ssp->us_mblk);

	q->q_ptr=NULL;
	WR(q)->q_ptr=NULL;
}
