/* Simple monitor for the new twtch stuff */

/*
 * Copyright (c) 1995  En Garde Systems. All rights reserved.
 *    
 * Redistribution and use in source and binary forms, with or without    
 * modification, for NON COMMERCIAL USE are permitted provided that: 
 * (1) source code distributions retain the above copyright notice and this 
 * paragraph in its entirety, and (2) distributions including binary code 
 * include the above copyright notice and this paragraph in its entirety in 
 * the documentation or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * For commercial use or modification of this program, contact:
 * En Garde Systems
 * 525 Clara Avenue, Suite 202
 * St. Louis, MO  63112
 */


#include <stdio.h>
#include <fcntl.h>
#include <stropts.h>
#include <errno.h>
#include <sys/stream.h>

#include "twtch.h"

main()
{
int fd;
struct strbuf dataptr;
char buffer[1024];
int flags;
extern int errno;
struct packet *sp;

if ((fd=open("/dev/twtchc", O_RDONLY))<0) {
	perror("Can't open /dev/twtchc");
	exit(1);
}
dataptr.maxlen=1024;
dataptr.buf=buffer;
flags=0;
for (;;) {
	while (getmsg(fd, NULL, &dataptr, &flags)>=0) {
/*		write(1, dataptr.buf, dataptr.len); */
		sp=(struct packet *)dataptr.buf;
		printf("[ from: %s  dev: %d  type: %s  uid: %d ]\n",
			sp->from==FROM_USER ? "USER":"SYS",
			sp->dev,
			sp->type==TYPE_DATA ? "DATA":"END",
			sp->uid);
		fflush(stdout);
		write(1, dataptr.buf+sizeof(struct packet), 
			dataptr.len-sizeof(struct packet));
	}
	if (errno!=EWOULDBLOCK) {
		perror("getmsg");
		exit(1);
	} else
		sleep(1);
}
}

