/* The curses interface for TTY-Watcher */

/*
 * Copyright (c) 2000  En Garde Systems. All rights reserved.
 *    
 * Redistribution and use in source and binary forms, with or without    
 * modification, for NON COMMERCIAL USE are permitted provided that: 
 * (1) source code distributions retain the above copyright notice and this 
 * paragraph in its entirety, and (2) distributions including binary code 
 * include the above copyright notice and this paragraph in its entirety in 
 * the documentation or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * For commercial use or modification of this program, contact:
 * En Garde Systems
 * 4848 Tramway Ridge, Suite 122
 * Albuquerque, NM 87111
 */

/* There are two modes, one is the split screen mode with the connections on
 * top, the filtered sc_win, and the cs_win. The user can then hit 'f' to
 * go into full screen mode, where he gives up the cs_win, but gets an
 * unfiltered sc_win 
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/signal.h>

#include <sys/time.h>
#include <time.h>
#include <termios.h>
#include <curses.h>
#include <fcntl.h>
#include <sys/filio.h>
#include <errno.h>

#include "ses_packet.h"

static char *RCSid="$Id: curses.c,v 1.3 2000/03/03 17:10:50 mcn Exp $";

extern struct con *current;

WINDOW *connw, *scwin, *cswin, *hlpwin, *cmdwin, *statusw;
char *DASHES="--------------------------------------------------------------------------------";

int curses_fullscreen=0, curses_alarm();
static int lttyfd=-1;


init_screen()

{
struct itimerval value;

initscr();
flushinp();
cbreak();
noecho();

if (LINES < 24) {
	fprintf(stderr,"Need at least 24 lines\n");
	exit(1);
}
do_cool_borders();
statusw=subwin(stdscr, 8, 37, 2, 43);
scrollok(statusw, FALSE);
connw=subwin(stdscr, 8, 42, 2, 0);
scrollok(connw, FALSE);
scwin=subwin(stdscr, 11, 80, 11, 0);
scrollok(scwin, TRUE);
cswin=subwin(stdscr, 1, 80, 23, 0);
scrollok(cswin, FALSE);
cmdwin=subwin(stdscr, 1, 37, 0, 43);
mvwprintw(cmdwin, 0, 1, "Command:");
nodelay(cmdwin, TRUE);
keypad(cmdwin, TRUE);
refresh();
/* Setup ocasional maintenance alarms */
value.it_interval.tv_sec=1;
value.it_interval.tv_usec=0;
value.it_value.tv_sec=1;
value.it_value.tv_usec=0;
signal(SIGALRM, curses_alarm);
if (setitimer(ITIMER_REAL, &value, NULL)<0) {
	endwin();
	perror("Can't initialize maintenance daemon");
	exit(1);
}
return;
}

do_cool_borders()
{
mvprintw(0, 0, "TTY-Watcher v1.0 by En Garde Systems");
mvprintw(0, 42, "|");
mvprintw(1, 0,  DASHES);
mvprintw(1, 11, "Active Sessions");
mvprintw(1, 42, "+");
mvprintw(2, 42, "|");
mvprintw(3, 42, "|");
mvprintw(4, 42, "|");
mvprintw(5, 42, "|");
mvprintw(6, 42, "|");
mvprintw(7, 42, "|---------------- Keys ---------------");
mvprintw(8, 42, "| Arrow/VI Keys scroll, <ret> selects");
mvprintw(9, 42, "| [f]ullscreen mode, [q]uit");
mvprintw(1, 57, "Status");
mvprintw(10, 0, DASHES);
mvprintw(10,32, "Server -> Client");
mvprintw(22, 0, DASHES);
mvprintw(22,32, "Client -> Server");
}

redo_scwin(str, len)
char *str;
int len;
{
char buf[2048];

if (curses_fullscreen)
	write(1, str, len);
else {
	memset(buf, 0, 2048);
	strncpy(buf, str, len);
	waddstr(scwin, buf);
	wrefresh(scwin);
}
return;
}

redo_cswin(buf, n)
char *buf;
int n;
{
if (curses_fullscreen) return;
wmove(cswin, 0, 0);
waddnstr(cswin, buf, n);
wclrtoeol(cswin);
wrefresh(cswin);
return;
}

int top_conn=0;
int cur_conn=0;
int num_conn=0;

struct conn_struct {
	char label[80];
	int  value;
	char changed;
	struct conn_struct *next;
} *connections=NULL;

curses_insert_row(string, cp)
char *string;
int  cp;  /* Return value when this is selected */
{
struct conn_struct *cs, *csp;

cs=(struct conn_struct *)malloc(sizeof(struct conn_struct));
if (connections==NULL)  {
  connections=cs;
  top_conn=0;
  cur_conn=0;
} else {
  csp=connections;
  while (csp->next!=NULL) csp=csp->next;
  csp->next=cs;
}
strcpy(cs->label, string);
cs->value=cp;
cs->next=NULL;
cs->changed=1;
num_conn++;
do_connw(1);
return;
}

do_statusw()
{
char buf[80];
struct conn_struct *cs;
static char old_conn[80], old_status[80];
static int old_active; 
int changed=0;

if (curses_fullscreen) return;
cs=connections;
while (cs!=NULL && cs->value!=(int)current) cs=cs->next;
memset(buf, 0, 80);
if (current==NULL) strcpy(buf, "No active connection");
if (cs!=NULL) strncpy(buf, cs->label, 31);
if (strcmp(buf, old_conn)) {
	strcpy(old_conn, buf);
	mvwprintw(statusw, 0, 0, "Conn: %s", buf);
	if (strlen(buf)<31) wclrtoeol(statusw);
	changed=1;
}
if (current!=NULL) 
	strcpy(buf, "*ALIVE*"); /* Change this to logging when the time comes */
else
	strcpy(buf, "*DEAD* ");
if (strcmp(buf, old_status)) {
	strcpy(old_status, buf);
	mvwprintw(statusw, 1, 0, "Conn status : %s", buf);
	changed=1;
}
if (old_active!=num_conn) {
	old_active=num_conn;
	mvwprintw(statusw, 3, 0, "Active conns: %d  ", num_conn);
	changed=1;
}
if (changed) wrefresh(statusw);
}

do_connw(num)
int num;
{
struct conn_struct *cp;
int i;
int did_something=0;
static int lastnull=0;

if (curses_fullscreen) return;
if (connections==NULL) {
	top_conn=0;
	cur_conn=0;
	if (!lastnull) {
		werase(connw);
		wrefresh(connw);
		lastnull=1;
	}
	return;
}
lastnull=0;
cp=connections;
for(i=0;i<top_conn;i++)  {
	if (cp->changed) cp->changed=0;
	cp=cp->next;
}
while (cp!=NULL) {
	if (cp->changed || num) {
		did_something=1;
		cp->changed=0;
		if (i==cur_conn) {
			wstandout(connw);
			mvwprintw(connw, i-top_conn, 0, "%s%c", cp->label,
				(cp->value==(int)current ? '*' : ' '));
			wstandend(connw);
		} else
			mvwprintw(connw, i-top_conn, 0, "%s%c", cp->label,
				(cp->value==(int)current ? '*' : ' '));
	}
	cp=cp->next;
	i++;
	if (i-top_conn>=8) break;
}
for (;i-top_conn<8;i++) {
	wmove(connw, i-top_conn, 0);
	wclrtoeol(connw);
}
while (cp!=NULL) {
	cp->changed=0;
	cp=cp->next;
}
if (did_something) {
	if (top_conn>0) 
		mvprintw(1, 2, "/\\");
	else
		mvprintw(1, 2, "--");
	if (top_conn+8<num_conn) 
		mvprintw(10, 2, "\\/");
	else
		mvprintw(10, 2, "--");
	refresh();
	wrefresh(connw);
	do_statusw();
}
}

curses_delete_row(row)
int row;
{
struct conn_struct *cp, *lp;
int i;

cp=connections;
lp=connections;
for (i=0;i<row;i++) {
	lp=cp;
	cp=cp->next;
}
if (lp==cp && row!=0) {
	free(connections);
	connections=NULL;
} else {
	if (row==0)
		connections=cp->next;
	else
		lp->next=cp->next;
	if (cp->value==(int)current) {
		current=NULL;
		if (curses_fullscreen) 
			write(1, "\n[Connection Terminated]\n", 25);
	}
	free(cp);
}
num_conn--;
if (cur_conn>=num_conn) cur_conn=num_conn-1;
if (top_conn>=num_conn) top_conn=num_conn-1;
do_connw(1);
return;
}


curses_redo_row(row, title)
int row;
char *title;
{
struct conn_struct *cp;
int i;

cp=connections;
if (cp==NULL) return;
for (i=0;i<row;i++) cp=cp->next;
strcpy(cp->label, title);
cp->changed=1;
return;
}

void notify_curses()
{
int c, i;
struct conn_struct *cp;
int redo=0;
fd_set fdset;
struct timeval to;
static struct termios itio, tio;
char buf[1024];

if (curses_fullscreen) {
	FD_ZERO(&fdset);
	FD_SET(lttyfd, &fdset);
	if (current==NULL) {
		while (select(255, &fdset, 0, 0, NULL)<0 && errno==EINTR) ;
		tcsetattr(lttyfd, TCSAFLUSH, &itio);
		close(lttyfd);
		curses_fullscreen=0;
		do_cool_borders();
		wnoutrefresh(scwin);
		wnoutrefresh(cswin);
		wnoutrefresh(cmdwin);
		wnoutrefresh(statusw);
		doupdate();
		redo=1;
		return;
	}
	to.tv_sec=0;
	to.tv_usec=0;
	while (select(255, &fdset, 0, 0, &to)>0) {
		read(lttyfd, buf, 1);
		if (*buf=='~') {
			write(1, "[Escape Mode...]", 16);
			/* Wait a short period of time for the followup */
			to.tv_sec=2;
			to.tv_usec=0;
			FD_ZERO(&fdset);
			FD_SET(lttyfd, &fdset);
			c=select(255, &fdset, 0, 0, &to);
			if (c<0 && errno==EINTR) {/*Then the alarm went off, try once more*/
				to.tv_sec=1; /* Don't wait forever */
				to.tv_usec=0;
				FD_ZERO(&fdset);
				FD_SET(lttyfd, &fdset);
				c=select(255, &fdset, 0, 0, &to);
			}
			if (c>0) {
				write(1, "\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b", 48); /* Back up over old stuff */
				while ((c=read(lttyfd, buf, 1))<0 && errno==EINTR) ;
				if (c<=0) return;
				switch (*buf) {
					case '~': *buf='~';
							  send_packet(current->uid, current->dev, FROM_USER,
										  buf, 1);
							  break;
					case '.': tcsetattr(lttyfd, TCSAFLUSH, &itio);
							  close(lttyfd);
							  curses_fullscreen=0;
							  do_cool_borders();
							  wnoutrefresh(scwin);
							  wnoutrefresh(cswin);
							  wnoutrefresh(cmdwin);
							  wnoutrefresh(statusw);
							  doupdate();
							  redo=1;
							  break;
					case '?': sprintf(buf, "\n[  =TTY-Watcher Commands=   ]\n[ ~? Print out this message ]\n[ ~. Go back to normal mode ]\n[ ~~ Send a '~'             ]\n[ ~s Steal the current TTY  ]\n[ ~n Return the current TTY ]\n[ ~t Terminate the TTY      ]\n[ Currently, TTY is: %s ]\n", current->ttystatus==0 ? "NORMAL":"STOLEN");
							  write(1, buf, strlen(buf));
							  break;
					case 's': current->ttystatus=1;
							  /* Stop data from passing to user */
							  send_packet(current->uid, current->dev, 
										  FROM_SYS, NULL, -2);
							  strcpy(buf, "[TTY Stolen from User]\n");
							  write(1, buf, strlen(buf));
							  break;
					case 'n': current->ttystatus=0;
							  /* Resume data passing to user */
							  send_packet(current->uid, current->dev,
											FROM_SYS, NULL, -3);
							  strcpy(buf, "[TTY Returned to User]\n");
							  write(1, buf, strlen(buf));
							  break;
					case 't': /* Kill connection */
							  com_sendrst();
							  break;
					default:  buf[1]=buf[0]; buf[0]='~';
							  send_packet(current->uid, current->dev, FROM_USER,
										  buf, 2);
							  break;
				}
			} else
				write(1, "\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b\b \b", 48); /* Back up over old stuff */
/*				send_packet(current->uid, current->dev, FROM_USER, buf, 1); */
/* Uncomment previous line if you want the ~ sent after a timeout anyway */
		} else
			send_packet(current->uid, current->dev, FROM_USER, buf, 1);
		to.tv_sec=0;
		to.tv_usec=0;
		FD_ZERO(&fdset);
		FD_SET(lttyfd, &fdset);
	}
	return;
}
if ((c=mvwgetch(cmdwin, 0, 9))!=ERR)
	switch(c) {
		case 'j':
		case 'J':
		case KEY_DOWN:
			if (cur_conn+1<num_conn) {
				cur_conn++;
				if (cur_conn-top_conn>=8) top_conn++;
				redo=1;
			}
			break;
		case 'k':
		case 'K':
		case KEY_UP:
			if (cur_conn>0) {
				cur_conn--;
				if (cur_conn<top_conn) top_conn--;
				redo=1;
			}
			break;
		case '\r':
		case '\n': 
			cp=connections;
			for (i=0;i<cur_conn;i++) cp=cp->next;
			if (cp==NULL) break;
			current=(struct con *)cp->value;
			werase(scwin);
			werase(cswin);
			wrefresh(scwin);
			wrefresh(cswin);
			dump_bufs(current);
			redo=1;
			break;
		case 'f':
		case 'F':
			if (current==NULL) return;
			curses_fullscreen=1;
			lttyfd=open("/dev/tty", O_RDWR);
			if (lttyfd<0) 
				lttyfd=0;
			endwin();
			/* Put the terminal in CBREAK here */
			tcgetattr(lttyfd, &tio);
			itio=tio;
			tio.c_cc[VMIN] = 1;
			tio.c_cc[VTIME] = 0;
			tio.c_lflag &= ~(ECHO|ICANON|ECHOE|ECHOK|ECHONL|ISIG);
			tcsetattr(lttyfd, TCSAFLUSH, &tio);
			write(lttyfd, "\033[2J\033[0;0H", 10);
			dump_bufs(current);
			break;
		case '': redo=1; break;
		case 'q':
		case 'Q': endwin();
				  com_quit();
				  exit(0);
		default: break;
	} /* of switch */
do_connw(redo);
return;
} /* of routine */

curses_alarm()
{
/* Maintenance routine. Just stat utmp every 4 seconds now */
static int ticks=0;
extern time_t gtime;

gtime++; /* Every second, increment gtime */
if (ticks & 4) {
	ticks=0;
	redo_titles();
	com_check_utmp();
}
signal(SIGALRM, curses_alarm);
return;
}
