/* main & mainloop part of TTYwatch project.  */

/*
 * Copyright (c) 2000  En Garde Systems. All rights reserved.
 *    
 * Redistribution and use in source and binary forms, with or without    
 * modification, for NON COMMERCIAL USE are permitted provided that: 
 * (1) source code distributions retain the above copyright notice and this 
 * paragraph in its entirety, and (2) distributions including binary code 
 * include the above copyright notice and this paragraph in its entirety in 
 * the documentation or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * For commercial use or modification of this program, contact:
 * En Garde Systems
 * 4848 Tramway Ridge, Suite 122
 * Albuquerque, NM 87111
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/signal.h>
#include <sys/stat.h>

#include <sys/time.h>
#include <time.h>

#include <math.h>
#include <fcntl.h>
#include <sys/param.h>
#include <unistd.h>
#include <pwd.h>
#include <stdlib.h>

#include "ses_packet.h"

/* Globally important variables */
struct con *con_hash[HASHSIZE], *current=NULL;
int watchfd, erase_issyn=0, current_input=1, mapped=0, raw_log=-1;
int ttyfd=-1,paused=0,playspeed=1, reachedEOF=0;
time_t gtime;
char *interface=NULL;

int xv=0;

static char *RCSid="$Id: main.c,v 1.10 2000/03/03 17:10:51 mcn Exp $";

main(argc,argv)
int argc;
char *argv[];
{
void main_loop();
extern int com_quit(), init();
int i;
struct stat sb;
int lfd;
int disp_usage=0;
int c;
void (*window_update_function)();
extern int optind;
extern void update_windows(), notify_curses();

if (getenv("DISPLAY")!=NULL) xv=1;
while ((c = getopt(argc, argv, "?hvc")) != -1) {
	switch(c) {
		case 'h': /* help */
		case 'v': /* version */
		case '?': /* confusion */
			disp_usage++;
			break;
		case 'c': /* curses */
			xv=0;
			break;
		default: /* Shouldn't happen, but... */
			break;
	}
}
if (disp_usage || optind!=argc) { /* Display usage and quit */
	fprintf(stderr,"TTY-Watcher version %s\n", VERSION);
	fprintf(stderr,"Usage: %s [-c]\n", argv[0]);
	fprintf(stderr,"-c   turns on curses interface\n");
	exit(0);
}
/* Initialize umask and signals */
umask(027);
signal(SIGHUP, SIG_IGN);
signal(SIGINT, com_quit);

/* Initialize hash table */
for (i = 0;i < HASHSIZE;i++) 
	con_hash[i] = NULL;

/* Complin if we aren't the right uid */
if (geteuid()!=0) 
	fprintf(stderr,"NOTE: Running without root privileges will only allow you to monitor yourself.\n");
/* Now, make sure the twtch device is installed */
lfd=-1;
if (stat("/dev/twtchc", &sb)<0 || (lfd=open("/dev/twtchc", O_RDONLY))<0) {
	if (lfd>=0) close(lfd);
	fprintf(stderr,"...The twtch module isn't installed. You must perform the following\n");
	fprintf(stderr,"steps before executing TTY-Watcher:\n");
	fprintf(stderr,"%% cd twtch\n");
#ifdef SOLARIS
	fprintf(stderr,"%% make -f Makefile.solaris\n");
	fprintf(stderr,"%% make -f Makefile.solaris doit\n");
#else
	fprintf(stderr,"%% make\n");
	fprintf(stderr,"%% make doit\n");
#endif
	exit(1);
}
if (lfd>=0) close(lfd);
time(&gtime);
if (xv) {
	create_windows(argc, argv);	/* Init xview */
	window_update_function=update_windows;
} else {
	init_screen();		/* Init curses */
	window_update_function=notify_curses;
}
init(); /* Initialize system functions */

for (;;) {
	(*window_update_function)();
	main_loop();
}
}

u_long lastack=0;
time_t ptime=0, delta_time=0;

void main_loop()
{
int count=0, written=0;
time_t timenow;
register struct ses_packet *packet;
extern struct ses_packet *read_packet(), *read_log();
struct log_packet lp;
char buf[80];
static time_t lasttimeCT=0, lasttimeLP=0;
static int tick_frequency=50; /* Update time every 50 updates */
extern int curses_fullscreen;
fd_set fdset;
struct timeval to;
/* 
 *   call getpacket routine
 *      If it's for a new session, add to active list, and update window
 *      If it's for the connection we have selected, send it to the tty win
 *    return
 *
 *      struct con *current  points to current active connection
 *         NULL means no active
 */
erase_issyn++;
if (current_input) {
	packet = read_packet(); /* READ THE PACKET from the system*/
} else {
	/* FIRST, READ THE PACKET FROM THE LOG */
	packet = read_log(watchfd, &ptime);

	/* IF REACHED EOF, DELETE CURRENT */
	if (!packet && reachedEOF && current)
		delete_hash(current->uid, current->dev);

	/* NEXT, UPDATE OUR IDEA OF TIME */
	if (delta_time==0) { 
		/* 
		 * Update the packet time. This is confusing... 
		 * Essentially, we update with "realtime", except we also
		 * need to account for skews when the user is 'pausing'
		 * or fast forwarding. In those cases, time moves faster
		 * than one tick per second
		 */
        	if (ptime==0)
                	(void)time(&gtime);
        	else {
                	gtime=ptime;
                	delta_time=time(0)-gtime;
        	}
    	} else {
		time(&timenow);
		if (!paused) {
			if (gtime+delta_time<timenow)
				gtime++;
			if ((playspeed!=1)&&(!(gtime%playspeed)))
				delta_time-=(playspeed-1);
		} else {
			if (gtime+delta_time<timenow)
				delta_time++;
		}
	}
}
if (gtime!=lasttimeCT && mapped && current) {
	if (xv==1) { /* Display the current time */
		strftime(buf, 80, "CT: %H:%M:%S", localtime(&gtime));
		set_ct_time_label(buf);
		strftime(buf, 80, "    %D", localtime(&gtime));
		set_ct_date_label(buf);
	}
    lasttimeCT=gtime;
}
/* 
 * END OF MAINTENANCE SECTION. Previous section updates clocks, purges,
 * SYN labels, etc, all on a "realtime" basis
 *
 * START OF PACKET HANDLING SECTION 
 */
if (packet!=NULL) { /* If the current packet isn't a NULL, then handle it! */
	if (packet->data_len==-1) { /* A FIN/RST */
   		delete_hash(packet->uid, packet->dev);
   		return;
	}
 	if (current && current->uid==packet->uid && current->dev==packet->dev) { 
		/* This is the current connection then */
		if (packet->from==FROM_SYS) {
			/* Add it to the data buffer */
			circle_copy(packet->data_buffer, packet->data_len,
				current->scbuf, &current->scbegin, 
				&current->scend, 2048);
			/* Write it to the screen */
			write_sc(packet->data_buffer,packet->data_len, 1);
			/* If the last packettime has changed, print it */
			if (gtime!=lasttimeLP) {
				if (xv) {
					strftime(buf, 80, "LP: %H:%M:%S", 
						localtime(&gtime));
					set_lt_time_label(buf);
					strftime(buf, 80, "    %D", localtime(&gtime));
					set_lt_date_label(buf);
				}
				lasttimeLP=gtime;
				current->last_packet = gtime;
			}
		} else { /* otherwise, the packet was from the user */
			circle_copy(packet->data_buffer, packet->data_len,
				current->csbuf, &current->csbegin, 
				&current->csend, 80);
   			write_cs(packet->data_buffer,packet->data_len);
   			if (gtime!=lasttimeLP) {
				if (xv) {
					strftime(buf, 80, "LP: %H:%M:%S",
						localtime(&gtime));
					set_lt_time_label(buf);
					strftime(buf, 80, "    %D", localtime(&gtime));
					set_lt_date_label(buf);
				}
				lasttimeLP=gtime;
				current->last_packet = gtime;
			}
   		}
		/* In all cases... */
		if (current->log==1) {
			lp.from=packet->from;
			lp.type=packet->type;
			lp.uid=packet->uid;
			lp.dev=packet->dev;
			lp.time=gtime;
			lp.data_len=packet->data_len;
        		write(raw_log,(char *)&lp,sizeof(struct log_packet));
			if (lp.data_len>0)
				write(raw_log, packet->data_buffer, lp.data_len);
		}
  		written=1; /* This packet was written out */
	}
	if (written==0) { /* new connection or not the current connection*/
   		switch(packet->data_len) {
			case -2: /* This is a SYN packet */
				add_hash(packet->uid, packet->dev,
					1, (char)packet->from, NULL, 0);
				break;
			default: /* Otherwise, this is mid-connection */
     				add_hash(packet->uid, packet->dev,
					0, (char)packet->from, 
					packet->data_buffer, packet->data_len);
				break;
		}
	}
} /* if (packet) */
if (current && xv==1 && ttyfd>=0) { /* Curses read is handled elsewhere */
	FD_ZERO(&fdset);
	FD_SET(ttyfd, &fdset);
	to.tv_sec=0;
	to.tv_usec=0;
	if (select(255, &fdset, 0, 0, &to)>0) {
		count = read(ttyfd, buf, 80);
		if (count>0)
			send_packet(current->uid, current->dev, FROM_USER, buf, count);
	}
}
return;
}
