/* Motif GUI interface for TTY-Watcher
 *
 * (c) 2000 En Garde Systems -- read COPYRIGHT
 */

#include <stdio.h>

#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleB.h>
#include <Xm/Scale.h>
#include <Xm/ScrolledW.h>
#include <Xm/MessageB.h>
#include <Xm/List.h>
#include <Xm/Form.h>
#include <Xm/LabelG.h>

#include "XmATerm.h"

#include <sys/filio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <net/if.h>
#include <netinet/if_ether.h>

#include <fcntl.h>
#include <errno.h>

#include "ses_packet.h"

Widget shell, frame;
Widget panel;
Widget mess_item, panel_item, input_item;
Widget error_item, type_item, mess_item2, mess_item2_5;
Widget mess_item3, mess_item3_5, hose_button;

Widget frame_tty, ttysw, textcs, panel_tty;

Widget lc_item, fi_item, fi2_item, ra_item, climess_item, mess_item4;
XtAppContext app;


void pause_playback(), FF_playback(), sendrst(), climessage(), hose();
static void out_cb(), key_cb();

extern struct con *current;
extern int mapped, current_mode, current_input;

static char *RCSid="$Id: motif.c,v 1.2 2000/03/03 17:10:52 mcn Exp $";

void log_current(item, client_data, cbs)
Widget      item;
caddr_t		client_data;
XmToggleButtonCallbackStruct *cbs;
{
com_log_current(cbs->set);
}

set_fi_value(label, active) 
char *label;
int active;
{
XmTextSetString(fi2_item, label);
XtSetSensitive(fi2_item, active);
}

set_ra_value(value)
int value;
{
XtVaSetValues(ra_item, XmNvalue, value, NULL);
}

set_lc_value(value)
int value;
{
XtVaSetValues(lc_item, XmNvalue, value, NULL);
}

void ss_choice(item, which, state)
Widget      item;
int         which;
XmToggleButtonCallbackStruct *state;
{
if (state->set)
	com_ss_choice(which);
}

void choose_input(item, which, state)
Widget      item;
int         which;
XmToggleButtonCallbackStruct *state;
{
if (state->set)
	com_choose_input(which);
}

char *get_filename()
/* Return the filename to read data from */
{
static char retval[160];
char *text;

text=XmTextGetString(fi_item);
strcpy(retval, text);
XtFree(text);
return(retval);
}

char *get_filename2()
/* Return the filename at the bottom of the connection window */
{
static char retval[160];
char *text;

text=XmTextGetString(fi2_item);
strcpy(retval, text);
XtFree(text);
return(retval);
}

set_error_label(label)
char *label;
{
XmString str=XmStringCreateSimple(label);
XtVaSetValues(error_item, XmNlabelString, str, NULL);
XmStringFree(str);
}

set_input_item(value)
int value;
{
XtVaSetValues(input_item, XmNvalue, value, NULL);
}

struct clidata {
	int cp;
	struct clidata *next;
} *clientdata=NULL;

void which_choice(item, client_data, cbs)
Widget 	item; 
XtPointer client_data;
XmListCallbackStruct *cbs;

{
char *choice;
int i;
struct clidata *cd=clientdata;

XmStringGetLtoR(cbs->item, XmSTRING_DEFAULT_CHARSET, &choice);
for (i=0;i<cbs->item_position-1;i++)
	cd=cd->next;
com_which_choice(1, choice, cd->cp);
XtFree(choice);
};

create_login_windows()
{
  int  nonblock;
  char buf[80];
  Dimension width, height;
  Widget button;
  Position x, y;
  XmString label, label2;
  int master, slave;
  extern int ttyfd;
  static int openpty();

	frame_tty = XtVaCreatePopupShell(current->name,
		xmDialogShellWidgetClass, shell,
		XmNdeleteResponse, XmUNMAP,
		NULL);
	panel_tty = XtVaCreateWidget("panel_tty",
			xmFormWidgetClass, frame_tty,
			XmNorientation, XmVERTICAL,
			NULL);
	ttysw = XtVaCreateManagedWidget("ansiterm", xmAnsiTermWidgetClass,
					panel_tty, NULL);
	if (openpty(&master, &slave)) {
	  perror("can't create tty");
	  exit(1);
	}
	XtAppAddInput(app, master, (XtPointer)XtInputReadMask, out_cb, 
		      ttysw);
	XtAddCallback(ttysw, XtNkeyCallback, key_cb, &master);

    mess_item2 = XtVaCreateManagedWidget("CT: 00:00:00", 
			xmLabelGadgetClass, panel_tty, NULL);
    mess_item2_5 = XtVaCreateManagedWidget("    00/00/00",
			xmLabelGadgetClass, panel_tty, NULL);
    if (current->last_packet!=0) 
		strftime(buf, 80, "LP: %H:%M:%S", localtime(&current->last_packet));
    else
        strcpy(buf, "LP: 00:00:00");
    mess_item3 = XtVaCreateManagedWidget(buf,
			xmLabelGadgetClass, panel_tty, NULL);
    if (current->last_packet!=0)
		strftime(buf, 80, "    %D", localtime(&current->last_packet));
    else
		strcpy(buf, "    00/00/00");
    mess_item3_5 = XtVaCreateManagedWidget(buf,
			xmLabelGadgetClass, panel_tty, NULL);
    mess_item4 = XtVaCreateManagedWidget("      ALIVE",
			xmLabelGadgetClass, panel_tty, NULL);
    if (current_input) {
	  button=XtVaCreateManagedWidget("Terminate",
			xmPushButtonGadgetClass, panel_tty, NULL);
	  XtAddCallback(button, XmNactivateCallback, sendrst, NULL);

	  button=XtVaCreateManagedWidget("Send Message",
			xmPushButtonGadgetClass, panel_tty, NULL);
	  XtAddCallback(button, XmNactivateCallback, climessage, NULL);
    } else {
	  button=XtVaCreateManagedWidget("Pause playback",
			xmPushButtonGadgetClass, panel_tty, NULL);
	  XtAddCallback(button, XmNactivateCallback, pause_playback, NULL);

	  button=XtVaCreateManagedWidget(" FF ",
			xmPushButtonGadgetClass, panel_tty, NULL);
	  XtAddCallback(button, XmNactivateCallback, FF_playback, NULL);
    }
    textcs= XtVaCreateManagedWidget("Client->Server",
		xmScrolledWindowWidgetClass, panel_tty,
		XmNscrollingPolicy, 	XmAPPLICATION_DEFINED,
		XmNvisualPolicy,    	XmVARIABLE,
		XmNscrollBarDisplayPolicy, XmSTATIC,
		XmNshadowThickness, 	2,
		XmNrows,    	    	1,
		XmNcolumns, 	    	80,
		XmNeditable,	    	False,
		NULL);

    if (current_input)
 	   climess_item=XtVaCreateManagedWidget("Client Message: ",
			xmTextFieldWidgetClass, panel_tty,
			XmNcolumns, 60,
			NULL);

    lc_item=XtVaCreateManagedWidget("Save Session",
			xmToggleButtonWidgetClass, panel_tty,
			XmNvalue, (current->log>0 ? 1: 0),
			NULL);
	XtAddCallback(lc_item, XmNvalueChangedCallback, log_current, NULL);

	label = XmStringCreateSimple("Raw");
	label2 = XmStringCreateSimple("Text");

	ra_item=XmVaCreateSimpleRadioBox(panel_tty, "As:",
			(current->log==1 ? 0 : 1),
			ss_choice,
			XmVaRADIOBUTTON, label, NULL, NULL, NULL,
			XmVaRADIOBUTTON, label2, NULL, NULL, NULL,
			NULL);

	XtManageChild(ra_item);

 	fi2_item=XtVaCreateManagedWidget("Filename: ",
			xmTextFieldWidgetClass, panel_tty,
			XmNcolumns, 60,
			XmNvalue, current->logfile,
			NULL);
	mapped = 1;
	XtManageChild(panel_tty);
	XtPopup(frame_tty, XtGrabNone);
	dump_bufs(current);
	ttyfd = slave;
	nonblock=1;
	ioctl(ttyfd, FIONBIO, &nonblock);
}

void quit(item,client_data, cbs)
Widget item;
XtPointer client_data;
XmPushButtonCallbackStruct *cbs;
{
com_quit();
}

kill_frame()
{
XtDestroyWidget(shell);
}

textcs_erase(start,fin)
int start,fin;
{
if (fin==-1) fin = XmTextGetLastPosition(textcs);
XmTextReplace(textcs, start, fin, NULL);
}

textcs_reset()
{
textcs_erase(0, -1);
}

textsc_insert(buf, x)
char *buf;
int x;
{
/*ttysw_output(ttysw, buf, x); */
/* FIX */
}


void pause_playback(item,client_data, cbs)
Widget item;
XtPointer client_data;
XmPushButtonCallbackStruct *cbs;
{
com_pause_playback();
}

void FF_playback(item,client_data, cbs)
Widget item;
XtPointer client_data;
XmPushButtonCallbackStruct *cbs;
{
com_FF_playback();
}

create_windows(argc, argv)
int argc;
char *argv[];
{
	XmString label, label2, label3;
	Widget button,button2,button3;
	int i;

	shell=XtVaAppInitialize(&app, "IP-Watcher", NULL, 0, &argc, argv, NULL, NULL);

	panel=XtVaCreateWidget("panel",
		xmFormWidgetClass, shell,
		XmNwidth, 276,
		XmNheight, 338,
		NULL);

	button=XtVaCreateManagedWidget("Quit",
		xmPushButtonGadgetClass, panel, 
		XmNtopAttachment, XmATTACH_FORM,
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopOffset, 5,
		XmNleftOffset, 5,
		NULL);

	XtAddCallback(button, XmNactivateCallback, quit, NULL);

	mess_item = XtVaCreateManagedWidget("",
		xmLabelGadgetClass, panel, 
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget,	button,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);

	button = XtVaCreateManagedWidget("Active Sessions",
		xmLabelGadgetClass, panel, 
		XmNtopAttachment,	XmATTACH_WIDGET,
		XmNtopWidget,           mess_item,
		XmNleftAttachment,	XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNleftOffset, 10,
		XmNrightOffset, 10, 
		NULL);

	panel_item = XmCreateScrolledList(panel, "a_sessions", NULL, 0);

	XtVaSetValues(panel_item,
		XmNvisibleItemCount,	10,
		XmNselectionPolicy,	XmSINGLE_SELECT,
		NULL);

	XtVaSetValues(XtParent(panel_item),
		XmNtopAttachment,	XmATTACH_WIDGET,
		XmNtopWidget,		button,
		XmNleftAttachment,	XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		XmNleftOffset, 10,
		XmNrightOffset, 10,
		NULL);

	XtManageChild(panel_item);
	
	XtAddCallback(panel_item, XmNsingleSelectionCallback, which_choice, NULL);
	/* Note--apparently you can't associate data with list entries! */

/*	add_row("***                None               ***", 0); */

	button2=XtVaCreateManagedWidget("Kill All Connections",
		xmPushButtonGadgetClass, panel, 
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopAttachment,	XmATTACH_WIDGET,
		XmNtopWidget,		panel_item,
		XmNrightAttachment, XmATTACH_FORM,
		XmNleftOffset, 10, 
		XmNrightOffset, 10,
		XmNtopOffset, 5,
		NULL);

	button = XtVaCreateManagedWidget("Input method:",
		xmLabelGadgetClass, panel, 
		XmNleftAttachment, XmATTACH_FORM,
		XmNtopAttachment,	XmATTACH_WIDGET,
		XmNtopWidget,		button2,
		XmNtopOffset, 10,
		XmNleftOffset, 10,
		XmNbottomOffset, 10,
		NULL);

	label = XmStringCreateSimple("File");
	label2 = XmStringCreateSimple("System");

    input_item = XmVaCreateSimpleRadioBox(panel, "radio_box",
		1,
		choose_input,
		XmVaRADIOBUTTON, label, NULL, NULL, NULL,
		XmVaRADIOBUTTON, label2, NULL, NULL, NULL,
		NULL);

	XtVaSetValues(input_item,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget,		button,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget,	button2,
		XmNrightAttachment, XmATTACH_FORM,
		XmNorientation,	XmHORIZONTAL,
		XmNleftOffset, 10,
		XmNrightOffset, 10, 
		XmNtopOffset, 5,
		XmNbottomOffset, 10,
		NULL);

	XtManageChild(input_item);
	XmStringFree(label);
	XmStringFree(label2);

	button2 = XtVaCreateManagedWidget("Filename:",
		xmLabelGadgetClass, panel,
		XmNleftAttachment,	XmATTACH_FORM,
		XmNtopAttachment,	XmATTACH_WIDGET,
		XmNtopWidget,		input_item,
		XmNleftOffset, 10,
		XmNrightOffset, 10, 
		XmNtopOffset, 10,
		XmNbottomOffset, 10,
		NULL);

	fi_item = XtVaCreateManagedWidget("filename",
		xmTextFieldWidgetClass, panel,
		XmNcolumns, 22,
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget,		button2,
		XmNtopAttachment,	XmATTACH_WIDGET,
		XmNtopWidget,		input_item,
		XmNrightAttachment, XmATTACH_FORM,
		XmNleftOffset, 10,
		XmNrightOffset, 10, 
		XmNtopOffset, 7,
		NULL);

	error_item =  XtVaCreateManagedWidget("",
		xmLabelGadgetClass, panel, 
		XmNleftAttachment, XmATTACH_WIDGET,
		XmNleftWidget,	   button2,
		XmNtopAttachment,	XmATTACH_WIDGET,
		XmNtopWidget,		fi_item,
		XmNleftOffset, 10,
		XmNrightOffset, 10, 
		XmNbottomOffset, 10,
		NULL);

	XtAddCallback(button, XmNactivateCallback, hose, NULL);

	XtManageChild(panel);

	XtRealizeWidget(shell);
}

update_windows()
{
XEvent event;
static Display *dpy=NULL;

if (dpy==NULL) dpy=XtDisplay(shell);
XFlush(dpy);
XmUpdateDisplay(shell);
while (XCheckMaskEvent(dpy,
	ButtonPressMask | ButtonReleaseMask | ButtonMotionMask |
	PointerMotionMask | KeyPressMask | KeyReleaseMask,
	&event))
		XtDispatchEvent(&event);
return;
}

set_frame_tty_label(label)
char *label;
{
XtVaSetValues(frame_tty, XmNtitle, label, NULL);
}

set_ct_time_label(label)
char *label;
{
XmString str=XmStringCreateSimple(label);
XtVaSetValues(mess_item2, XmNlabelString, str, NULL);
XmStringFree(str);
}

set_ct_date_label(label)
char *label;
{
XmString str=XmStringCreateSimple(label);
XtVaSetValues(mess_item2_5, XmNlabelString, str, NULL);
XmStringFree(str);
}

set_lt_time_label(label)
char *label;
{
XmString str=XmStringCreateSimple(label);
XtVaSetValues(mess_item3, XmNlabelString, str, NULL);
XmStringFree(str);
}

set_lt_date_label(label)
char *label;
{
XmString str=XmStringCreateSimple(label);
XtVaSetValues(mess_item3_5, XmNlabelString, str, NULL);
XmStringFree(str);
}

set_issyn_label(label)
char *label;
{
XmString str=XmStringCreateSimple(label);
XtVaSetValues(mess_item, XmNlabelString, str, NULL);
XmStringFree(str);
}

erase_issyn_label()
{
set_issyn_label("                                              ");
}

textcs_insert(buf, len)
char *buf;
int len;
{
char buf2[1024];
static int init=0;
int x;

bzero(buf2, 1024);
strncpy(buf2, buf, len);
if (init==0) {
  init++;
  x=1;
} else
  x=XmTextGetLastPosition(textcs);
XmTextInsert(textcs, x, buf2);
}

textcs_reposition()
{
}

void hose(item,client_data, cbs)
Widget item;
XtPointer client_data;
XmPushButtonCallbackStruct *cbs;
{
com_hose();
}

void firewall(item, client_data, cbs)
Widget item;
XtPointer client_data;
XmPushButtonCallbackStruct *cbs;
{
fprintf(stderr, "MOTIF FIREWALL NOT IMPLEMENTED YET...\n"); /* XXX */
}

void sendrst(item,client_data, cbs)
Widget item;
XtPointer client_data;
XmPushButtonCallbackStruct *cbs;
{
com_sendrst();
}

void climessage(item,client_data, cbs)
Widget item;
XtPointer client_data;
XmPushButtonCallbackStruct *cbs;
{
com_climessage();
}

char *get_climess_str()
{
static char retval[160];
char *text;

text=XmTextGetString(climess_item);
strcpy(retval, text);
XtFree(text);
return(retval);
}

delete_row(row)
int row;
{
int i;
struct clidata *cd=clientdata, *lcd=cd;

XmListDeletePos(panel_item, row+1);
for (i=0;i<row;i++) {
	lcd=cd;
	cd=cd->next;
}
if (lcd==cd) {
	clientdata=cd->next;
	free(cd);
} else {
	lcd->next=cd->next;
	free(cd);
}
}

set_status_label(label, color)
char *label, *color;
{
XmString str=XmStringCreateSimple(label);
/*int numcolor=BLACK;

if (!strcasecmp(color, "red")) numcolor=RED;
if (!strcasecmp(color,"green")) numcolor=GREEN;
if (!strcasecmp(color,"blue")) numcolor=BLUE;
if (!strcasecmp(color,"black")) numcolor=BLACK; */

XtVaSetValues(mess_item4, XmNlabelString, str, NULL);
}

add_row(label, data)
char *label;
int data;
{
struct clidata *cd=clientdata;

XmString str=XmStringCreateSimple(label);
XmListAddItem(panel_item, str, 0);
if (cd==NULL) {
	clientdata=(struct clidata *)malloc(sizeof(struct clidata));
	cd=clientdata;
} else {
	while (cd->next!=NULL) cd=cd->next;
	cd->next=(struct clidata *)malloc(sizeof(struct clidata));
	cd=cd->next;
}
cd->cp=data;
cd->next=NULL;
}

delete_all_rows()
{
struct clidata *cd=clientdata, *cdn;

XmListDeleteAllItems(panel_item);
while (cd!=NULL) {
	cdn=cd->next;
	free(cd);
	cd=cdn;
}
}

select_row(rownum)
int rownum;
{
XmListDeselectAllItems(panel_item);
if (rownum>=0)
	XmListSelectPos(panel_item, rownum, True);
}

reset_mapping()
{
XtDestroyWidget(frame_tty);
}

set_row_label(row, label, data)
int row, data;
char *label;
{
XmString str[2];
int i;
struct clidata *cd=clientdata;

str[0]=XmStringCreateSimple(label);
str[1]=NULL;
XmListReplaceItemsPos(panel_item, str, 1, row+1);
XmStringFree(str[0]);
if (data>=0) {
	for(i=0;i<row;i++) 
		cd=cd->next;
	cd->cp=data;
}
}

set_row_title(row, label)
int row;
char *label;
{
set_row_label(row, label, -1);
}

show_hosebutton(value)
int value;
{
XtSetSensitive(hose_button, True);
}


static String term_fallback_resources[] = {
  "IPWatcher.ansiterm.font: -*-fixed-medium-r-*--*-140-*-*-*-*-iso8859-1",
  "IPWatcher.ansiterm.background: black",
  "IPWatcher.ansiterm.foreground: green",
  NULL,
};

/* key_cb is invokved whenever the user pressed a key in the widget */
static void key_cb(w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
  int *fd = (int *)client_data;
  char *data = (char *)call_data;

  if (write(*fd, data, 1)==-1) perror("Terminal write");
}

/* out_cb is invoked whenever there is data available from the subprocess */
static void out_cb(client_data, fid, id)
XtPointer client_data;
int *fid;
XtInputId *id;
{
  Widget term=(Widget) client_data;
  char buf[1024];
  int nbytes;

  if ((nbytes = read(*fid, buf, sizeof(buf))) == -1) {
    if (errno!=EINTR) perror("Read");
    return;
  }
  XfwfAnsiWrite(term, buf, nbytes);
}

/* 
 * The following tries to open the ptys for the terminal. returns 0 on 
 * success, 1 on failure
 */
#define SUFFIX1 "pqrstuvwxyzabcdefghijklmno"
#define SUFFIX2 "0123456789abcdef"
#define DEVPTY1 "/dev/pty??"
#define DEVPTY2 "/dev/tty??"

static int openpty(master_return, slave_return)
int *master_return, *slave_return;
{
  static char suffix1[] = SUFFIX1, suffix2[] = SUFFIX2;
  static char mastername[] = DEVPTY1, slavename[] = DEVPTY2;
  char *p, *q;

  for (p = suffix1; *p; p++) {
    mastername[sizeof(DEVPTY1)-3] = *p;
    slavename[sizeof(DEVPTY2)-3] = *p;
    for (q = suffix2; *q; q++) {
      mastername[sizeof(DEVPTY1)-2] = *q;
      slavename[sizeof(DEVPTY2)-2] = *q;
      if ((*master_return = open(mastername, O_RDWR)) == -1) continue;
      if ((*slave_return = open(slavename, O_RDWR)) != -1) return(0);
      close(*master_return);
    }
  }
  return(1);
}

/* 
 * Added just in case. You might need to remove this if your system has 
 * memmove()
 */
void memmove(a, b, c)
char *a, *b;
int c;
{
bcopy(b, a, c);
}
