/* Monitor for TTY-watcher */

/*
 * Copyright (c) 2000  En Garde Systems. All rights reserved.
 *    
 * Redistribution and use in source and binary forms, with or without    
 * modification, for NON COMMERCIAL USE are permitted provided that: 
 * (1) source code distributions retain the above copyright notice and this 
 * paragraph in its entirety, and (2) distributions including binary code 
 * include the above copyright notice and this paragraph in its entirety in 
 * the documentation or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * For commercial use or modification of this program, contact:
 * En Garde Systems
 * 4848 Tramway Ridge, Suite 122
 * Albuquerque, NM 87111
 */

/* Functions to read a terminal session packet and return it.
 * additional function for reading from session logs produced by Host-Watcher
 */

#include <stdio.h>
#include <sys/types.h>
#include <errno.h>
#include <sys/filio.h>
#include <stropts.h>
#include <sys/stream.h>
#include <sys/time.h>

/* Local includes */ 
#include "ses_packet.h" 
#include "twtch.h"


static char *RCSid="$Id: readpacket.c,v 1.3 2000/03/03 17:10:52 mcn Exp $";


struct ses_packet *read_packet()
{
static struct ses_packet	pkt;
static char   data[16384];
int    datalen, flags;
struct strbuf dataptr;
register struct packet *sp;
fd_set fdset;
struct timeval to;
extern int ttyfd, mapped, curses_fullscreen, twtchfd;
extern struct con *current;

dataptr.maxlen=16384;
dataptr.buf=data;
flags=0;
if (getmsg(twtchfd, NULL, &dataptr, &flags)>=0) {
	sp=(struct packet *)dataptr.buf;
	pkt.from = sp->from;
	pkt.type = sp->type;
	pkt.uid  = sp->uid;
	pkt.dev  = sp->dev;

	datalen=dataptr.len-sizeof(struct packet);

	switch (sp->type) {
		case TYPE_END:
			pkt.data_buffer=NULL;
			pkt.data_len = -1;
			break;
		case TYPE_SYN:
			pkt.data_buffer=NULL;
			pkt.data_len = -2;
			break;
		default:
			if (datalen>0) {
				pkt.data_buffer = dataptr.buf+sizeof(struct packet);
				pkt.data_len = datalen;
			} else {
				pkt.data_buffer=NULL;
				pkt.data_len=0;
			}
			break;
	}
} else {
	/* 
	 * The following needs to be fixed so we select on both the tty
	 * and the network
	 */
	if (errno==EINTR || errno==EAGAIN) {
		if ((mapped || curses_fullscreen) && current) 
			musleep(50000); 
			/* Sleep shorter, in case the user types */
		else
			musleep(200000); 
			/* Sleep longer, interactive response isn't important */
		return(NULL);
	} else {
		perror("getmsg");
		exit(1);
	}
}

if ((pkt.data_buffer==NULL) && (pkt.data_len==0))
	return(NULL);
else
	return(&pkt);
}

time_t pkt_time;
extern time_t gtime;
extern int reachedEOF;
extern int playspeed;

struct ses_packet *read_log(fd,ptime)
int fd;
time_t *ptime; /* packet time */

{
struct log_packet newpacket;
int lenread;
int i=1;
char *pkt_databuf;
struct ses_packet *pkt;
static int packetsent;
static time_t thepack_time;
static struct ses_packet the_packet;
static char tbuf[4096];

/* we want to read the first packet to get our first time stamp, but we
 * also want to read if the packet we have has been sent
 */
 if (reachedEOF) { /* Hack to keep it from busy waiting on an EOF */
	musleep(100000);
	return(NULL);
 }
 if ((!pkt_time)||(packetsent)) {
	/* first time we'll set the read to nonblocking */
	  if (!pkt_time) ioctl(fd,FIONBIO,&i);
	  lenread = read(fd, (char *)&newpacket, sizeof(struct log_packet));
	  if (lenread == sizeof(struct log_packet)) {
		if (newpacket.data_len > 0) {
			pkt_databuf = tbuf;
			if ((read(fd, pkt_databuf, newpacket.data_len))
					!= newpacket.data_len) {
				switch (errno) {
					case 0: reachedEOF = 1;
							playspeed = 1;
							return(NULL);
					case EINTR: return(NULL);
					default:
							perror("read packet data log:");
							exit(-1);
				}
			}
			the_packet.data_buffer = pkt_databuf;
		} else {
			the_packet.data_buffer = NULL;
		}
		the_packet.from = newpacket.from;
		the_packet.type = newpacket.type;
		the_packet.uid  = newpacket.uid;
		the_packet.dev  = newpacket.dev;
		the_packet.data_len = newpacket.data_len;
		thepack_time = newpacket.time;
		packetsent = 0;
		if (!pkt_time) pkt_time = thepack_time;
	  } else 
	  if (errno == EWOULDBLOCK) 
		return(NULL);
	  else {
		switch(errno) {
			case 0:
				reachedEOF = 1;
				playspeed = 1;
				return(NULL);
			case EINTR:
				return(NULL);
			default:
				perror("read packet from log file:");
				exit(1);
		}
	  }
  }
  *ptime=pkt_time;
  if ((gtime >= thepack_time)&&(!packetsent)) {
	pkt = &the_packet;
	packetsent = 1;
	*ptime=thepack_time;
  } else {
	pkt = NULL;
	musleep(100000); /* Sleep 1/10th second--stop busy wait, simulate network */
  }
  return(pkt);
}

/* Stupid Solaris... This is their official hack to do subsecond sleeps... 
 *
 * We're using this rather than the real usleep under 4.x because it 
 * interferes with setitimer usage
 */

musleep(useconds)
unsigned long int useconds;
{
struct timeval delay;

delay.tv_sec = 0;
delay.tv_usec = useconds;

if (select(0, NULL, NULL, NULL, &delay)==-1 && errno!=EINTR)
	perror("select");
return(0);
}
