/* packet and other definitions for Watcher project */

/*
 * Copyright (c) 2000  En Garde Systems. All rights reserved.
 *    
 * Redistribution and use in source and binary forms, with or without    
 * modification, for NON COMMERCIAL USE are permitted provided that: 
 * (1) source code distributions retain the above copyright notice and this 
 * paragraph in its entirety, and (2) distributions including binary code 
 * include the above copyright notice and this paragraph in its entirety in 
 * the documentation or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * For commercial use or modification of this program, contact:
 * En Garde Systems
 * 4848 Tramway Ridge, Suite 122
 * Albuquerque, NM 87111
 */


#define FROM_USER 0
#define FROM_SYS  1

#define TYPE_DATA 0  /* Text */
#define TYPE_SYN  1      /* Start of input. streams module pushed */
#define TYPE_END  2      /* End of input. User hungup */
#define TYPE_TRM  3      /* Stop passing data to/from this user  */
#define TYPE_RSM  4  /* Start/continue passing data to/from this user */


struct ses_packet {
	char 	from;	/* Is the data FROM_USER or FROM_SYS? */
	char 	type;	/* Is this data TYPE_DATA or TYPE_END? */
	uid_t 	uid;	/* uid associated with this message */
	dev_t	dev;	/* dev associated with this message */
	int data_len;
	char *data_buffer;
};

struct log_packet {
	char 	from;
	char	type;
	uid_t	uid;
	dev_t	dev;
	time_t  time;
	int     data_len;
};

extern time_t current_time;
extern time_t pkt_time;

#define HASHSIZE 256

struct con {
	uid_t	uid;
	dev_t	dev;
	char	username[16];
	char	name[35]; /* Name for title bars and stuff */
	char	ttystatus;	/* Normal or Stolen? */
  	struct con *next;
	time_t last_packet;
  	char  csbuf[80];
  	char  scbuf[2048];
  	short csbegin;
  	short csend;
  	short scbegin;
  	short scend;
  	int   bytes_sent;
  	int   last_bytes_sent;
  	char  log; /* 0=none, 1=raw, 2=text */
  	char  logfile[60];
  	int   logfd;
};

#define WHITE   0
#define RED     1
#define GREEN   2
#define BLUE    3
#define BLACK   4
#define NUM_COLORS      5

#define LOGINS 0
#define MAIL   1
#define FTP    2

/* Filterlist might be interesting. :-) */

#ifdef SOLARIS
#define bzero(x,y) memset((x), 0, (y))
#endif

extern char *dev_to_tty();

#define VERSION "1.0"
