#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/stropts.h> 

#ifndef lint
static	char sccsid[] = "@(#)streams.c	1.5 3/19/92";
#endif

int silence = 0;

pop(fd,namewanted)
char *namewanted;
{
	char name[64];

	if(ioctl(fd, I_LOOK, name) != -1) {
		if(!strcmp(name,namewanted)){
			if(!silence)
				fprintf(stderr,"popping module: %s\n", name);
			if(ioctl(fd,I_POP,0) == -1)
				if(!silence)
					perror("ioctl I_POP");
		}else{
			if(!silence)
				fprintf(stderr,
				"module %s not popped, (module %s is on stack top)\n",
				namewanted,name);
		}
	} else {
		if(!silence)
			fprintf(stderr,"no module on stack\n");
	}
}

push(fd,name)
char *name;
{
	if(!silence)
		fprintf(stderr,"pushing module: %s\n", name);
	if (ioctl(fd, I_PUSH, name) < 0) 
		if(!silence)
			perror(name);
}

main(argc, argv)
int argc;
char **argv;
{
	int c,errflg=0;
	extern char *optarg;
	extern int optind;
	int fd;
	struct stat sb;

	if (argc<3) usage(argv[0]);
	if ((fd=open(argv[1], O_RDWR))<0) {
		perror("can't open tty");
		usage(argv[0]);
	}
	if (fstat(fd, &sb)<0) {
		perror("fstat");
		usage(argv[0]);
	}
	setuid(sb.st_uid);

	while ((c = getopt(argc-1, argv+1, "so:u:")) != -1){
		switch (c) {
		case 'o':
			pop(fd,optarg);
			break;
		case 'u':
			push(fd,optarg);
			break;
		case 's':
			silence = ~silence;
			break;
		case '?':
		default:
			errflg++;
		}
	}
	
	exit(0);
}

usage(name)
char *name;
{
	(void)fprintf(stderr, 
		"Usage: %s tty [-s] [-o module-to-pop] [-u module-to-push]\n",
		name);
	(void)fprintf(stderr,
		"       the order of all options is important\n");
	exit (2);
}
