/* Definitions for TWTCH drivers */

/*
 * Copyright (c) 1995  En Garde Systems. All rights reserved.
 *    
 * Redistribution and use in source and binary forms, with or without    
 * modification, for NON COMMERCIAL USE are permitted provided that: 
 * (1) source code distributions retain the above copyright notice and this 
 * paragraph in its entirety, and (2) distributions including binary code 
 * include the above copyright notice and this paragraph in its entirety in 
 * the documentation or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * For commercial use or modification of this program, contact:
 * En Garde Systems
 * 525 Clara Avenue, Suite 202
 * St. Louis, MO  63112
 */


#define FROM_USER 0
#define FROM_SYS  1

#define TYPE_DATA 0  /* Text */
#define TYPE_SYN  1	 /* Start of input. streams module pushed */
#define TYPE_END  2	 /* End of input. User hungup */
#define TYPE_TRM  3	 /* Stop passing data to/from this user  */
#define TYPE_RSM  4  /* Start/continue passing data to/from this user */

struct packet {
	char from;		/* Is the data FROM_USER or FROM_SYS */
	char type;		/* Is this data TYPE_DATA or TYPE_END */
	uid_t uid;			/* The uid associated with this message */
#ifdef _LP64
	dev32_t dev;
#else
	dev_t dev;			/* The dev associated with this message */
#endif
};

struct user_state {
	uid_t  uid;					/* uid who owns this streams module */
#ifdef _LP64
	dev32_t dev;
#else
	dev_t dev;			/* The dev associated with this message */
#endif
	queue_t *q;					/* This user's q */
	mblk_t *us_mblk;			/* The mblk which holds this record */
	char   pass;				/* Pass info to user, or cut them off? */
	struct user_state *next;	/* The next user_state record */
};
