/* XView GUI interface for TTY-Watcher */

/*
 * Copyright (c) 2000  En Garde Systems. All rights reserved.
 *    
 * Redistribution and use in source and binary forms, with or without    
 * modification, for NON COMMERCIAL USE are permitted provided that: 
 * (1) source code distributions retain the above copyright notice and this 
 * paragraph in its entirety, and (2) distributions including binary code 
 * include the above copyright notice and this paragraph in its entirety in 
 * the documentation or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * For commercial use or modification of this program, contact:
 * En Garde Systems
 * 4848 Tramway Ridge, Suite 122
 * Albuquerque, NM 87111
 */


#include <stdio.h>
#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/panel.h>
#include <xview/tty.h>
#include <xview/textsw.h>
#include <xview/font.h>
#include <xview/cms.h>

#include <sys/filio.h>
#include <sys/socket.h>
#include <termios.h>
#include <unistd.h>

#include "ses_packet.h"

static char *RCSid="$Id: xview.c,v 1.9 2000/03/28 16:33:34 mcn Exp $";

Frame frame;
Xv_Font font;
Panel panel, panel2, fpanel, mpanel;
Panel_item gauge_item2, gauge_item3;
Panel_item mess_item, panel_item, input_item;
Panel_item error_item, type_item, mess_item2, mess_item2_5;
Panel_item mess_item3, mess_item3_5, hose_button;

Frame frame_tty;
Tty   ttysw;
Textsw textcs;
Panel panel_tty, panel_tty2;

Panel_item lc_item, fi_item, fi2_item, ra_item, climess_item;
Panel_item mess_item4, ts_item;

extern struct con *current;
extern int mapped, ttyfd, current_mode, current_input;

static int login_windows_created=0, been_created=0;

/* Declare the functions used below */
void log_current(), set_fi_value(), set_ra_value(), set_lc_value();
void ss_choice(), choose_input(), set_error_label(), set_input_item();
void create_login_windows(), quit(), kill_frame(), textcs_erase();
void textcs_reset(), textsc_insert(), pause_playback(), FF_playback();
void create_windows(), update_windows(), set_ct_time_label();
void set_ct_date_label(), set_lt_time_label(), set_lt_date_label();
void set_issyn_label(), erase_issyn_label(), textcs_insert();
void textcs_reposition(), hose(), tty_popdown(), sendrst(), climessage();
void delete_row(), set_status_label(), add_row(), delete_all_rows();
void select_row(), reset_mapping(), set_row_label(), set_row_title();
void show_hosebutton(), tty_status();
char *get_filename(), *get_filename2(), *get_climss_str();
int which_choice();
Notify_func timer_update();
/* End of declarations */


void log_current(item, value, event)
Panel_item item;
int value;
Event *event;
{
com_log_current(value);
return;
}

void set_fi_value(label, active) 
char *label;
int active;
{
xv_set(fi2_item, PANEL_VALUE, label, 
		PANEL_INACTIVE, active,
		NULL);
}

void set_ra_value(value)
int value;
{
xv_set(ra_item, PANEL_VALUE, value, NULL);
}

void set_lc_value(value)
int value;
{
xv_set(lc_item, PANEL_VALUE, value, NULL);
}

void ss_choice(item, value, event)
Panel_item item;
int value;
Event *event;
{
com_ss_choice(value);
return;
}

void choose_input(item, value, event)
Panel_item 	item;
int		value;
Event 		*event;
{
com_choose_input(value);
}

char *get_filename()
/* Return the filename to read data from */
{
return((char *)xv_get(fi_item, PANEL_VALUE));
}

char *get_filename2()
/* Return the filename at the bottom of a connection window */
{
return((char *)xv_get(fi2_item, PANEL_VALUE));
}

void set_error_label(label)
char *label;
{
xv_set(error_item, PANEL_LABEL_STRING, label, NULL);
}

void set_input_item(value)
int value;
{
xv_set(input_item, PANEL_VALUE, value, NULL);
}

int which_choice(item, string, client_data, op, event, row)

Panel_item 	item; 
char 		*string;
caddr_t 	client_data;
Panel_list_op 	op;
Event 		*event;
int 		row;

{
extern int cspos;

if (op==PANEL_LIST_OP_SELECT)
	com_which_choice((int)op, string, (int)client_data);
else
if (op==PANEL_LIST_OP_DESELECT) {
	if (mapped)
		reset_mapping();
	cspos=0;
	mapped=0;
	current=NULL;
}
else 
	return(XV_ERROR);
return(XV_OK);
}

void create_login_windows()
{
  int  nonblock;
  char buf[80];
  Rect rect1, rect2;
  Cms  cms;
  static Xv_singlecolor colors[] =  {
	{ 255, 255, 255 },  /* white */
	{ 255,   0,   0 },  /* red */
	{   0, 255,   0 },  /* green */
	{   0,   0, 255 },  /* blue */
	{   0,   0,   0 }   /* black */
  };
  char title[90];
  static int lastcurrentinput=-1;
  Xv_Window textitem;
  extern int paused;
  struct termios tio;

	sprintf(title, "%s [%s]",
		current->username, dev_to_tty(current->dev));

	if (lastcurrentinput!=current_input) {
		login_windows_created=0;
		if (been_created) {
			xv_destroy_immediate(textcs);
			xv_destroy_immediate(frame_tty);
		}
		lastcurrentinput=current_input;
	}
	if (login_windows_created) {
    	if (current->last_packet!=0) 
			strftime(buf, 80, "LP: %H:%M:%S", localtime(&current->last_packet));
    	else
        	strcpy(buf, "LP: 00:00:00");
		xv_set(mess_item3, PANEL_LABEL_STRING, buf,
			PANEL_ITEM_COLOR, CMS_CONTROL_COLORS + BLACK,
			NULL);
    	if (current->last_packet!=0)
			strftime(buf, 80, "    %D", localtime(&current->last_packet));
    	else
			strcpy(buf, "    00/00/00");
		xv_set(mess_item3_5, PANEL_LABEL_STRING, buf,
			PANEL_ITEM_COLOR, CMS_CONTROL_COLORS + BLACK,
			NULL);
		if (paused)
			set_status_label("   * PAUSED *","blue");
		else
			set_status_label("     ALIVE","green");
		if (current->log>0)
			set_fi_value(current->logfile, 1);
		else
			set_fi_value("", 0);
		textcs_reset();
		dump_bufs(current);
    	mapped=1;
		xv_set(frame_tty, FRAME_LABEL, title, 
				FRAME_CMD_PIN_STATE, FRAME_CMD_PIN_IN, XV_SHOW, TRUE, 
				NULL);
		if (current_input)
			xv_set(ts_item, PANEL_VALUE, current!=NULL ? current->ttystatus : 0,
				NULL);
		xv_set(lc_item, PANEL_VALUE, ((current->log>0) ? 1 : 0), NULL);
		xv_set(ra_item, PANEL_VALUE, ((current->log==1) ? 0 : 1), NULL);
		if (current->log>0)
			set_fi_value(current->logfile, 1);
		return;
	}
	login_windows_created=1;
	been_created=1;
	frame_get_rect(frame, &rect1);
	frame_tty = (Frame)xv_create(frame, FRAME_CMD,
			FRAME_CMD_DEFAULT_PIN_STATE, FRAME_CMD_PIN_IN,
			FRAME_LABEL, title,
			FRAME_DONE_PROC, tty_popdown,
			NULL);
    ttysw=(Tty)xv_create(frame_tty, TTY, /* could be TERMSW? */
			WIN_ROWS, 24,
#ifdef SOLARIS
			WIN_COLUMNS, 80,
#else
			WIN_COLUMNS, 71, 
#endif
			WIN_X, 0,
			WIN_Y, 0,
            TTY_ARGV, TTY_ARGV_DO_NOT_FORK,
            NULL);
    cms = (Cms)xv_create((int)NULL, CMS,
		CMS_CONTROL_CMS, TRUE,
		CMS_SIZE,	CMS_CONTROL_COLORS + NUM_COLORS,
		CMS_COLORS,	colors,
		NULL);
    panel_tty = (Panel)xv_create(frame_tty, PANEL,
			PANEL_LAYOUT, PANEL_HORIZONTAL,
			PANEL_FONT, font,
			PANEL_ITEM_Y_GAP, 5,
			WIN_CMS, cms,
			NULL);
    mess_item2 = xv_create(panel_tty, PANEL_MESSAGE,
			PANEL_LABEL_STRING, "CT: 00:00:00",
			PANEL_ITEM_COLOR, CMS_CONTROL_COLORS + BLACK,
			NULL);
    mess_item2_5 = xv_create(panel_tty, PANEL_MESSAGE,
			PANEL_LABEL_STRING, "    00/00/00",
			PANEL_ITEM_COLOR, CMS_CONTROL_COLORS + BLACK,
			NULL);
    if (current->last_packet!=0) 
		strftime(buf, 80, "LP: %H:%M:%S", localtime(&current->last_packet));
    else
        strcpy(buf, "LP: 00:00:00");
    mess_item3 = xv_create(panel_tty, PANEL_MESSAGE,
			PANEL_LABEL_STRING, buf,
			PANEL_ITEM_COLOR, CMS_CONTROL_COLORS + BLACK,
			NULL);
    if (current->last_packet!=0)
		strftime(buf, 80, "    %D", localtime(&current->last_packet));
    else
		strcpy(buf, "    00/00/00");
    mess_item3_5 = xv_create(panel_tty, PANEL_MESSAGE,
			PANEL_LABEL_STRING, buf,
			PANEL_ITEM_COLOR, CMS_CONTROL_COLORS + BLACK,
			NULL);
    mess_item4 = xv_create(panel_tty, PANEL_MESSAGE,
			PANEL_LABEL_STRING, "      ALIVE",
			PANEL_ITEM_COLOR, CMS_CONTROL_COLORS + GREEN,
			NULL);
    xv_set(panel_tty, PANEL_ITEM_Y_GAP, 10, NULL);
    if (current_input) {
      xv_create(panel_tty, PANEL_BUTTON,
			PANEL_LABEL_STRING, "Terminate",
			PANEL_NOTIFY_PROC, sendrst,
			PANEL_ITEM_COLOR, CMS_CONTROL_COLORS + BLACK, 
			NULL);
	  xv_create(panel_tty, PANEL_MESSAGE,
			PANEL_LABEL_STRING, "User:",
			PANEL_ITEM_COLOR, CMS_CONTROL_COLORS + BLACK,
			PANEL_LABEL_BOLD, TRUE,
			NULL); 
	  xv_create(panel_tty, PANEL_BUTTON,
			PANEL_LABEL_STRING, "Send Message",
			PANEL_NOTIFY_PROC, climessage,
			PANEL_ITEM_COLOR, CMS_CONTROL_COLORS + BLACK,
			NULL);
	  xv_create(panel_tty, PANEL_MESSAGE,
			PANEL_LABEL_STRING, "Server:",
			PANEL_LABEL_BOLD, TRUE,
			NULL); 
	  ts_item = xv_create(panel_tty, PANEL_CHOICE,
			PANEL_LAYOUT, PANEL_VERTICAL,
			PANEL_LABEL_STRING, "User's TTY:",
			PANEL_CHOICE_STRINGS, "Normal", "Stolen", NULL,
			PANEL_VALUE, current!=NULL ? current->ttystatus : 0,
			PANEL_NOTIFY_PROC, tty_status,
			NULL);
    } else {
      xv_create(panel_tty, PANEL_BUTTON,
			PANEL_LABEL_STRING, "Pause",
			PANEL_NOTIFY_PROC, pause_playback,
                        PANEL_ITEM_COLOR, CMS_CONTROL_COLORS + BLACK, 
			NULL);
      xv_create(panel_tty, PANEL_BUTTON,
			PANEL_LABEL_STRING, " FF ",
			PANEL_NOTIFY_PROC, FF_playback,
                        PANEL_ITEM_COLOR, CMS_CONTROL_COLORS + BLACK, 
			NULL);
    }
    textcs=(Textsw)xv_create(frame_tty, TEXTSW,
			WIN_BELOW, ttysw,
			WIN_X, 0,
			WIN_ROWS, 1,
#ifdef SOLARIS
			WIN_COLUMNS, 79,
#else
			WIN_COLUMNS, 80,
#endif
			TEXTSW_IGNORE_LIMIT, TEXTSW_INFINITY,
			TEXTSW_INSERT_MAKES_VISIBLE, TEXTSW_ALWAYS,
			NULL);
	textitem=(Xv_Window)xv_get(textcs, OPENWIN_NTH_VIEW, 0);
	xv_set(textitem, 
			WIN_IGNORE_X_EVENT_MASK, (KeyPressMask|KeyReleaseMask|ButtonPressMask|ButtonReleaseMask),
			WIN_EVENT_PROC, NULL, 
			NULL);
    panel_tty2=(Panel)xv_create(frame_tty, PANEL,
			WIN_BELOW, textcs,
			WIN_X, 0,
			PANEL_LAYOUT, PANEL_HORIZONTAL,
			NULL);
    if (current_input)
 	   climess_item=xv_create(panel_tty2, PANEL_TEXT,
			PANEL_LABEL_STRING, "User Message: ",
			PANEL_VALUE, "",
			PANEL_VALUE_STORED_LENGTH, 60,
			PANEL_VALUE_DISPLAY_LENGTH, 60,
			NULL);
    lc_item=xv_create(panel_tty2, PANEL_CHOICE,
			PANEL_CHOOSE_ONE, TRUE,
            PANEL_LAYOUT, PANEL_HORIZONTAL,
            PANEL_CHOICE_NCOLS, 1,
            PANEL_LABEL_STRING, "Save Session: ",
            PANEL_CHOICE_STRINGS, "No", "Yes", NULL,
            PANEL_NOTIFY_PROC, log_current,
            PANEL_VALUE, (current->log>0 ? 1 : 0),
            NULL);
    ra_item=xv_create(panel_tty2, PANEL_CHOICE,
			PANEL_CHOOSE_ONE, TRUE,
			PANEL_LAYOUT, PANEL_HORIZONTAL,
			PANEL_CHOICE_NCOLS, 1,
			PANEL_LABEL_STRING, "As: ",
			PANEL_CHOICE_STRINGS, "Raw", "Text", NULL,
			PANEL_NOTIFY_PROC, ss_choice,
			PANEL_VALUE, (current->log==1 ? 0 : 1),
			NULL);
    fi2_item=xv_create(panel_tty2, PANEL_TEXT,
			PANEL_LABEL_STRING, "Filename: ",
			PANEL_VALUE_STORED_LENGTH, 60,
			PANEL_VALUE_DISPLAY_LENGTH, 60,
			NULL);
	if (current->log>0)
		set_fi_value(current->logfile, 1);
    mapped = 1;
    frame_get_rect(frame_tty, &rect2);
    rect2.r_top=rect1.r_top+rect1.r_height;
    rect2.r_left=rect1.r_left;
	rect2.r_height=480;
    rect2.r_width=690;
    frame_set_rect(frame_tty, &rect2); 
    xv_set(frame_tty, XV_SHOW, TRUE, NULL);
    ttyfd=(int)xv_get(ttysw, TTY_TTY_FD);
    nonblock=1;
    ioctl(ttyfd, FIONBIO, &nonblock);
	if (tcgetattr(ttyfd, &tio)==0) {
		tio.c_lflag &= ~(ICANON | ISIG | ECHO | ECHOE | ECHOK | ECHONL); 
			/* cbreak, pass signals, turn off all echoing */
		tio.c_oflag |= (OPOST | ONLCR);
		tio.c_cc[VMIN] = 1; /* Get 1 character */
		tio.c_cc[VTIME] = 0; /* No timeout */
		if (tcsetattr(ttyfd, TCSANOW, &tio)<0)
			perror("Can't set display terminal to CBREAK mode");
	} else
		perror("Can't get terminal characteristics");
    dump_bufs(current);
}

void quit(item,event)
Panel_item item;
Event *event;
{
com_quit();
}

void kill_frame()
{
if (mapped)
   reset_mapping(); /* Hopefully this will fix the utmp entry */
mapped=0;
xv_destroy_immediate(textcs);
xv_destroy_immediate(frame_tty);
xv_destroy_immediate(frame);
}

void textcs_erase(start,fin)
int start,fin;
{
if (fin==-1) fin = TEXTSW_INFINITY;
textsw_erase(textcs, start, fin);
}

void textcs_reset()
{
textsw_reset(textcs, 0, 0);
}

void textsc_insert(buf, x)
char *buf;
int x;
{
/* ttysw_output(ttysw, buf, x); */
write(ttyfd, buf, x); 
 /* Done so we get the TTY output features. Not MUCH slower than simply doing
  * the ttysw_output call
  */
}


void pause_playback(item,event)
Panel_item item;
Event *event;
{
com_pause_playback();
}

void FF_playback(item,event)
Panel_item item;
Event *event;
{
com_FF_playback();
}


static Display *dpy;

void create_windows(argc, argv)
int argc;
char *argv[];
{
struct itimerval itimer;

    xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);

    frame = (Frame)xv_create ((int)NULL, FRAME, FRAME_LABEL, "TTY-Watcher",
   		FRAME_SHOW_RESIZE_CORNER, FALSE,
   		NULL);

    font = xv_find(panel, FONT, FONT_FAMILY, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
		NULL);

    panel = (Panel)xv_create(frame, PANEL,
			PANEL_LAYOUT, PANEL_VERTICAL,
			PANEL_FONT, font,
			XV_WIDTH, 341,
			NULL);

    xv_create(panel, PANEL_BUTTON,
			PANEL_LABEL_STRING, "Quit",
			PANEL_NOTIFY_PROC, quit,
			NULL);

    mess_item = xv_create(panel, PANEL_MESSAGE,
			PANEL_LABEL_STRING, 
				"                                              ",
			PANEL_NEXT_ROW, -1,
			NULL);

    panel_item = xv_create(panel, PANEL_LIST,
			PANEL_NOTIFY_PROC, which_choice,
			PANEL_CHOOSE_NONE, TRUE,
			PANEL_LIST_DISPLAY_ROWS, 9,
			PANEL_LIST_TITLE,   "Active Sessions",
			PANEL_READ_ONLY, TRUE,
			PANEL_LIST_WIDTH, 317, /* was 275 */
			NULL);

	/* Put hose button in the upper right corner */
    hose_button = xv_create(panel, PANEL_BUTTON,
			PANEL_LABEL_STRING, "Kill All Sessions",
			PANEL_NOTIFY_PROC, hose,
			PANEL_VALUE_X, 346,
			PANEL_VALUE_Y, 4,
			NULL); /* This appears to the right of "Logins/Mail/Ftp" */

	window_fit_height(panel);
    panel2 = (Panel)xv_create(frame, PANEL,
            PANEL_FONT, font,
            PANEL_LAYOUT, PANEL_HORIZONTAL,
            WIN_BELOW, panel,
            WIN_X, 0,
			XV_WIDTH, 341,
            NULL);

    xv_create(panel2, PANEL_MESSAGE,
			PANEL_LABEL_STRING, "Input method:",
			PANEL_LABEL_BOLD, TRUE,
			NULL);

    input_item = xv_create(panel2, PANEL_CHOICE,
			PANEL_CHOICE_STRINGS, "File", "System", NULL,
			PANEL_NOTIFY_PROC, choose_input,
			PANEL_VALUE, 1,
			PANEL_NEXT_ROW, -1,
			NULL);

    fi_item = xv_create(panel2, PANEL_TEXT,
            PANEL_LABEL_STRING, "Filename:",
            PANEL_VALUE_DISPLAY_LENGTH, 22,
            NULL);

/* Now do absolutely positioned items */
    error_item = xv_create(panel2, PANEL_MESSAGE,
			PANEL_VALUE_X, 260,
			PANEL_VALUE_Y, 46,
			NULL); /* This appears below 'Filename:' */


	window_fit_height(panel2);
    window_fit(frame);
    xv_set(frame, XV_SHOW, TRUE, NULL);
    dpy = (Display *)xv_get(frame, XV_DISPLAY);
    XFlush(dpy);

	/* Set the notifier timer function now */
	itimer.it_value.tv_sec=1;
	itimer.it_value.tv_usec=0;
	itimer.it_interval.tv_sec=1;
	itimer.it_interval.tv_usec=0;
	notify_set_itimer_func(frame, timer_update, ITIMER_REAL, &itimer, NULL);
}

void update_windows()
{
	notify_dispatch();
	XFlush(dpy);
}

void set_ct_time_label(label)
char *label;
{
xv_set(mess_item2, PANEL_LABEL_STRING, label, NULL);
}

void set_ct_date_label(label)
char *label;
{
xv_set(mess_item2_5, PANEL_LABEL_STRING, label, NULL);
}

void set_lt_time_label(label)
char *label;
{
xv_set(mess_item3, PANEL_LABEL_STRING, label, NULL);
}

void set_lt_date_label(label)
char *label;
{
xv_set(mess_item3_5, PANEL_LABEL_STRING, label, NULL);
}

void set_issyn_label(label)
char *label;
{
xv_set(mess_item, 
	PANEL_LABEL_STRING, label, 
	NULL);
}

void erase_issyn_label()
{
xv_set(mess_item, 
	PANEL_LABEL_STRING, "                                              ",
	NULL);
}

void textcs_insert(buf, len)
char *buf;
int len;
{
textsw_insert(textcs, buf, len);
textsw_possibly_normalize(textcs, 1);
}

void textcs_reposition()
{
xv_set(textcs, TEXTSW_FIRST, 1, NULL);
}

void hose(item, event)
Panel_item item;
Event *event;

{
com_hose();
}

/* tty_popdown() is called when someone takes the pin out of a connection
 * window */
void tty_popdown()
{
extern int cspos;
int first_selected=(int)xv_get(panel_item, PANEL_LIST_FIRST_SELECTED);

xv_set(panel_item, PANEL_LIST_SELECT, first_selected, FALSE, NULL);
if (mapped) reset_mapping();
cspos=0;
mapped=0;
current=NULL;
return;
}

void sendrst(item,event)
Panel_item item;
Event *event;
{
com_sendrst();
}

void climessage(item, event)
Panel_item item;
Event *event;
{
com_climessage();
}

char *get_climess_str()
{
return((char *)xv_get(climess_item, PANEL_VALUE));
}

void delete_row(row)
int row;
{
xv_set(panel_item, PANEL_LIST_DELETE, row, NULL); 
}

void set_status_label(label, color)
char *label, *color;
{
int numcolor=BLACK;

if (!strcasecmp(color, "red")) numcolor=RED;
if (!strcasecmp(color,"green")) numcolor=GREEN;
if (!strcasecmp(color,"blue")) numcolor=BLUE;
if (!strcasecmp(color,"black")) numcolor=BLACK;

xv_set(mess_item4, PANEL_LABEL_STRING, label, 
		PANEL_ITEM_COLOR, CMS_CONTROL_COLORS + numcolor,
		NULL);
}

void add_row(label, data, row)
char *label;
int data;
int row;
{
xv_set(panel_item, PANEL_LIST_INSERT, row,
		PANEL_LIST_STRING, row, label,
		PANEL_LIST_CLIENT_DATA, row, data, NULL);
}

void delete_all_rows()
{
int i=(int)xv_get(panel_item, PANEL_LIST_NROWS);

xv_set(panel_item, PANEL_LIST_DELETE_ROWS, 0, i, NULL);
}

void select_row(rownum)
int rownum;
{
int first_selected=(int)xv_get(panel_item, PANEL_LIST_FIRST_SELECTED);

if (first_selected>=0)
  xv_set(panel_item, PANEL_LIST_SELECT, first_selected, FALSE, NULL);
if (rownum>=0)
  xv_set(panel_item, PANEL_LIST_SELECT, rownum, TRUE, NULL);
}

void reset_mapping()
{
xv_set(frame_tty, FRAME_CMD_PIN_STATE, FRAME_CMD_PIN_OUT, XV_SHOW, FALSE, NULL);
}

void set_row_label(row, label, data)
int row, data;
char *label;
{
xv_set(panel_item, PANEL_LIST_STRING, row, label,
	PANEL_LIST_CLIENT_DATA, row, data,
	NULL);
}

void set_row_title(row, label)
int row;
char *label;
{
xv_set(panel_item, PANEL_LIST_STRING, row, label, NULL);
}

void show_hosebutton(value)
int value;
{
xv_set(hose_button, XV_SHOW, value, NULL);
}

void tty_status(item, value, event)
Panel_item item;
int value;
Event *event;
{
if (current==NULL) return;
if (value==1) 
	send_packet(current->uid, current->dev, FROM_SYS, NULL, -2);
	/* Stop data passing */
else
	send_packet(current->uid, current->dev, FROM_SYS, NULL, -3);
	/* Resume data passing */
current->ttystatus=value;
}

Notify_func timer_update(client, which)
/* This routine should be called every second */
Notify_client client;
int which;
{
extern time_t gtime;
extern int erase_issyn;
static int ticks=0;

if (current_input)
	gtime++; 
	/* 
	 * Increment gtime every "second". It may not be accurate, but it's
	 * good enough for displaying something on the screen 
	 */
ticks++;
if (ticks & 4) { /* Every 4 seconds */
	ticks=0;
	redo_titles();
	com_check_utmp();
}
if (erase_issyn>0) {
	erase_issyn_label();
	erase_issyn=0;
} else
	erase_issyn+=60; /* This should be 5 seconds */
return(NOTIFY_DONE);
}
