#!/bin/sh
# generates automech.h and automech.c

# Copyright (C) 2000,2003 Ian Jackson
# This file is part of ipif, part of userv-utils
#
# This is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with userv-utils; if not, write to the Free Software
# Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

exec >automech.c.new
exec 3>automech.h.new

cat <<END
#include "forwarder.h"
const struct mechanism *const mechanismlists[]= {
END

cat >&3 <<END
#ifndef AUTOMECH_H
#define AUTOMECH_H
END

for m in "$@"; do
	echo "  mechlist_$m,"
	echo "extern const struct mechanism mechlist_$m[];" >&3
done

cat <<END
  0
};
END

cat >&3 <<END
#endif
END

for e in c h; do mv -f automech.$e.new automech.$e; done
