#!/usr/bin/perl
#
# viperdb.pl - Filesystem Integrity Monitor
#
# Copyright (C) 1998-2001 J-Dog <J-Dog@Resentment.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# These are the only things you should need to set
$configfile='/usr/local/etc/viperdb.conf';
$ignorefile='/usr/local/etc/viperdb.ignore';
$notifymail='Y';
$notify_email='root';
$notify_subject="ViperDB Changes Detected!\n";

###
### You shouldn't have to touch anything below here
###

chomp($os_type=lc(qx[uname]));

# Detect what command line switches were passed and act accordingly
if (@ARGV[0] eq '-init'){
	print "Init Detected. Creating Databases...\n";
	&InitDB;
} elsif (@ARGV[0] eq '-check'||@ARGV[0] eq '-checkstrict'){
	print "Check Detected: Now Checking File Sanity...\n";
	&SysCheck;
} else {
	print "\n\nViperDB v0.9.1\n";
	print "ERROR: Unrecognized option or none given.\n";
	print "usage: ViperDB -init -check\n";
	print "     -init          Initializes the ViperDB Databases\n";
	print "     -check         Runs a system file sanity check\n";
	print "     -checkstrict   Runs a system file sanity check (protective)\n";
}

sub InitDB {
	$runtype='init';
	&CreateDB;
}

sub SysCheck {
	$runtype='check';
	&CreateDB;
	if (@ARGV[0] eq '-checkstrict'){
		$strictmode="Y";
	}
	&Compare;
	&Cleanup;

	# At this point I re-init the databases to stop
	# changes from constantly being displayed. We have
	# displayed changes, if any, and we are now going
	# to re-create the database with the new perms.
	$runtype='init';
	print "Creating New Databases...\n";
	&CreateDB;

}
sub CreateDB {
	# Parse in the Ignore file
	open (IGNORE, "< $ignorefile");
		%ignorefiles;
		$ignorecount=0;
		while(<IGNORE>){
			chomp;
			$ignorefiles{$ignorecount} = $_;
			$ignorecount+=1;
		}#while
	close(IGNORE);

	#Parse in the Config file
	open (CONFIG, "< $configfile");
		STARTCONFIG:
		$configline=<CONFIG>;
		chomp $configline;
		while (defined($configline)){
			if ($configline =~ /:/){
				goto STARTCONFIG;
			} else {
				$wd=$configline;
				# Set some vars up for runtype
				if ($runtype eq 'init'){
					$ViperDB=$wd . '.ViperDB';
					# Solaris be goofy and we can't do this
					if ($os_type ne 'sunos'){
						system("chattr -iu $ViperDB 2>/dev/null 1>/dev/null");
					}#if
				} else {
					$ViperDB=$wd . '.ViperDB.tmp';
				}#if...else

				# Read in the current dir and build the DB
				open (VIPERDB, "> $ViperDB");
					opendir(BINLIST, $wd) || die "can't opendir $wd: $!";
						@files = readdir(BINLIST);
						$filecount=@files;
						$count=0;
						RESTARTLOOP:
						while($count ne $filecount){
							foreach $ignorecount (sort keys %ignorefiles){
								if ($files[$count] eq $ignorefiles{$ignorecount}){
									$count+=1;
									goto RESTARTLOOP;
								}
							} #foreach
							$bname=$files[$count];
							$file="$wd/$bname";
							($dev, $ino, $mode, $nlink, $uid, $gid,$rdev, $size, $atime, $mtime, $ctime, $blksize, $blocks)= stat($file);
							print VIPERDB "$bname,$size,$mode,$uid,$gid,$mtime,$ctime\n";
							$count+=1;
						} #while
					closedir(BINLIST);
				close(VIPERDB);

				# Change the permissions to only allow root to read...
				chmod(0400, "$ViperDB");
				if ($runtype eq 'init') {
					if ($os_type ne 'sunos') {
						system("chattr +iu $ViperDB 2>/dev/null 1>/dev/null");
					}
				}
				$configline=<CONFIG>;
				chomp $configline;
			} # else...if
		}
	close (CONFIG);
}


sub Compare {
	open (DIRLIST, "< $configfile");
		open (LOG, "|logger -t ViperDB");
			my $trouble=0;
			READDIRLIST:
			$dirlistline=<DIRLIST>;
			chomp $dirlistline;
			while(defined($dirlistline)){
				if ($dirlistline =~ /:/){
					goto READDIRLIST;
				} else {
					$mypath=$dirlistline;
				}
				$RealDB=$mypath . '.ViperDB';
				$ChkDB=$mypath . '.ViperDB.tmp';

				# Init some Assoc. Arrays
				%valid = ();
				%check = ();

				# Read the RealDB into an Assoc. Array
				open(A, $RealDB);
					while(<A>){
						($bname,$junk) =  split /,/,$_;
						chomp $bname;
						if(defined($bname)){
							if(!defined($valid{$bname})){
								$valid{$bname} = $_;
							} # if
						} # if
					} # while
				close (A);

				# Read the CheckDB into an Assoc. Array
				open(B, $ChkDB);
					while(<B>){
						($bname,$junk) =  split /,/,$_;
						chomp $bname;
						if(defined($bname)){
							if(! defined($check{$bname})){
								$check{$bname} = $_;
							} # if
						} # if
					} # while
				close (B);

				foreach $bname (sort keys %valid){
					$fileinfoa=$valid{$bname};
					$fileinfob=$check{$bname};
					chomp $fileinfoa;
					chomp $fileinfob;
					if($fileinfoa ne $fileinfob){
						($a_bname,$a_size,$a_mode,$a_uid,$a_gid,$a_mtime,$a_ctime) = split/,/,$fileinfoa;
						($b_bname,$b_size,$b_mode,$b_uid,$b_gid,$b_mtime,$b_ctime) = split/,/,$fileinfob;
						$myfile=$wd.$a_bname;
						if(! defined($b_bname)){
							print LOG "Alert - FILE DELETED: $mypath$a_bname\n";
							$errorsummary .= "Alert - FILE DELETED: $mypath$a_bname\n";
							$trouble++;
						} else {
							print LOG "Alert - CHANGES TO FILE: $mypath$a_bname\n";
							$errorsummary .= "Alert - CHANGES TO FILE: $mypath$a_bname\n";
							$trouble++;
							if($a_size ne $b_size){
								print LOG "Alert - SIZE: was $a_size now $b_size\n";
								$errorsummary .= "Alert - SIZE: was $a_size now $b_size\n";
							}
							if($a_uid ne $b_uid||$a_gid ne $b_gid){
								print LOG "Alert - UID/GID: was $a_uid:$a_gid now $b_uid:$b_gid\n";
								$errorsummary .= "Alert - UID/GID: was $a_uid:$a_gid now $b_uid:$b_gid\n";
								if($strictmode eq 'Y'){
									print LOG "Alert - UID/GID: Changing uid/gid of $a_bname back to $a_uid:$a_gid\n";
									$errorsummary .= "Alert - UID/GID: Changing uid/gid of $a_bname back to $a_uid:$a_gid";
									chown $a_uid, $a_gid, $myfile;
								}
							}
							if($a_perms ne $b_perms){
								print LOG "Alert - PERMS: was $a_perms now $b_perms\n";
								$errorsummary .= "Alert - PERMS: was $a_perms now $b_perms";
								if($strictmode eq 'Y'){
									print LOG "Alert - PERMS: Changing perms on $a_bname back to $a_perms\n";
									$errorsummary .= "Alert - PERMS: Changing perms on $a_bname back to $a_perms\n";
									chmod $a_perms, $myfile;
								} # if
							} # if
							if($a_mtime ne $b_mtime){
								($a_seconds, $a_minutes, $a_hours, $a_dom, $a_month, $a_year, $a_wday, $a_yday, $a_isdst) = localtime($a_mtime);
								($b_seconds, $b_minutes, $b_hours, $b_dom, $b_month, $b_year, $b_wday, $b_yday, $b_isdst) = localtime($b_mtime);
								print LOG "Alert - MTIME: was $a_month/$a_dom/$a_year $a_hours:$a_minutes:$a_seconds now $b_month/$b_dom/$b_year $b_hours:$b_minutes:$b_seconds\n";
								$errorsummary .= "Alert -MTIME: was $a_month/$a_dom/$a_year $a_hours:$a_minutes:$a_seconds now $b_month/$b_dom/$b_year $b_hours:$b_minutes:$b_seconds\n";
							} # if
							if($a_ctime ne $b_ctime){
								($a_seconds, $a_minutes, $a_hours, $a_dom, $a_month, $a_year, $a_wday, $a_yday, $a_isdst) = localtime($a_ctime);
								($b_seconds, $b_minutes, $b_hours, $b_dom, $b_month, $b_year, $b_wday, $b_yday, $b_isdst) = localtime($b_ctime);
								print LOG "Alert - CTIME: was $a_month/$a_dom/$a_year $a_hours:$a_minutes:$a_seconds now $b_month/$b_dom/$b_year $b_hours:$b_minutes:$b_seconds\n";
								$errorsummary .= "Alert - CTIME: was $a_month/$a_dom/$a_year $a_hours:$a_minutes:$a_seconds now $b_month/$b_dom/$b_year $b_hours:$b_minutes:$b_seconds\n";
							} # if
						} # if ... else
					} # if
				} # foreach
					foreach $bname ( sort keys %check ) {
					$fileinfoa=$valid{$bname};
					$fileinfob=$check{$bname};
					($a_bname,$junk) = split/,/,$fileinfoa;
					($b_bname,$junk) = split/,/,$fileinfob;
					if (! defined($a_bname) ) {
						print LOG "Alert - NEW FILE: $mypath$b_bname\n";
						$errorsummary .= "Alert - NEW FILE: $mypath$b_bname\n";
						$trouble=$trouble+1;
					} # if
				} # foreach
			$dirlistline=<DIRLIST>;
		chomp $dirlistline;
	} # While
	if ($trouble!=0) {
		print LOG "Info - END RUN - $trouble changes detected.";
		$errorsummary .= "Info - END RUN - $trouble changes detected.";
	} # if
	close (LOG);
	if ($notifymail eq 'Y' && $trouble != 0) {
		open (MAIL, "|mail -s '$notify_subject' $notify_email");
			print MAIL "$errorsummary";
		close(MAIL);
	} #if
} # sub

sub Cleanup {
	open (CONF, "< $configfile");
		STARTCONF:
		$confline=<CONF>;
		chomp $confline;
		while ( defined($confline) ) {
			if ( $confline =~ /:/) {
				goto STARTCONF;
			} else {
				$rmdir=$confline;
			} # if ... else
			$tmpDB=$rmdir . '.ViperDB.tmp';
			#unlink("$tmpDB");
			$confline=<CONF>;
			chomp $confline;
		} # While
	close (CONF);
} # sub

