---------|---------|---------|---------|---------|---------|---------|---------|
-- Author          :  Tom Vu                                     
-- Date            :  09/27/97                                  
-- Description	   :  Left and Right 32-bit registers               
-- -----------------------------------------------------------------------------
library ieee;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_arith.all;
use IEEE.std_logic_unsigned.all;


-- -----------------------------------------------------------------------------
entity EX is

port(   
        EX_IN  		: in 	std_logic_vector(31 downto 0);
       	EX_OUT    	: out    std_logic_vector(47 downto 0)
    );

end EX;

-- -----------------------------------------------------------------------------
architecture beh of EX is
-- -----------------------------------------------------------------------------
subtype small_integer is INTEGER range 0 to 31;
type EX_TYPE is array(0 to 47) of small_integer;

signal EX_TABLE : EX_TYPE;

begin

EX_TABLE <= 	(31, 0, 1, 2, 3, 4,
		  3, 4, 5, 6, 7, 8,
		  7, 8, 9,10,11,12,
		 11,12,13,14,15,16,
		 15,16,17,18,19,20,
		 19,20,21,22,23,24,
		 23,24,25,26,27,28,
		 27,28,29,30,31, 0);	


-- -----------------------------------------------------------------------------
EX_PR: process(EX_IN,EX_TABLE)
-- -----------------------------------------------------------------------------
begin
 	for i in 0 to 47 loop
 	    EX_OUT(i) <= EX_IN(EX_TABLE(i)) ;
 	end loop;
end process EX_PR;
-- -----------------------------------------------------------------------------
end beh;
-- -----------------------------------------------------------------------------
