#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <sys/utsname.h>
#include <string.h>
#include <fcntl.h>
#include <stdarg.h>
#include <linux/if.h>

#include "tcpip.h"

typedef struct {
  char ifname[17];
  struct in_addr addr;
} interfacerec;

typedef struct {
  struct in_addr addr;
  unsigned long naddr;
  interfacerec *iface;
} routerec;

/* Standard Macro */
#define MIN(x,y) (x<y) ? x : y;

int sendsock, readsock;
short numinterfaces, numroutes;
interfacerec *interfaces;
routerec *routes;

/* This function will determine the checksum for a specific packet. Used by */
/*  nearly EVERYTHING on the internet */
unsigned short in_cksum(unsigned short *addr, int len)
{
  register int nleft = len;
  register u_short *w = addr;
  register int sum = 0;
  u_short answer = 0;

  /*
   *  Our algorithm is simple, using a 32 bit accumulator (sum),
   *  we add sequential 16 bit words to it, and at the end, fold
   *  back all the carry bits from the top 16 bits into the lower
   *  16 bits.
   */
  while( nleft > 1 )  {
    sum += *w++;
    nleft -= 2;
  }

  /* mop up an odd byte, if necessary */
  if( nleft == 1 ) {
    *(u_char *)(&answer) = *(u_char *)w ;
    sum += answer;
  }

  /*
   * add back carry outs from top 16 bits to low 16 bits
   */
  sum = (sum >> 16) + (sum & 0xffff);     /* add hi 16 to low 16 */
  sum += (sum >> 16);                     /* add carry */
  answer = ~sum;                          /* truncate to 16 bits */
  return (answer);
}

/* This will resolve the host specified by host (either IP or domain name) */
/*  and return the result in sa */
short resolve_host(char *host,struct sockaddr_in *sa)
{
  struct hostent *ent ;

  if (!host[0]) {
    fprintf(stderr,"error: unknown host %d\n",host);
    return(-1);
  }
  bzero(sa,sizeof(struct sockaddr));
  sa->sin_family = AF_INET;
  sa->sin_addr.s_addr = inet_addr(host);
  if (inet_addr(host) == -1) {
    ent = gethostbyname(host);
    if (ent != NULL) {
      sa->sin_family = ent->h_addrtype;
      bcopy(ent->h_addr,(caddr_t)&sa->sin_addr,ent->h_length);
      return(0);
    } else {
      fprintf(stderr,"error: unknown host %s\n",host);
      return(-1);
    }
  }
  return(0);
}

#define MAXDATA 1436
#define MAXSIZE sizeof(tcpsrec)+sizeof(tcprec)+MAXDATA

void sendip(spoofrec *spoof, char *b, short length, short *fragoffs, short *fraglens, short numfrags)
{
  iprec *ip;
  char buf[MAXSIZE+sizeof(iprec)];
  short i;
  unsigned short fragflags;

  ip=(iprec *)buf;
  ip->vh=0x45;
  ip->stype=0;
  ip->length=htons(length+sizeof(iprec));
  ip->ident=htons(ipident++);
  ip->frag=0;
  ip->ttl=64;
  ip->protocol=6;
  ip->sip=spoof->from.sin_addr;
  ip->dip=spoof->dest.sin_addr;
  ip->cksum=0;
  ip->cksum=in_cksum((unsigned short *)ip,sizeof(iprec));

  if (!numfrags) {
    memcpy(&buf[sizeof(iprec)],b,length);
    if (sendto(sendsock, (void *)buf, length+sizeof(iprec), 0, (struct sockaddr *)&spoof->dest, sizeof(spoof->dest)) < 0)
      perror("sending message");
  } else {
    for (i=0;i<numfrags;i++) {
      fragoffs[i] &= ~7;

      if ((i+1) == numfrags)
        fragflags=0;
       else
        fragflags=0x2000;

      ip->frag=htons((fragoffs[i] >> 3) + fragflags);
      ip->length=htons(fraglens[i]+sizeof(iprec));
/*
      printf("%04X %d\n",ntohs(ip->frag),ntohs(ip->length));
      printf("%d %d\n",(ntohs(ip->frag) & 0x1FFF) * 8,ntohs(ip->frag) & 0xE000);
*/
      /* printf("%d %d\n",(ntohs(ip->frag) >> 3) * 8,ntohs(ip->frag) & 7); */
      ip->cksum=0;
      ip->cksum=in_cksum((unsigned short *)ip,sizeof(iprec));

      memcpy(&buf[sizeof(iprec)],&b[fragoffs[i]],fraglens[i]);
      if (sendto(sendsock, (void *)buf, fraglens[i]+sizeof(iprec), 0, (struct sockaddr *)&spoof->dest, sizeof(spoof->dest)) < 0)
        perror("sending message");
    }
  }
}

/* Makes the checksum for TCP packets since they need an extra "pseudo" */
/*  header to be added */
unsigned short tcpcksum(spoofrec *spoof, char *b, short length)
{
  char buf[MAXSIZE];
  tcpsrec *tcps;

  tcps=(tcpsrec *)buf;
  tcps->sip=spoof->from.sin_addr;
  tcps->dip=spoof->dest.sin_addr;
  tcps->zero=0;
  tcps->proto=6;
  tcps->tcplen=htons(length);
  memcpy(&buf[sizeof(tcpsrec)],(void *)b,length);

  return(in_cksum((unsigned short *)buf,sizeof(tcpsrec)+length));
}

/* Sends an ICMP packet */
void sendicmp(spoofrec *spoof, struct sockaddr_in *from, unsigned short code)
{
  iprec *ip;
  icmprec *icmp;
  char buf[MAXSIZE];

  bzero(buf,MAXSIZE);

  ip=(iprec *)buf;
  icmp=(icmprec *)&buf[sizeof(iprec)];

  ip->vh=0x45;
  ip->stype=0;
  ip->length=htons(sizeof(iprec)+20);
  ip->ident=htons(ipident++);
  ip->frag=0;
  ip->ttl=64;
  ip->protocol=1;
  ip->cksum=0;
  ip->sip=from->sin_addr;
  ip->dip=spoof->dest.sin_addr;
  ip->cksum=in_cksum((unsigned short *)ip,sizeof(iprec));

  icmp->type=3;
  icmp->code=code;
  icmp->zero=0;
  icmp->ip.vh=0x45;
  icmp->ip.stype=0;
  icmp->ip.length=htons(sizeof(iprec)+sizeof(tcprec));
  icmp->ip.ident=htons(ipident++);
  icmp->ip.frag=0;
  icmp->ip.ttl=64;
  icmp->ip.protocol=6;
  icmp->ip.cksum=0;
  icmp->ip.sip=spoof->dest.sin_addr;
  icmp->ip.dip=spoof->from.sin_addr;
  icmp->ip.cksum=in_cksum((unsigned short *)&icmp->ip,sizeof(iprec));
  icmp->sport=htons(1234);
  icmp->dport=htons(6667);
  icmp->seq=htonl(1000000);
  icmp->cksum=0;
  icmp->cksum=in_cksum((unsigned short *)icmp,sizeof(icmprec));

  if (sendto(sendsock, (void *)buf, sizeof(iprec)+sizeof(icmprec), 0, (struct sockaddr *)&spoof->dest, sizeof(spoof->dest)) < 0)
    perror("sending message");

}

/* Sends a TCP packet */
void sendtcp(spoofrec *spoof, unsigned short code, char *data, short datalen, short sn, short rep)
{
  tcprec *tcp;
  char buf[MAXSIZE];
  short i,i1,hsize, tsize=0, fragoff=0;
  unsigned long ack;

  bzero(buf,MAXSIZE);

  tcp=(tcprec *)buf;

  if (code & CF_SYN) {
    hsize=6;
    buf[20]=2;
    buf[20+1]=4;
    buf[20+2]=(MAXDATA>>8) & 0xFF;
    buf[20+3]=(MAXDATA) & 0xFF;
    spoof->seq++;
  } else
    hsize=5;

  tsize=(hsize*4);

  if (datalen) {
    memcpy(&buf[tsize],data,datalen);
    tsize+=datalen;
  }

  ack=spoof->ack;

  for (i=0;i<sn;i++) {
    tcp->sport=htons(spoof->sport);
    tcp->dport=htons(spoof->dport);
    tcp->seqnum=htonl(spoof->seq);
    tcp->acknum=htonl(ack);
    tcp->hrc=(hsize<<4) + code;
    if (code & CF_SYN)
      tcp->window=htons(512);
     else
      tcp->window=htons(14360);
    tcp->urgentptr=0;
    tcp->cksum=0;
    tcp->cksum=tcpcksum(spoof,(char *)tcp,tsize);

    ack+=64000;

    for (i1=0;i1<rep;i1++) 
      sendip(spoof,buf,tsize,&fragoff,&tsize,1);
  }
  spoof->seq+=datalen;
}

void sendtcpfrag(spoofrec *spoof, unsigned short code, char *data, 
      short datalen, short sn, short rep, short *fragoffs, short *fraglens, 
      short numfrags)
{
  tcprec *tcp;
  char buf[MAXSIZE];
  short i,i1,hsize,tsize=0;
  unsigned long ack;

  bzero(buf,MAXSIZE);

  tcp=(tcprec *)buf;

  if (code & CF_SYN) {
    hsize=6;
    buf[20]=2;
    buf[20+1]=4;
    buf[20+2]=(MAXDATA>>8) & 0xFF;
    buf[20+3]=(MAXDATA) & 0xFF;
    spoof->seq++;
  } else
    hsize=5;

  tsize=(hsize*4);

  if (datalen) {
    memcpy(&buf[tsize],data,datalen);
    tsize+=datalen;
  }

  ack=spoof->ack;

  for (i=0;i<sn;i++) {
    tcp->sport=htons(spoof->sport);
    tcp->dport=htons(spoof->dport);
    tcp->seqnum=htonl(spoof->seq);
    tcp->acknum=htonl(ack);
    tcp->hrc=(hsize<<4) + code;
    if (code & CF_SYN)
      tcp->window=htons(512);
     else
      tcp->window=htons(14360);
    tcp->urgentptr=0;
    tcp->cksum=0;
    tcp->cksum=tcpcksum(spoof,(char *)tcp,tsize);

    ack+=64000;

    for (i1=0;i1<rep;i1++)
      sendip(spoof,buf,tsize,fragoffs,fraglens,numfrags);
  }
  spoof->seq+=datalen;
}

/* Get's a TCP packet */
short gettcp(spoofrec *spoof, tcprec *dtcp)
{
  int numread;
  char buf[MAXSIZE];
  tcprec *tcp;

  if ((numread=read(readsock,buf,MAXSIZE)) < 0)
    return(0);

  /* Check to see if it's an IP packet */
  if ((buf[0]>>4) != 4)
    return(0);

  /* Check to see if it's a TCP packet */
  if (buf[9] != 6)
    return(0);

  tcp=(tcprec *)&buf[20];
  /* Check to see if it's from the correct host */
  if (memcmp(&spoof->dest.sin_addr,&buf[12],4)!=0)
    return(0);

  memcpy((void *)dtcp,(void *)tcp,sizeof(tcprec));
  return(1);
}

/* This function will get the local IP address looking through the routing */
/*  tables for a given dest IP */
struct in_addr getlocalip(unsigned long dest)
{
  short i;

  for (i=0;i<numroutes;i++) {
    if ((dest & (unsigned long)routes[i].addr.s_addr) == routes[i].naddr) 
      return(routes[i].iface->addr);
  }
  printf("Couldn't find route for %s\b",inet_ntoa(dest));
}

void init_tcpip(void)
{
  int ifsock, rsflags, i, i1, tmp, found;
  struct ifconf ifc;
  struct ifreq *ifr;
  char buf[1024], iface[16];
  struct sockaddr_in name;
  FILE *f;

  /* Create a channel to the NET kernel. */
  if ((ifsock = socket(AF_INET, SOCK_DGRAM,0)) < 0) {
    perror("socket");
    exit(-1);
  }

  ifc.ifc_len = sizeof(buf);
  ifc.ifc_buf = buf;
  if (ioctl(ifsock, SIOCGIFCONF, &ifc) < 0) {
    perror("opening interface socket");
    exit(1);
  }

  numinterfaces=(ifc.ifc_len / sizeof(struct ifreq));
  interfaces = (interfacerec *)malloc(numinterfaces * sizeof(interfacerec));

  ifr = ifc.ifc_req;
  for (i=0;i<numinterfaces;i++,ifr++) {
    strcpy(interfaces[i].ifname,ifr->ifr_name);
    memcpy(&interfaces[i].addr,&((struct sockaddr_in *)&ifr->ifr_addr)->sin_addr,sizeof(struct in_addr));
    if (ioctl(ifsock, SIOCGIFADDR, ifr) < 0) 
      printf("Couldn't get address for %s\n",ifr->ifr_name);
  }
  close(ifsock);

  if ((f=fopen("/proc/net/route","rt")) == NULL) {
    perror("opening /proc/net/route");
    exit(1);
  }

  numroutes=0;
  fgets(buf,1024,f);
  while (!feof(f)) { 
    fgets(buf,1024,f);
    numroutes++;
  }
  numroutes--;
 
  routes=(routerec *)malloc(numroutes * sizeof(routerec));

  rewind(f);
  fgets(buf,1024,f);
  for (i=0;i<numroutes;i++)  {
    fscanf(f,"%s %08X %08X %02X %d %d %d %08X %d %d %d\n",iface,&tmp,&tmp,&tmp,&tmp,&tmp,&tmp,&routes[i].addr,&tmp,&tmp,&tmp);
    found=0;
    for (i1=0;i1<numinterfaces;i1++) {
      if (strcmp(interfaces[i1].ifname,iface)==0) {
        routes[i].iface=&interfaces[i1];
        found=1;
      }
    }
    if (!found) {
      printf("Couldn't find interface %s\n",iface);
      exit(1);
    }
    routes[i].naddr=(unsigned long)routes[i].iface->addr.s_addr & (unsigned long)routes[i].addr.s_addr;
  }
  fclose(f);

  /* Create socket on which to send. */
  if ((sendsock = socket(AF_INET, SOCK_RAW, 255)) < 0) {
    perror("opening raw send socket");
    exit(1);
  }

  /* Create socket on which to read. */
  if ((readsock = socket(AF_INET, SOCK_RAW, 6)) < 0) {
    perror("opening raw read socket");
    exit(1);
  }
  if ((rsflags=fcntl(readsock,F_GETFL))==-1) {
    perror("fcntl(readsock,F_GETFL)");
    exit(1);
  }

  if (fcntl(readsock,F_SETFL,rsflags | O_NONBLOCK)==-1) {
    perror("fcntl(readsock,F_SETFL)");
    exit(1);
  }
  name.sin_family=AF_INET;
  name.sin_addr.s_addr=INADDR_ANY;
  name.sin_port=10000;
  if (bind(readsock, (struct sockaddr *)&name, sizeof(name))) {
    perror("binding read socket");
    exit(1);
  }
}

