#include "ippacket.h"

int cmdline(int argc, char *argv[], struct str_args *args,
	    struct iphdr *ip_header)
{
    int i;


    while ((i = getopt(argc, argv, "s:d:D:p:T:I:x:y:W:f:u:w:i:q:a:r:")) != -1)
      {
	  switch (i)
	    {
	    case 's':
		if (resolve(optarg, &ip_header->saddr))
		  {
		      herror("-s");
		      return -1;
		  }
		break;
	    case 'd':
		if (resolve(optarg, &ip_header->daddr))
		  {
		      herror("-d");
		      return -1;
		  }
		break;


	    case 'D':
		strncpy(args->data, optarg, 25);
		break;

	    case 'p':
		if (!strcmp(optarg, "?"))
		  {
		      printf("IPPROTO_ICMP\n"
			     "IPPROTO_TCP\n"
			     "IPPROTO_UDP\n"
			     "IPPROTO_RAW -default\n");
		      exit(0);
		  }
		if (!strcmp(optarg, "IPPROTO_ICMP"))
		    ip_header->protocol = IPPROTO_ICMP;
		else if (!strcmp(optarg, "IPPROTO_TCP"))
		    ip_header->protocol = IPPROTO_TCP;
		else if (!strcmp(optarg, "IPPROTO_UDP"))
		    ip_header->protocol = IPPROTO_UDP;
		else if (!strcmp(optarg, "IPPROTO_RAW"))
		    ip_header->protocol = IPPROTO_RAW;
		else
		  {
		      printf("no such protocol %s\n", optarg);
		      return -1;
		  }
		break;

	    case 'T':
		ip_header->ttl = atoi(optarg);
		break;
	    case 'I':
		ip_header->id = htons(atoi(optarg));
		break;
	    case 'x':
		args->tcp.s_port = atoi(optarg);
		args->udp.s_port = atoi(optarg);
		break;
	    case 'y':
		args->tcp.d_port = atoi(optarg);
		args->udp.d_port = atoi(optarg);
		break;

	    case 'f':
		if (!strcmp(optarg, "?"))
		  {
		      printf("TH_ACK\n"
			     "TH_SYN\n"
			     "TH_RST\n"
			     "TH_PUSH\n"
			     "TH_URG\n"
			     "TH_FIN -default\n");
		      exit(0);
		  }
		args->tcp.def_flag = 0;
		if (!strcmp(optarg, "TH_ACK"))
		    args->tcp.flags |= TH_ACK;
		else if (!strcmp(optarg, "TH_SYN"))
		    args->tcp.flags |= TH_SYN;
		else if (!strcmp(optarg, "TH_RST"))
		    args->tcp.flags |= TH_RST;
		else if (!strcmp(optarg, "TH_PUSH"))
		    args->tcp.flags |= TH_PUSH;
		else if (!strcmp(optarg, "TH_URG"))
		    args->tcp.flags |= TH_URG;
		else if (!strcmp(optarg, "TH_FIN"))
		    args->tcp.flags |= TH_FIN;
		else
		  {
		      printf("no such tcpflag %s\n", optarg);
		      return -1;
		  }

		break;
	    case 'W':
		strncpy(args->wpackfile, optarg, 25);
		break;
	    case 'u':
		args->tcp.urgpoint = atoi(optarg);
		break;
	    case 'w':
		args->tcp.win = atoi(optarg);
		break;

	    case 'i':
		if (!strcmp(optarg, "?"))
		  {
		      printf("ICMP_ECHOREPLY\n"
			     "ICMP_DEST_UNREACH\n"
			     "ICMP_SOURCE_QUENCH\n"
			     "ICMP_REDIRECT\n"
			     "ICMP_ECHO -default\n"
			     "ICMP_TIME_EXCEEDED\n"
			     "ICMP_PARAMETERPROB\n"
			     "ICMP_TIMESTAMP\n"
			     "ICMP_TIMESTAMPREPLY\n"
			     "ICMP_INFO_REQUEST\n"
			     "ICMP_INFO_REPLY\n"
			     "ICMP_ADDRESS\n"
			     "ICMP_ADDRESSREPLY\n");
		      exit(0);
		  }
		if (!strcmp(optarg, "ICMP_ECHOREPLY"))
		    args->icmptype = ICMP_ECHOREPLY;
		else if (!strcmp(optarg, "ICMP_DEST_UNREACH"))
		    args->icmptype = ICMP_DEST_UNREACH;
		else if (!strcmp(optarg, "ICMP_SOURCE_QUENCH"))
		    args->icmptype = ICMP_SOURCE_QUENCH;
		else if (!strcmp(optarg, "ICMP_REDIRECT"))
		    args->icmptype = ICMP_REDIRECT;
		else if (!strcmp(optarg, "ICMP_ECHO"))
		    args->icmptype = ICMP_ECHO;
		else if (!strcmp(optarg, "ICMP_TIME_EXCEEDED"))
		    args->icmptype = ICMP_TIME_EXCEEDED;
		else if (!strcmp(optarg, "ICMP_PARAMETERPROB"))
		    args->icmptype = ICMP_PARAMETERPROB;
		else if (!strcmp(optarg, "ICMP_TIMESTAMP"))
		    args->icmptype = ICMP_TIMESTAMP;
		else if (!strcmp(optarg, "ICMP_TIMESTAMPREPLY"))
		    args->icmptype = ICMP_TIMESTAMPREPLY;
		else if (!strcmp(optarg, "ICMP_INFO_REQUEST"))
		    args->icmptype = ICMP_INFO_REQUEST;
		else if (!strcmp(optarg, "ICMP_INFO_REPLY"))
		    args->icmptype = ICMP_INFO_REPLY;
		else if (!strcmp(optarg, "ICMP_ADDRESS"))
		    args->icmptype = ICMP_ADDRESS;
		else if (!strcmp(optarg, "ICMP_ADDRESSREPLY"))
		    args->icmptype = ICMP_ADDRESSREPLY;
		else
		  {
		      printf("no such icmptype %s\n", optarg);
		      return -1;
		  }
		break;

	    case 'q':
		args->tcp.seq = atoi(optarg);
		break;
	    case 'a':
		args->tcp.ack = atoi(optarg);
		break;
	    case 'r':
		args->rnum = atoi(optarg);
		break;
	    }
      }
    return 0;
}
