#include "ippacket.h"
#include <menu.h>

static void w_exit(int);
int gen_menu(ITEM **, int);
static void printhdrs(struct iphdr *, struct str_args *);

void curses(struct str_args *args, struct iphdr *ip_header)
{
    MENU *m;
    ITEM **items = calloc(sizeof(ITEM), 10);
    char str[30];
    int cur_item = 0, c;
    struct sigaction sa;


    sa.sa_handler = (void *) w_exit;
    sigaction(SIGINT, (struct sigaction *) &sa, NULL);

    items[0] = new_item("source ip address", "(0.0.0.0)");
    items[1] = new_item("dest. ip address", "(0.0.0.0)");
    items[2] = new_item("data", "data to append to any type of packet");
    items[3] = new_item("protocol", "(IPPROTO_RAW)");
    items[4] = new_item("TTL", "IP TLL (60)");
    items[5] = new_item("ID", "IP ID (random i think)");
    items[6] = new_item("send packet", "send packet and exit");
    items[7] = new_item("show packet", "");
    items[8] = new_item("save packet", "save to file, after send packet");
    items[9] = new_item("repeat", "-1 continous, else repeat X times, (1)");
    items[10] = NULL;

    initscr();
    crmode();
    keypad(stdscr, TRUE);
    m = new_menu(items);
    mvprintw(10, 6, "use the arrows UP DOWN RIGHT");
    for (;;)
      {
	  post_menu(m);
	  set_current_item(m, items[cur_item]);
	  touchwin(stdscr);
	  refresh();
	  c = getch();
	  if (c == KEY_UP)
	    {
		if (cur_item <= 0)
		    cur_item = 9;
		else
		    cur_item--;
	    }
	  if (c == KEY_DOWN)
	    {
		if (cur_item >= 9)
		    cur_item = 0;	/* change for top item */
		else
		    cur_item++;
	    }
	  if (c == KEY_RIGHT)
	    {
		switch (cur_item)
		  {
		  /* -s */ case 0:
		      popupandread("enter source address", str);
		      if (resolve(str, &ip_header->saddr))
			{
			    sleep(1);
			}
		      break;
		  /* -d */ case 1:
		      popupandread("enter dest. address", str);
		      if (resolve(str, &ip_header->daddr))
			{
			    sleep(1);
			}
		      break;
		  /* -D */ case 2:
		      popupandread("enter line (upto 25 char)", str);
		      strncpy(args->data, str, 25);
		      break;

		  /* -p */ case 3:
		      proto_menu(args, ip_header);
		      break;
		  /* -T */ case 4:
		      popupandread("enter ip ttl (0 - 255)", str);
		      ip_header->ttl = atoi(str);
		      break;
		  /* -I */ case 5:
		      popupandread("enter ip id (0 - someshit)", str);
		      ip_header->id = htons(atoi(str));
		      break;

		  case 6:
		      clear();
		      mvprintw(1, 1, "Hit any key to send packet and exit\n");
		      refresh();
		      printhdrs(ip_header, args);
		      endwin();
		      return;
		  case 7:
		      printhdrs(ip_header, args);
		      break;
		  case 8:
		      popupandread("enter filename to write to", str);
		      strncpy(args->wpackfile, str, 25);
		      break;
		  case 9:
		      popupandread("enter repeat val, -1 for cont.", str);
		      args->rnum = atoi(str);
		      break;
		  }
	    }
	  usleep(5555);
      }

    free_menu(m);
    endwin();
    free(items);
    return;
}


void popupandsay(char str[30])
{
    WINDOW *w = newwin(3, strlen(str) + 2, 5, 5);

    box(w, '|', '-');
    mvwprintw(w, 1, 1, "%s", str);
    wrefresh(w);
    delwin(w);
    touchwin(stdscr);
    refresh();
}

void popupandread(char say[30], char str[30])
{
    WINDOW *w = newwin(4, 30 + 2, 10, 5);

    box(w, '|', '-');
    echo();
    mvwprintw(w, 1, 1, "%s", say);
    mvwscanw(w, 2, 1, "%30s", str);
    delwin(w);
    noecho();
    touchwin(stdscr);
    refresh();
}

static void w_exit(int code)
{
    endwin();
    exit(code);
}

/* creates a new almost fullscreen window so that stdscr contents isnt fucked */
static void printhdrs(struct iphdr *ipheader, struct str_args *args)
{
    WINDOW *w = newwin(20, 70, 3, 5);	/* gotta edit so ip->proto will highlight that group */

    box(w, '|', '-');
    mvwprintw(w, 1, 1, "IP:");
    mvwprintw(w, 2, 1, "TLL = %d", ipheader->ttl);
    mvwprintw(w, 3, 1, "ID = %d", ntohs(ipheader->id));
    mvwprintw(w, 4, 1, "VER = %d", ipheader->version);
    mvwprintw(w, 5, 1, "IHL = %d", ipheader->ihl);
    mvwprintw(w, 6, 1, "TOS = %d", ipheader->tos);
    mvwprintw(w, 7, 1, "PROT = %d", ipheader->protocol);
    mvwprintw(w, 8, 1, "saddr = %s", inet_ntoa(*(struct in_addr *) &ipheader->saddr));
    mvwprintw(w, 9, 1, "daddr = %s", inet_ntoa(*(struct in_addr *) &ipheader->daddr));

    mvwprintw(w, 1, 20, "UDP:");
    mvwprintw(w, 2, 20, "s_port = %d", args->udp.s_port);
    mvwprintw(w, 3, 20, "d_port = %d", args->udp.d_port);
    mvwprintw(w, 1, 40, "TCP:");
    mvwprintw(w, 2, 40, "s_port = %d", args->tcp.s_port);
    mvwprintw(w, 3, 40, "d_port = %d", args->tcp.d_port);
    mvwprintw(w, 4, 40, "seq = %d", args->tcp.seq);
    mvwprintw(w, 5, 40, "ack = %d", args->tcp.ack);
    mvwprintw(w, 6, 40, "flags = %d(dec)", args->tcp.flags);
    mvwprintw(w, 7, 40, "urgptr = %d", args->tcp.urgpoint);
    mvwprintw(w, 8, 40, "window = %d", args->tcp.win);
    mvwprintw(w, 1, 60, "ICMP:");
    mvwprintw(w, 2, 60, "type = %d", args->icmptype);
    mvwprintw(w, 15, 1, "Data = %s", args->data);
    mvwprintw(w, 16, 1, "repeat = %d", args->rnum);
    wrefresh(w);
    getch();
    delwin(w);
    touchwin(stdscr);
    refresh();
}
