#include <sys/types.h>




#define LITTLE_ENDIAN
/* #define BIG_ENDIAN */

#define ICMP_ECHOREPLY          0       /* Echo Reply                   */
#define ICMP_DEST_UNREACH       3       /* Destination Unreachable      */
#define ICMP_SOURCE_QUENCH      4       /* Source Quench                */
#define ICMP_REDIRECT           5       /* Redirect (change route)      */
#define ICMP_ECHO               8       /* Echo Request                 */
#define ICMP_TIME_EXCEEDED      11      /* Time Exceeded                */
#define ICMP_PARAMETERPROB      12      /* Parameter Problem            */
#define ICMP_TIMESTAMP          13      /* Timestamp Request            */
#define ICMP_TIMESTAMPREPLY     14      /* Timestamp Reply              */
#define ICMP_INFO_REQUEST       15      /* Information Request          */
#define ICMP_INFO_REPLY         16      /* Information Reply            */
#define ICMP_ADDRESS            17      /* Address Mask Request         */
#define ICMP_ADDRESSREPLY       18      /* Address Mask Reply           */


struct iphdr {
#ifdef LITTLE_ENDIAN
        __u8    ihl:4,
                version:4;
#endif
#ifdef BIG_ENDIAN
        __u8    version:4,
                ihl:4;
#endif
        __u8    tos;
        __u16   tot_len;
        __u16   id;
        __u16   frag_off;
        __u8    ttl;
        __u8    protocol;
        __u16   check;
        __u32   saddr;
        __u32   daddr;
        /*The options start here. */
};



struct tcphdr {
        u_short th_sport;               /* source port */
        u_short th_dport;               /* destination port */
        u_long th_seq;                 /* sequence number */
        u_long th_ack;                 /* acknowledgement number */
#ifdef LITTLE_ENDIAN
        u_char  th_x2:4,                /* (unused) */
                th_off:4;               /* data offset */
#endif
#ifdef BIG_ENDIAN
        u_char  th_off:4,               /* data offset */
                th_x2:4;                /* (unused) */
#endif
        u_char  th_flags;
#define TH_FIN  0x01
#define TH_SYN  0x02
#define TH_RST  0x04
#define TH_PUSH 0x08
#define TH_ACK  0x10
#define TH_URG  0x20
        u_short th_win;                 /* window */
        u_short th_sum;                 /* checksum */
        u_short th_urp;                 /* urgent pointer */
};





struct udphdr {
  unsigned short        source;
  unsigned short        dest;
  unsigned short        len;
  unsigned short        check;
};



struct icmphdr {
  __u8          type;
  __u8          code;
  __u16         checksum;
  union {
        struct {
                __u16   id;
                __u16   sequence;
        } echo;
        __u32   gateway;
  } un;
};
