#include <stdio.h>
#include <unistd.h>		/* STDIN_FILENO,STDERR_FILENO */
#include <sys/types.h>		/* FD_ZERO,FD_SET, etc */
#include <sys/time.h>		/* struct timeval */
#include <sys/socket.h>		/* socklen_t */
#include <errno.h>

#define	SHOW_SUCCESS		/* print out successful connections */
#define	SHOW_REFUSED		/* print out refused connections */
#define	SHOW_UNREACH		/* print out unreachable connections */
#define SHOW_UNKNOWN		/* print out unknown connection error */

#define TIMEOUT 60		/* seconds before select() can timeout */
				/* note: the longer the timeout, the more accurate
					 this scanner is.  60 is good. */
#define SOCKET_ERR	-1
#define CONNECT_ERR	-2

main(int argc, char *argv[])
{
	int i, sockfd[256], maxsockfd=0, sockopt;
	char ip[30];
	fd_set wset;
	socklen_t socklen;
	struct timeval time;

	if(argc != 3)
	{
		printf("usage: %s <xxx.xxx.xxx> <port>\n",argv[0]);
		exit(-1);
	}
	
	close(STDIN_FILENO);		/* 256 fd's per process. (linux) :( */
	close(STDERR_FILENO);		/* stderr is gone. no more perror(). */

	FD_ZERO(&wset);
	
	/* connect all sockets, create maxsockfd, */

	for(i=1 ; i != 256 ; ++i)
	{
		
		sprintf(ip,"%s.%d\0",argv[1],i);
		if((sockfd[i] = i_connect(ip,atoi(argv[2]),1)) < 0)
		{
			if(sockfd[i] == SOCKET_ERR)
				printf("Failed calling socket() for sockfd[%d]!\n",i);
			else if(sockfd[i] == CONNECT_ERR)
				printf("Failed calling connect() for sockfd[%d]!\n",i);
			
			continue;
		}
	}
	
	while(1)
	{
		/* build fd_set */
		for(i = 1 ; i != 256 ; ++i)
		{
			if(getsockopt(sockfd[i],SOL_SOCKET,SO_ERROR,&sockopt,&socklen) == 0)
			{
				FD_SET(sockfd[i], &wset);
				if(sockfd[i] > maxsockfd) maxsockfd = sockfd[i];
			}
		}
		
		time.tv_sec = TIMEOUT;
		if(select(maxsockfd + 1,NULL,&wset,NULL,&time) == 0)
		{
			printf("Scan completed.\n");
			exit(-1);
		}
		
		for(i=1 ; i != 256; ++i)
		{
			if(FD_ISSET(sockfd[i],&wset))
			{
				/* remove the sockfd from wset */
				FD_CLR(sockfd[i],&wset);
				
				socklen = 4; 	/* sizeof(int) */
				sockopt = -1;
				
				getsockopt(sockfd[i],SOL_SOCKET,SO_ERROR,&sockopt,&socklen);
				
				close(sockfd[i]);	/* dont need it anymore */
				
				if(sockopt == 0)
				{
					#ifdef SHOW_SUCCESS
					printf("SUCCESSFUL CONNECTION: %s.%d(%s)\n",argv[1],i,argv[2]);
					#endif	
				}
				else if(sockopt == ECONNREFUSED)
				{
					#ifdef SHOW_REFUSED
					printf("REFUSED CONNECTION: %s.%d(%s)\n",argv[1],i,argv[2]);
					#endif
				}
				else if(sockopt == ENETUNREACH)
				{
					#ifdef SHOW_UNREACH
					printf("UNREACHABLE CONNECTION: %s.%d(%s)\n",argv[1],i,argv[2]);
					#endif
				}
				else if(sockopt == EHOSTUNREACH)
				{
					#ifdef SHOW_UNREACH
					printf("UNREACHABLE CONNECTION: %s.%d(%s)\n",argv[1],i,argv[2]);
					#endif
				}
				else 
				{
					#ifdef SHOW_UNKNOWN
					printf("ERROR #%d: %s.%d(%s)\n",sockopt,argv[1],i,argv[2]);
					#endif
				}
			}
		}
	}
}
