/*

	high level tcp functions for linux.
	
	useful for *using* linux sockets, without actually *learning* them.
	
	author: jjohnson@eagle.ptialaska.net
		presonic@undernet.irc
		
	int i_disconnect(int sock);
	int i_connect(char *ip,int port,int is_nonblock);
	
	Give i_nslookup either an IP or a name, and it will return the
	oppisite.  The string "ERROR" is returned otherwise.
	
	char *i_nslookup(char *name);
	
	example: i_connect(i_nslookup("www.microsoft.com"),80,0);
*/

#include <stdio.h>		/* sscanf, sprintf */
#include <string.h>		/* strlen,strcpy */
#include <netdb.h>		/* gethostbyaddr,gethostbyname */
#include <netinet/in.h>		/* struct hostent */
#include <sys/socket.h>		/* socket,connect */
#include <sys/types.h>
#include <errno.h>              /* errno stuff */
#include <fcntl.h>		/* flag control,non blocking sockets */

#define SOCKET_ERR	-1
#define CONNECT_ERR	-2
#define NONBLOCK_ERR	-3
#define LOOKUP_ERR	"ERROR"

#define BLOCKING	0
#define NONBLOCKING	1

int i_connect(char *input,int port,int is_nonblock)
{
	int sockfd;
	int sock_flags;
	
	struct sockaddr_in addr;
	
	addr.sin_port = htons(port);	/* convert to nbo */
	addr.sin_family = AF_INET;

	inet_aton(input,&addr.sin_addr);	/* take the dots-and-numbers and stuff them in sin_addr as nbo */
	
	if((sockfd = socket(AF_INET,SOCK_STREAM,0)) < 0) 
		return SOCKET_ERR;
		
	if(is_nonblock == NONBLOCKING)	/* a non-blocking socket requested. */
	{
		if(fcntl(sockfd,F_GETFL,sock_flags) < 0)
                	return NONBLOCK_ERR;
		if(fcntl(sockfd,F_SETFL,sock_flags | O_NONBLOCK) < 0)
	                return NONBLOCK_ERR;
        }

	if(connect(sockfd,(struct sockaddr *) &addr, sizeof(addr)) < 0)
	{
		if(errno == EINPROGRESS)
			return sockfd;	/* its non blocking socket */
		else 
			return CONNECT_ERR;
	}
	
	return sockfd;

}
		
	
char *i_nslookup(char *input)
{
	int	i;
	
	static char	output[512];

	
	unsigned char addr_c[4];
	struct hostent *host;

	if((sscanf(input,"%d.%d.%d.%d",&addr_c[0],&addr_c[1],&addr_c[2],&addr_c[3])) == 4)
		sprintf(output,"%d.%d.%d.%d\0",addr_c[0],addr_c[1],addr_c[2],addr_c[3]);

	/* ip was givin */
	if( (strlen(output) > 0) && ((host = gethostbyaddr(addr_c, 4, AF_INET)) != NULL) )
	{
		strncpy(output,host->h_name,strlen(host->h_name));		/* NAME */	
		return output;
	}
	
	/* name was givin */
	if( (strlen(output) == 0) && ((host = gethostbyname(input)) != NULL) ) 
	{
		strncpy(output,input,strlen(input));
		sprintf(output,"%d.%d.%d.%d\0",(unsigned char)host->h_addr_list[0][0],(unsigned char)host->h_addr_list[0][1],(unsigned char)host->h_addr_list[0][2],(unsigned char)host->h_addr_list[0][3]);
		return output;
	}
	
	
	return LOOKUP_ERR;

}


int i_disconnect(int sock)	/* dont laugh */
{
	close(sock);
}
