/*

	high level tcp functions for unix. version 0.2.1.
	
	tested on:
		linux 2.0.* (slackware/redhat)
		freebsd 2.2.7
	
	useful for *using* sockets, without actually *learning* them.
	
	author: jjohnson@eagle.ptialaska.net
		presonic@irc
		
	int i_disconnect(int sock);
	int i_connect(char *ip,int port,int is_nonblock);
	
	Give i_nslookup() either an IP or a name, and it will return what
	you specify.  If return_type is 0, it returns an IP address, if
	return_type is 1, it returns a hostname, if it is 2, it returns
	the subnet that the IP belongs to.  The string "ERROR" is returned
	if it had problems looking up the IP or the hostname.
	
	char *i_nslookup(char *name_or_ip, int return_type);
	
	i_readline() only does blocking sockets at the moment.  Support for
	non blocking will be in the next release.
	
	char *i_readline(int sock);
	
*/

#include <stdio.h>		/* sscanf, sprintf */
#include <string.h>		/* strlen,strcpy */
#include <netdb.h>		/* gethostbyaddr,gethostbyname */
#include <netinet/in.h>		/* struct hostent */
#include <sys/socket.h>		/* socket,connect */
#include <sys/types.h>
#include <errno.h>              /* errno stuff */
#include <fcntl.h>		/* flag control,non blocking sockets */

#define SOCKET_ERR	-1
#define CONNECT_ERR	-2
#define NONBLOCK_ERR	-3
#define LOOKUP_ERR	"ERROR\0"

#define BLOCKING	0
#define NONBLOCKING	1

#define RETURN_IP	0
#define RETURN_HOST	1
#define RETURN_SUBNET	2

#define MAX_LINE_LEN	1024

int i_connect(char *,int,int);
int i_disconnect(int);
char *i_nslookup(char *,int);
char *i_readline(int);

int i_connect(char *input,int port,int is_nonblock)
{
	int sockfd;
	int sock_flags;
	
	struct sockaddr_in addr;
	
	addr.sin_port = htons(port);	/* convert to nbo */
	addr.sin_family = AF_INET;

	inet_aton(input,&addr.sin_addr);	/* take the dots-and-numbers and stuff them in sin_addr as nbo */
	
	if((sockfd = socket(AF_INET,SOCK_STREAM,0)) < 0) 
		return SOCKET_ERR;
		
	if(is_nonblock == NONBLOCKING)	/* a non-blocking socket requested. */
	{
		if(fcntl(sockfd,F_GETFL,sock_flags) < 0)
                	return NONBLOCK_ERR;
		if(fcntl(sockfd,F_SETFL,sock_flags | O_NONBLOCK) < 0)
	                return NONBLOCK_ERR;
        }

	if(connect(sockfd,(struct sockaddr *) &addr, sizeof(addr)) < 0)
	{
		if(errno == EINPROGRESS)
			return sockfd;	/* its non blocking socket */
		else 
			return CONNECT_ERR;
	}
	
	return sockfd;

}
		
int i_disconnect(int sock)	/* dont laugh */
{
	close(sock);
}
	
char *i_nslookup(char *input,int return_type)
{
	int	i;
	
	static char	output[512];

	unsigned char addr_c[4];
	struct hostent *host;

	
	bzero(output,sizeof(output));
	
	if(return_type > 2 | return_type < 0)
		goto dumb_error;

	if((sscanf(input,"%d.%d.%d.%d",&addr_c[0],&addr_c[1],&addr_c[2],&addr_c[3])) == 4)
		strncpy(output,input,strlen(input));

	/* ip was givin */
	if(strlen(output) > 0)
	{
		if(return_type == RETURN_IP)
			return output;
		if(return_type == RETURN_SUBNET)
			sprintf(output,"%d.%d.%d\0",addr_c[0],addr_c[1],addr_c[2]);
		if((return_type == RETURN_HOST) && ((host = gethostbyaddr(addr_c, 4, AF_INET)) != NULL))
			return host->h_name;
		return output;
	}
	
	/* name was givin */
	if( (strlen(output) == 0) && ((host = gethostbyname(input)) != NULL)) 
	{
		if(return_type == RETURN_HOST)
			return input;
		if(return_type == RETURN_IP)
			sprintf(output,"%d.%d.%d.%d\0",(unsigned char)host->h_addr_list[0][0],(unsigned char)host->h_addr_list[0][1],(unsigned char)host->h_addr_list[0][2],(unsigned char)host->h_addr_list[0][3]);
		if(return_type == RETURN_SUBNET)
			sprintf(output,"%d.%d.%d\0",(unsigned char)host->h_addr_list[0][0],(unsigned char)host->h_addr_list[0][1],(unsigned char)host->h_addr_list[0][2]);
		return output;
	}
	
dumb_error:
	strcpy(output,"ERROR\0");
	return output;

}

char *i_readline(int sock)
{
	int 	i=0, 
		ch=0;
		
	static char line[MAX_LINE_LEN];
	
	while(i != MAX_LINE_LEN)
	{
		if(read(sock,&ch,1) < 0) break;
		line[i] = ch;

		++i;
		if(ch == '\n') break;
	}
	line[i] = 0;
	
	return line;
}
