#include <stdio.h>
#include <asm/io.h>
#include "joylib.h"

unsigned char joy_present (void)
{
   int i=0;
   unsigned char in;
   
   outb (0xff, 0x201);

   do
   {
      in = inb(0x201)&0x0f;
      i++;
   }
   while(in && i<10000);

   return (in^0x0f);
}

int BINARY (int bitid)
{
	int	i;
	int 	n=1;

	for (i=0 ; i<bitid ; i++)
	{
		n *= 2;
	}
	return n;
}

#define bitclear(a,b) !bitset(a,b)

int bitset (unsigned char b, int bitid)
{
	return b&BINARY(bitid);	
}

unsigned char joy_buttons (void)
{
   return (inb(0x201)>>4)^0x0f;
}

int joy_ispressed (int num)
{
	unsigned char b;

	b = joy_buttons ();
	return bitset(b,num);
}

int joy_initport (void)
{
	return ioperm(0x201, 1, 1);
}

void joy_closeport (void)
{
	ioperm(0x201, 1, 0);
}

void joy_position(struct axes *a)
{
    int i=0;
    unsigned char b;
    unsigned char complete;

    complete = joy_present()^0x0f;
    outb (0xff, 0x201);

    while (i<10000)
    {
        b = inb (0x201) ^ 0x0f;
        if (!(complete&1) && b&1)
        {
	   a->ax = i;
           complete|=1;
        }
        if (!(complete&2) && b&2)
        {
	   a->ay = i;
           complete|=2;
        }
        if (!(complete&4) && b&4)
        {
	   a->bx = i;
           complete|=4;
        }
        if (!(complete&8) && b&8)
        {
           a->by = i;
           complete|=8;
        }
        i++;
    };
    a->x = a->ax;
    a->y = a->ay;
}

