/*
  A somewhat incomplete example... I didn't feel like putting much time
into this however so it will remain at the current progress until I give a
damn about it.  Good enough I suppose though.

  Examples of termios library with some additions I think would be nice,
this may not however may not be supported on your platform, if not, email
me at assem@hom.net and I will try my best to port it.

-assem 1/23/99
*/

#include <stdio.h>
#include <unistd.h>
#include <termios.h>
#include <sys/ioctl.h>

void			die(char *deathwish);
int			flush(int fd);
int 			stopout(int fd);
int 			startout(int fd);
int 			stopin(int fd);
int 			startin(int fd);
int 			getch(void);
int			term_getsize(struct winsize *win);
int			term_setsize(struct winsize *win);

void die(char *deathwish)
{
	fprintf(stderr, "%s\n", deathwish);
	exit(-1);
}

int flush(int fd)
{
	if (tcdrain(fd) < 0)
		return (-1);

	return (0);
}

int stopout(int fd)
{
	if (tcflow(fd, TCOOFF) < 0)
		return (-1);

	return (0);
}

int startout(int fd)
{
	if (tcflow(fd, TCOON) < 0)
		return (-1);

	return (0);
}

int stopin(int fd)
{
	if (tcflow(fd, TCIOFF) < 0)
		return (-1);

	return (0);
}

int startin(int fd)
{
	if (tcflow(fd, TCION) < 0)
		return (-1);

	return (0);
}

int getch(void)
{
	int                     x;
	struct termios          term;

	if (tcgetattr(fileno(stdin), &term) < 0)
		return (-1);

	term.c_lflag = ~(ICANON | ECHO);
	/* turn off echo and canonical (line based) mode */

	if (tcsetattr(fileno(stdin), TCSANOW, &term) < 0)
		return (-1);
	/* set the new flags immediately */

	x = getchar ();

	return (x);
	/* return the character read () */
}

int term_getsize(struct winsize *win)
{
	if (ioctl(fileno(stdin), TIOCGWINSZ, win) < 0)
		return (-1);

	return (0);
}

int term_setsize(struct winsize *win)
{
	if (ioctl(fileno(stdin), TIOCSWINSZ, win) < 0)
		return (-1);

	return (0);
}
