/* demonstration of tcgetattr() and tcsetattr() */
#include <stdio.h>
#include <termios.h>

void die(char *deathwish)
{
	fprintf(stderr, "%s\a\n", deathwish);
	exit(-1);
}

int getch(void)
{
	int			x;
	struct termios		term;

	if (tcgetattr(fileno(stdin), &term) < 0)
		die("tcgetattr failed!");

	term.c_iflag = ~(BRKINT | IGNBRK);
	term.c_cc[VINTR] = 1;

	term.c_lflag = ~(ICANON | ECHO);
	/* turn off echo and canonical (line based) mode */

	if (tcsetattr(fileno(stdin), TCSANOW, &term) < 0)
		die("tcsetattr failed!");
	/* set the new flags immediately */

	x = getchar ();

	return (x);
}
int main(int argc, char **argv)
{
	int x;

	printf("Enter text... (^A to kill)\n");

	while(1)  {
		if ( (x = getch()) != '\n')
			printf("%c", x);
	}

	die("done!");
}
