/*
 * lkm client. Use an unused syscall to turn on/off the lkm.
 *
 *   gcc -client.c -o client -O3 -Wall
 *   insmod lkm
 *
 * smiler@tasam.com
 */

#include <asm/unistd.h>
#include <stdio.h>
#include <errno.h>

#define __NR_smiler 191

static inline _syscall1(int, smiler, int, command);


/* Ooh whats the usage..*/

void usage(char *prog)
{
	fprintf(stderr,"Usage: %s [-u|-d]\n",prog);
	exit(-1);
}

int main(int argc,char **argv)
{
	int ret;
	int arg = 0;

	if (argc < 2) usage(argv[0]);

	if (argv[1][1] == 'u') arg++;
	else if (argv[1][1] != 'd') usage(argv[0]);

	ret = smiler(arg);
	if (ret < 0) {
		printf("Are you sure the lkm is loaded?\n");
	} else {
		if (ret == 0) {
			puts("lkm inactive");
		} else {
			puts("lkm active");
		}
	}
	return(1);
}
