/*
 * b4b0-craq v.2
 * by: rsh/segv <rsh@shellz.swbt.net>
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <pwd.h>

#define BUF		40	
#define	DEF_DICT	"/usr/dict/words"

void usage(char *name);
int pwcmp(char *pwstr,char *try,int verbose);
int howmanyentries(FILE *pwfile);

int main(int argc, char *argv[]) {
  FILE *p,*d,*o;
  struct passwd *urg;
  int m,c,user_dict=0,out=0,ver=0;  
  char word[14], dictname[BUF], pwname[BUF];

  if(argc>=2) {
    while((c=getopt(argc,argv,"f:d:hv")) != EOF) 
      switch(c) {
        case 'f': 
          out=1;
          if((o=fopen(optarg,"w")) == NULL) {
            fprintf(stderr,"error opening output file.\n");
            exit(1);
          }
          break; 
        case 'd':
          user_dict=1;
          strncpy(dictname,optarg,BUF); 
          break;
        case 'h':
          fprintf(stderr,"cmd line opts:\n\t-f\t:\tspecify where to send output, none=stdout.\n\t-d\t:\tspecify ur own dictionary file.\n\t-h\t:\tprint out this help message.\n\t-v\t:\tverbose when cracking the passwords.\n\n");
          exit(1);
        case 'v':
          ver=1;
          printf("[*] verbose mode enabled.\n");
          break;
        default:
          fprintf(stderr,"[o] -- unknown option.\n");
          exit(1);
      }
    strncpy(pwname,argv[optind],BUF);
  }
  else {
    usage(argv[0]);
    exit(1);
  }

  if(!user_dict)
    strncpy(dictname,DEF_DICT,BUF);
 
  if(!out)
    o=stdout;
 
  printf("\n[o] using dictionary/password filez: %s -- %s\n\n",dictname,pwname);
       
  if((d=fopen(dictname,"r")) == NULL) {
    fprintf(stderr,"error opening dictionary file.\n");
    exit(1);
  }
  if((p=fopen(pwname,"r")) == NULL) {
    fprintf(stderr,"error opening password file.\n");
    exit(1);
  }

  if((m=howmanyentries(p)) <= 0) {
    fprintf(stderr,"uh.. this password file is empty.\n");
    exit(1);
  }

  printf("[!] there are %d entries in this pw file.\n",m); 
 
  while((urg=fgetpwent(p)) != NULL) {
    if((char *)strstr(urg->pw_passwd,"*") != NULL) {
      if(ver)  
        fprintf(o,"%s's account is locked.\n",urg->pw_name);
      continue;
    } 
    else
      fprintf(o,"attacking %s's password.\n",urg->pw_name);
    while(fgets(word,14,d) != NULL) {
      if(!pwcmp(urg->pw_passwd,word,ver)) {
        fprintf(o,"** %s's password has been cracked (it is: %s) **\n",urg->pw_name,word);
        break;
      }
    }   
  }
  fprintf(o,"\nD-0-N-E\n");
  exit(0);
} 

int pwcmp(char *pwstr,char *try,int verbose) {
  char *p,*maybe;

  /* have to find something in this function to be verbose about, heh.
     the ver is for future versions.
   */ 

  if((p=(char *)strchr(try,'\n')) != NULL)
    *p='\0';
  
  if((maybe=(char *)crypt(try,pwstr)) == NULL) {
    fprintf(stderr,"crypt() failed.\n");
    exit(1);
  }
  
  if(!strcmp(pwstr,maybe))
    return(0);
  else
    return(1);
}    
    
void usage(char *name) {
  fprintf(stderr,"Scrack v.2 ...\n");
  fprintf(stderr,"usage: %s [-h] [-v] [-d <dictionary file>] <pw file>\n",name);
}

int howmanyentries(FILE *pwfile) {
  int c=0;

  while(fgetpwent(pwfile) != NULL)
    c++;
  
  return(c);
}      
