/* plunkett
 * simple one instance of encryption
 * takes key and rand as argument
 */

#include <stdio.h>
#include "comp128.h" 

int main(int argc, char **argv)
{
	Byte rand[16], key [16], simoutput[12];
	int i;

	if (argc != 3 || strlen(argv[1]) != 34 || strlen(argv[2]) != 34
			|| strncmp(argv[1], "0x", 2) != 0
			|| strncmp(argv[2], "0x", 2) != 0) {
		fprintf(stderr, "Usage: %s 0x<key> 0x<rand>\n", argv[0]);
		exit(1);
	}

	for (i=0; i<16; i++)
		key[i] = (hextoint(argv[1][2*i+2])<<4)
			| hextoint(argv[1][2*i+3]);
	for (i=0; i<16; i++)
		rand[i] = (hextoint(argv[2][2*i+2])<<4)
			 | hextoint(argv[2][2*i+3]);
	printf("K:");
	for (i=0; i<16; i++)
		printf("%02x",key[i]);
	printf("\nR:");
	for (i=0; i<16; i++)
		printf("%02x",rand[i]);
	printf("\n");
	A3A8(rand, key, simoutput);
	printf("simoutput: ");
	for (i=0; i<12; i++)
		printf("%02x", simoutput[i]);
	printf("\n");
	return 0;
}

