#include <stdio.h>
#include "comp128.h"

int main(int argc, char **argv)
{
	Byte sres[12], rand[16], simout[12];
	Byte testkey[16], ki[16];
	int dif1, dif2;
	int i, bytepos;
	if (argc != 4 || strlen(argv[1]) != 34  
			|| strncmp(argv[1], "0x", 2) != 0
			|| strlen(argv[2]) != 26
			|| strncmp(argv[2], "0x", 2) != 0) {
		fprintf(stderr, "usage: 0x<partial key> 0x<sres of 0x00..0> <byte position>\n");
		exit(1);
	}
	if ((bytepos = atoi(argv[3])) > 7) {
		fprintf(stderr,"byte position out of range, aborting\n");
		exit(1);
	}
	for (i=0; i<16; i++) {
		ki[i] = (hextoint(argv[1][2*i+2])<<4)
			|hextoint(argv[1][2*i+3]);
		testkey[i] = ki[i];
	}
	for (i=0; i<12; i++)
		sres[i] = (hextoint(argv[2][2*i+2])<<4)
		 	|hextoint(argv[2][2*i+3]);

	memset(rand, 0, 16);
	for (dif1=0; dif1<0xFF+1; dif1++)
	  for (dif2=0; dif2<0xFF+1; dif2++) {
		testkey[bytepos] = dif1;
		testkey[bytepos+8] = dif2;
		A3A8(rand, testkey, simout);
		if (!memcmp(simout, sres, 12)) {
			ki[bytepos] = dif1;
			ki[bytepos+8] = dif2;
		 	dif1 = 0xFFF; dif2 = 0xFFF;
		}
	  }
	fprintf(stderr,"refined ki: ");
	for (i=0; i<16; i++)
		fprintf(stderr,"%02x",ki[i]);
	fprintf(stderr,"\n");
}	
