/* sc_cflex.c	- Smartcard related functions 
 *
 * CARD: Schlumberger Cryptoflex
 *
 * Copyright 1993-1997, Tim Hudson. All rights reserved.
 *
 * You can pretty much do what you like with this code except pretend that 
 * you wrote it provided that any derivative of this code includes the
 * above comments unchanged. If you put this in a product then attribution
 * is mandatory. See the details in the COPYING file.
 *
 * Tim Hudson
 * tjh@cryptsoft.com
 *
 */

#include "platform.h"

#ifdef USE_STDIO
#include <stdio.h>
#endif /* USE_STDIO */

#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#include "sio.h"
#include "sct0.h"
#include "sc.h"
#include "scint.h"

SC_CMD_PCONST cryptoflex_pconst[]={
{ "EF_CHV",    "0000" },
{ "EF_KEYint", "0001" },
{ "EF_KEYext", "0011" },
{ "EF_MF",     "3F00" },
{ "EF_RSApri", "0012" }
/*
{ "EF_RSApub", "1012" }
*/
};
#define _N_cryptoflex_pconst (sizeof(cryptoflex_pconst)/ \
                                    sizeof(cryptoflex_pconst[0]))
int N_cryptoflex_pconst=_N_cryptoflex_pconst;

SC_CMD_PDATA cryptoflex_pdata[]={
/* patterns for command output */
{ "select_df", "${_RFU1}${_RFU2}${FREE_SPACE:2}${FILE_ID:2}${FILE_TYPE}${AC:4}${FILE_STATUS}${LEN}${_RFU3}${NSD}${NSE}${NSEC}${_RFU4}${CHV_STATUS}${UNBLOCK_STATUS}" },
{ "select_ef", "${_RFU1}${_RFU2}${FILE_SIZE:2}${FILE_ID:2}${FILE_TYPE}${AC:4}${FILE_STATUS}${LEN}${_RFU3}${RECORD_LEN}" },
{ "dir_df", "${FILE_SIZE:2}${FILE_ID:2}${FILE_TYPE}${FILE_STATUS}${NSD}${NSE}" },
{ "dir_lf", "${FILE_SIZE:2}${FILE_ID:2}${FILE_TYPE}${FILE_STATUS}${RECORD_LEN}${NR}" },
{ "dir", "${FILE_SIZE:2}${FILE_ID:2}${FILE_TYPE}${FILE_STATUS}${_RFU1}${_RFU2}" },

/* patterns for command args */
{ "create", "${_RFU1:2}${FILE_SIZE:2}${FILE_ID:2}${FILE_TYPE}${AC:4}${FILE_STATUS}${DATA_LEN}${ACCESS_KEYS:3}" },
{ "create_lfcy", "${_RFU1:2}${FILE_SIZE:2}${FILE_ID:2}${FILE_TYPE}${AC:4}${FILE_STATUS}${DATA_LEN}${ACCESS_KEYS:3}${RECORD_LEN}" },

/* patterns for file formats */
/* 0000 */
{ "EF_CHV", "${ACTIVATION}${_RFU1}${_RFU2}${CHV:8}${ATTEMPT_MAX}${ATTEMPT_LEFT}${UNBLOCK_CHV:8}${UNBLOCK_ATTEMPT_MAX}${UNBLOCK_ATTEMPT_LEFT}" },

};
#define _N_cryptoflex_pdata (sizeof(cryptoflex_pdata)/ \
                                    sizeof(cryptoflex_pdata[0]))
int N_cryptoflex_pdata=_N_cryptoflex_pdata;

SC_CMD_ENT cryptoflex_cmds[]={
  { 
    "SelectFile", SC_DIR_IN, 0xc0, 0xa4, 
                        NULL, "00", "00", NULL, "${FileID:2}",
			"61", "GetResponse", "${SW2}",
			{ 
			  { 20, "select_df" }, 
			  { 15, "select_ef" }
			}
  },
  { "GetResponse", SC_DIR_OUT, 0xc0, 0xc0, 
                        NULL, "00", "00", "${Len}", NULL,
			NULL, NULL, NULL,
  },
  { "ReadBinary", SC_DIR_OUT, 0xc0, 0xb0, 
                        "${Offset}", NULL, NULL, "${Len}", NULL,
			NULL, NULL, NULL,
  },

  { "UpdateBinary", SC_DIR_IN, 0xc0, 0xd6, 
                        "${Offset}", NULL, NULL, "${Len}", "${Data}",
			NULL, NULL, NULL,
  },

  /* AppendBinary is called CreateRecord in the doc - unclear as to
   * whether or not it works on non LF files
   */
  { "AppendBinary", SC_DIR_IN, 0xc0, 0xe2, 
                        NULL, NULL, NULL, "${Len}", "${Data}",
			NULL, NULL, NULL,
  },

  { "ReadDirectory", SC_DIR_OUT, 0xf0, 0xa8, 
                        NULL, "00", "00", "00", NULL,
			"61", "GetResponse", "${SW2}",
			{
			  { 0, "dir" }
			}
  },
  /* Note: VerifyKey might need length specified ... hardwired to 8 for now */
  { "VerifyKey", SC_DIR_IN, 0xf0, 0x2a, 
                        NULL, "00", "${KeyNum}", NULL, "${Key:8}",
			NULL, NULL, NULL 
  },

  /* could map GetChallenge to GetRandom */
  { "GetChallenge", SC_DIR_OUT, 0xc0, 0x84, 
                        NULL, "00", "00", "${Len}", NULL,
			NULL, NULL, NULL 
  },

  { "VerifyCHV", SC_DIR_IN, 0xc0, 0x20, 
                        NULL, "00", "01", 
			NULL, "${CHV:8}",
			NULL, NULL, NULL 
  },

  { "ChangeCHV", SC_DIR_IN, 0xf0, 0x24, 
                        NULL, "00", "01", 
			NULL, "${OldCHV:8}${NewCHV:8}",
			NULL, NULL, NULL 
  },

  { "UnblockCHV", SC_DIR_IN, 0xf0, 0x2c, 
                        NULL, "00", "01", 
			NULL, "${UnblockCHV:8}${NewCHV:8}",
			NULL, NULL, NULL 
  },

  { "CreateFile", SC_DIR_IN, 0xf0, 0xe0, 
                        NULL, "${InitType}", "${NumRec}", 
			"${Len}", "${Data}",
			NULL, NULL, NULL 
  },

  { "DeleteFile", SC_DIR_IN, 0xf0, 0xe4, 
                        NULL, "00", "00", NULL, "${FileID:2}",
			NULL, NULL, NULL 
  },

  /* can have cryptogram if AC=PRO */
  { "Invalidate", SC_DIR_OUT, 0xf0, 0x04, 
                        NULL, "00", "00", "00", NULL,
			NULL, NULL, NULL 
  },

  /* can have cryptogram if AC=PRO */
  { "Rehabilitate", SC_DIR_OUT, 0xf0, 0x44, 
                        NULL, "00", "00", "00", NULL,
			NULL, NULL, NULL 
  },
                        
  /* special things ... which need more doco */
  { "InternalAuthenticate", SC_DIR_IN, 0xc0, 0x88, 
                        NULL, "00", "${KeyNum}", 
			"08", "${Challenge:8}"
			"61", "GetResponse", "${SW2}"
  },

  /* External Authenticate must be called immediately after GetChallenge */
  { "ExternalAuthenticate", SC_DIR_IN, 0xc0, 0x82, 
                        NULL, "00", "00",
			"07", "${KeyNum}${Cryptogram:7}"
  },

  /* INT_AUTH => SignRSA */
  { "INT_AUTH", SC_DIR_IN, 0xc0, 0x88, 
                        NULL, "00", "${KeyNum}", "80", "${Data:128}",
			"61", "GetResponse", "${SW2}",
  },

/* NOW FOR COMMANDS THAT ARE VARIATIONS ON THE ABOVE OR SIMPLY A DIFFERENT
 * NAME THAT MAKES MORE SENSE TO ME
 */
  /* INT_AUTH => SignRSA */
  { "SignRSA", SC_DIR_IN, 0xc0, 0x88, 
                        NULL, "00", "${KeyNum}", "80", "${Data:128}",
			"61", "GetResponse", "${SW2}",
  },
  /* UNLOCK -> VerifyKey */
  { "UNLOCK", SC_DIR_IN, 0xf0, 0x2a, 
                        NULL, "00", "01", NULL, "${Key:8}",
			NULL, NULL, NULL 
  }
};
#define _N_cryptoflex_cmds (sizeof(cryptoflex_cmds)/sizeof(cryptoflex_cmds[0]))
int N_cryptoflex_cmds=_N_cryptoflex_cmds;

SC_CMD_ERR_CVT cryptoflex_errs[]={
{ 0x60,   -1, SC_RSP_OK },
{ 0x61,   -1, SC_RSP_OK },		/* worked - more data via GetResponse */
{ 0x63, 0x00, SC_RSP_BADPASSWORD },
{ 0x67,   -1, SC_RSP_BADLEN },
{ 0x69, 0x82, SC_RSP_DENIED },
{ 0x6a, 0x80, SC_RSP_WRONGTYPE },	/* e.g. Dir on EF, Create again */
{ 0x6a, 0x82, SC_RSP_NOTFOUND },
{ 0x6b, -1, SC_RSP_BADP1P2 },
{ 0x6d, -1, SC_RSP_BADCLA },
{ 0x6e, -1, SC_RSP_BADINS }
};

#define _N_cryptoflex_errs (sizeof(cryptoflex_errs)/sizeof(cryptoflex_errs[0]))
int N_cryptoflex_errs=_N_cryptoflex_errs;

static char *cmds_dir[]={
"ReadDirectory",
NULL
};

static int cf_dir(SC_STATE *sc,void *pinternalv,char *args,char *uout)
{
  SC_CMD_INTERNAL *pinternal=(SC_CMD_INTERNAL *)pinternalv;
  char rspbuf[SC_MAX_HEX_DATA_LEN];
  char buf[BUFSIZ];
  char *p;
  int count,i;

  uout[0]='\0';
  if (sc->slog)
    SLOG_printf(sc->sout,"cf_dir start\n");
  if (!SC_ExecuteCommands(sc,cmds_dir,rspbuf,1))
    goto bad;

  if (sc->slog)
    SLOG_printf(sc->sout,"cf_dir loop\n");

  /* now loop over each directory entry and just dump the file names */
  p=SC_GetVar(sc,"$COUNT");
  if (p==NULL) {
    if (sc->sout) {
      SLOG_printf(sc->sout,"cf_dir NO COUNT\n");
    }
    goto bad;
  }
  count=strtoul(p,NULL,10);

  if (sc->slog)
    SLOG_printf(sc->sout,"cf_dir count=%d\n",count);

  for(i=0;i<count;i++) {
    /* first we basically want a space separated file list 
     * returned as part of the command 
     */
    sprintf(buf,"FILE_ID[%d]",i);
    p=SC_GetVar(sc,buf);
    if (p!=NULL) {
      strcat(uout,p);
      strcat(uout," ");
    }

    /* do something */
    sprintf(buf,"!echo ID=${FILE_ID[%d]} SIZE=${FILE_SIZE[%d]}",
                        i,i);
    if (sc->slog)
      SLOG_printf(sc->sout,"cf_dir cmd=%s\n",buf);
    SC_ExecuteCommand(sc,buf,rspbuf,0);
  }
  /* blow away vars */
  SC_ExecuteCommand(sc,"!clear",rspbuf,0);

  return(1);

bad: ;
  if (sc->slog)
    SLOG_printf(sc->slog,"cf_dir %s failed\n",args);
  sprintf(uout,"FAILED");

  return(0);
}

SC_CMD_INTERNAL cryptoflex_icmds[]={
{ "cf_dir", NULL, cf_dir }
};
#define _N_cryptoflex_icmds (sizeof(cryptoflex_icmds)/sizeof(cryptoflex_icmds[0]))
int N_cryptoflex_icmds=_N_cryptoflex_icmds;

SC_CMD_TABLE cryptoflex_cmd_table=
{ 
SC_CARD_CRYPTOFLEX, "cryptoflex", 
	cryptoflex_cmds, &N_cryptoflex_cmds,
	cryptoflex_icmds, &N_cryptoflex_icmds,
        cryptoflex_errs, &N_cryptoflex_errs,
	cryptoflex_pdata, &N_cryptoflex_pdata
};

