/* sc_dx.c	- Smartcard related functions 
 *
 * CARD: Philips DX
 *
 * Copyright 1993-1997, Tim Hudson. All rights reserved.
 *
 * You can pretty much do what you like with this code except pretend that 
 * you wrote it provided that any derivative of this code includes the
 * above comments unchanged. If you put this in a product then attribution
 * is mandatory. See the details in the COPYING file.
 *
 * Tim Hudson
 * tjh@cryptsoft.com
 *
 */

/* Notes:
 *	 - read/write is max of 64 bytes at a time! 
 *	 - pre-utilisation commands are not listed here as I don't
 *	   see the need for them yet. Perhaps I'll add in the concept
 *	   of classes of commands later but for now that would just
 *	   confuse things
 *	 - batch card specific commands are also not listed here!
 *	 - default APPLICATION_NAME is "STD"
 *	 - none of the SEEKing stuff is in here either ... it may
 *	   be useful later 
 */

#include "platform.h"

#ifdef USE_STDIO
#include <stdio.h>
#endif /* USE_STDIO */

#include <ctype.h>
#include <stdlib.h>
#include <string.h>

#include "sio.h"
#include "sct0.h"
#include "sc.h"
#include "scint.h"

SC_CMD_PCONST dx_pconst[]={
{ "EF_CHV", "0000" },
{ "EF_CHV1", "0000" },
{ "EF_IC", "0002" },
{ "EF_IP", "0007" }
};
#define _N_dx_pconst (sizeof(dx_pconst)/ \
                                    sizeof(dx_pconst[0]))
int N_dx_pconst=_N_dx_pconst;

SC_CMD_PDATA dx_pdata[]={
/* patterns for command output */
{ "select", "${FILE_ID:2}${FILE_TYPE}${FILE_START:2}${RECORD_LEN}${MAX_LENGTH:2}${_RFU1}${_RFU2}${AC:3}${FILE_STATUS}${FILE_SIZE:2}${ATTEMPT_LEFT}${UNBLOCK_ATTEMPT_LEFT}" },

#if 0
{ "dir_df", "${FILE_SIZE:2}${FILE_ID:2}${FILE_TYPE}${FILE_STATUS}${NSD}${NSE}" },
{ "dir_lf", "${FILE_SIZE:2}${FILE_ID:2}${FILE_TYPE}${FILE_STATUS}${RECORD_LEN}${NR}" },
{ "dir", "${FILE_SIZE:2}${FILE_ID:2}${FILE_TYPE}${FILE_STATUS}${_RFU1}${_RFU2}" },

/* patterns for command args */
{ "create", "${_RFU1:2}${FILE_SIZE:2}${FILE_ID:2}${FILE_TYPE}${AC:4}${FILE_STATUS}${DATA_LEN}${ACCESS_KEYS:3}" },
{ "create_lfcy", "${_RFU1:2}${FILE_SIZE:2}${FILE_ID:2}${FILE_TYPE}${AC:4}${FILE_STATUS}${DATA_LEN}${ACCESS_KEYS:3}${RECORD_LEN}" },

#endif

/* patterns for file formats */
/* 0000 */
{ "EF_CHV1", "${_RFU1:3}${CHV:8}${ATTEMPT_MAX}${ATTEMPT_LEFT}${UNBLOCK_CHV:8}${UNBLOCK_ATTEMPT_MAX}${UNBLOCK_ATTEMPT_LEFT}" },

/* 0002 */
{ "EF_IC", "${CHIP_MANUFACTURER_ID}${COMPONENT_ID}${MASK_ID}${BATCH_ID}${_RFU1:2}${MANUFACTURER_ID:2}${_RFU2}${SERIAL_NO:4}${PROFILE}${_RFU3:2}" },

/* 0007 */
{ "EF_IP", "${APPLICATION_ID:3}${INDEX}${VERSION}${APPLICATION_NAME:3}${BATCH_NO:4}${SERIAL_NO:4}" } ,

};
#define _N_dx_pdata (sizeof(dx_pdata)/ \
                                    sizeof(dx_pdata[0]))
int N_dx_pdata=_N_dx_pdata;

SC_CMD_ENT dx_cmds[]={
  { "SelectFile", SC_DIR_IN, 0x00, 0xa4, 
                        NULL, "00", "00", NULL, "${FileID:2}",
			"90", "GetResponse", "12",
			{ { 0, "select" } } },
  { "GetResponse", SC_DIR_OUT, 0x00, 0xc0, 
                        NULL, "00", "00", "${Len}", NULL,
			NULL, NULL, NULL },

  { "ReadBinary", SC_DIR_OUT, 0x00, 0xb0, 
                        "${Offset}", NULL, NULL, "${Len}", NULL,
			NULL, NULL, NULL },

  { "VerifyPIN", SC_DIR_IN, 0x00, 0x20, 
                        NULL, "00", "01", NULL, "${PIN:8}",
			NULL, NULL, NULL },

  { "ChangePIN", SC_DIR_IN, 0x00, 0x24, 
                        NULL, "00", "01", NULL, "${OldPIN:8}${NewPIN:8}",
			NULL, NULL, NULL },

  /* AskRandom returns 8 bytes of (semi-)random data */
  { "AskRandom", SC_DIR_OUT, 0x00, 0x84, 
                        NULL, NULL, NULL, "08", NULL,
			NULL, NULL, NULL },


  { "UpdateBinary", SC_DIR_IN, 0x00, 0xd6, 
                        "${Offset}", NULL, NULL, "${Len}", "${Data}",
			NULL, NULL, NULL,
  },

/*
  { "UpdateBinary2", SC_DIR_IN, 0x00, 0xd0, 
                        "${Offset}", NULL, NULL, "${Len}", "${Data}",
			NULL, NULL, NULL,
  },
*/

  /* AppendBinary - called Create Binary in the doco */
  { "AppendBinary", SC_DIR_IN, 0x00, 0xda, 
                        NULL, NULL, NULL, "${Len}", "${Data}",
			NULL, NULL, NULL,
  },

  { "Invalidate", SC_DIR_OUT, 0x00, 0x04, 
                        NULL, "00", "00", "00", NULL,
			NULL, NULL, NULL 
  },
                        

  /* ComputeRSA either generates or verifies a signature depending 
   * on the file currently selected (public or private key)
   */
  { "ComputeRSA", SC_DIR_IN, 0x00, 0xf6, 
                        NULL, "00", "00", "40", "${Data:64}",
			"61", "GetResponse", "${SW2}",
  },

/* NOW FOR COMMANDS THAT ARE VARIATIONS ON THE ABOVE OR SIMPLY A DIFFERENT
 * NAME THAT MAKES MORE SENSE TO ME
 */
  { "SignRSA", SC_DIR_IN, 0x00, 0xf6, 
                        NULL, "00", "00", "40", "${Data:64}",
			"61", "GetResponse", "${SW2}",
  },
  /* UNLOCK -> VerifyPIN */
  { "UNLOCK", SC_DIR_IN, 0x00, 0x20, 
                        NULL, "00", "01", NULL, "${Password:8}",
			NULL, NULL, NULL }
};
#define _N_dx_cmds (sizeof(dx_cmds)/sizeof(dx_cmds[0]))
int N_dx_cmds=_N_dx_cmds;

SC_CMD_ERR_CVT dx_errs[]={
{ 0x90, 0x00, SC_RSP_OK },
{ 0x92, 0x80, SC_RSP_DENIED },
{ 0x94, 0x04, SC_RSP_NOTFOUND },
{ 0x98, 0x04, SC_RSP_DENIED },
{ 0x67, -1, SC_RSP_BADLEN }
};
#define _N_dx_errs (sizeof(dx_errs)/sizeof(dx_errs[0]))

int N_dx_errs=_N_dx_errs;

SC_CMD_INTERNAL dx_icmds[]={ { NULL, NULL, NULL } };
#define _N_dx_icmds (sizeof(dx_icmds)/sizeof(dx_icmds[0]))
/*
int N_dx_icmds=_N_dx_icmds;
*/
int N_dx_icmds=0;

SC_CMD_TABLE dx_cmd_table=
{ 
SC_CARD_CRYPTOFLEX, "dx", 
	dx_cmds, &N_dx_cmds,
	dx_icmds, &N_dx_icmds,
        dx_errs, &N_dx_errs,
	dx_pdata, &N_dx_pdata
};

