/* scint.h - Smartcard related functions - INTERNAL
 *
 * Copyright 1993-1997, Tim Hudson. All rights reserved.
 *
 * You can pretty much do what you like with this code except pretend that 
 * you wrote it provided that any derivative of this code includes the
 * above comments unchanged. If you put this in a product then attribution
 * is mandatory. See the details in the COPYING file.
 *
 * Tim Hudson
 * tjh@cryptsoft.com
 *
 */

#ifndef HEADER_SCINT_H
#define HEADER_SCINT_H

/*
#include "platform.h"
#include "sio.h"
#include "slog.h"
#include "sc.h"
*/

#define SC_MAX_AUTO_PARSE_ENTRIES 3

typedef struct {
  int len;        /* required length, 0 if not relevant */
  char *name;     /* name of the parse pattern (i.e. SC_CMD_PDATA) */
} SC_AUTO_PARSE;

typedef struct {
  char *name;
  int direction;
  unsigned char CLA;
  unsigned char INS;
  char *P1P2;
  char *P1;
  char *P2;
  char *len;
  char *data;
  char *chain_SW1;
  char *chain_cmd;
  char *chain_args;
  SC_AUTO_PARSE auto_parse[SC_MAX_AUTO_PARSE_ENTRIES];
} SC_CMD_ENT;

typedef struct {
  int SW1;
  int SW2;
  int rsp_code;
} SC_CMD_ERR_CVT;

typedef struct {
  char *name;
  char *data;
  int (*func)(SC_STATE *sc,void *pdata);
} SC_CMD_PDATA;

typedef struct {
  char *name;
  char *data;
} SC_CMD_PCONST;

typedef struct {
  char *name;
  char *data;
  int (*func)(SC_STATE *sc,void *pinternal,char *args,char *uout);
} SC_CMD_INTERNAL;

typedef struct {
  int card_type;
  char *card_name;
  /* normal commands - table driven */
  SC_CMD_ENT *cmds;
  int *N_cmds;
  /* "internal" commands - implemented in code */
  SC_CMD_INTERNAL *icmds;
  int *N_icmds;
  /* error conversion table */
  SC_CMD_ERR_CVT *errs;
  int *N_errs;
  /* data patterns - for output structure to var mapping */
  SC_CMD_PDATA *pdata;
  int *N_pdata;
  /* constant definitions - for *fixed* things */
  SC_CMD_PCONST *pconst;
  int *N_pconst;
} SC_CMD_TABLE;

/* standard internal commands */
extern int N_sc_icmds;
extern SC_CMD_INTERNAL sc_icmds[];

/* decls for card specific tables ... which will move into functions that
 * register card support at runtime rather than a fixed table down the track
 * but for the moment that isn't important
 */
extern int N_cryptoflex_cmds;
extern SC_CMD_ENT cryptoflex_cmds[];
extern int N_cryptoflex_icmds;
extern SC_CMD_INTERNAL cryptoflex_icmds[];
extern int N_cryptoflex_errs;
extern SC_CMD_ERR_CVT cryptoflex_errs[];
extern int N_cryptoflex_pdata;
extern SC_CMD_PDATA cryptoflex_pdata[];
extern int N_cryptoflex_pconst;
extern SC_CMD_PCONST cryptoflex_pconst[];

extern int N_dx_cmds;
extern SC_CMD_ENT dx_cmds[];
extern int N_dx_icmds;
extern SC_CMD_INTERNAL dx_icmds[];
extern int N_dx_errs;
extern SC_CMD_ERR_CVT dx_errs[];
extern int N_dx_pdata;
extern SC_CMD_PDATA dx_pdata[];
extern int N_dx_pconst;
extern SC_CMD_PCONST dx_pconst[];

extern int N_chipknip_cmds;
extern SC_CMD_ENT chipknip_cmds[];
extern int N_chipknip_icmds;
extern SC_CMD_INTERNAL chipknip_icmds[];
extern int N_chipknip_errs;
extern SC_CMD_ERR_CVT chipknip_errs[];
extern int N_chipknip_pdata;
extern SC_CMD_PDATA chipknip_pdata[];
extern int N_chipknip_pconst;
extern SC_CMD_PCONST chipknip_pconst[];

extern int N_gsm_cmds;
extern SC_CMD_ENT gsm_cmds[];
extern int N_gsm_icmds;
extern SC_CMD_INTERNAL gsm_icmds[];
extern int N_gsm_errs;
extern SC_CMD_ERR_CVT gsm_errs[];
extern int N_gsm_pdata;
extern SC_CMD_PDATA gsm_pdata[];
extern int N_gsm_pconst;
extern SC_CMD_PCONST gsm_pconst[];

/* soon the following will be all that are visible ... the above
 * mess will be tidied up and card support "registered" with
 * the library at runtime
 */
extern SC_CMD_TABLE cryptoflex_cmd_table;
extern SC_CMD_TABLE dx_cmd_table;
extern SC_CMD_TABLE chipknip_cmd_table;
extern SC_CMD_TABLE gsm_cmd_table;

#endif /* HEADER_SCINT_H */

