#include "sres.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#define private st00pidcpluspluskeyword
extern "C" {
#include <sio.h>
#include <sct0.h>
#include <sc.h>
}

int timeoutval;

SIO_INFO* si;
byte selectfile[] = { 0xa0, 0xa4, 0x00, 0x00, 0x02 };
byte gsm_file[] = { 0x7f, 0x20 };
byte gsm2_file[] = { 0x7f, 0x21 };
byte imsi_file[] = { 0x6f, 0x07 };
byte get_res[] = { 0xa0, 0xc0, 0x00,  0x00, 0x00 };
byte verify_pin[] = { 0xa0, 0x20, 0x00, 0x01, 0x08 };
byte generate_sres[] = { 0xa0, 0x88, 0x00, 0x00, 0x10 };
byte read_data[] = { 0xa0, 0xb0, 0x00, 0x00, 0x09 };

void init_card(char* devicename,int do_pin, byte pin[8]) {
  byte buffer[32];
  int i;
  SC_ATR * atr;
  SC_STATE *sc;
  SLOG *log;

  si = SIO_Open(devicename);
  if (si!=NULL) {
    SIO_SetSpeed(si,9600);
    SIO_SetDataBits(si,8);
    SIO_SetStopBits(si,2);
    SIO_SetParity(si,SIO_PARITY_EVEN);
    SIO_SetIOMode(si,SIO_IOMODE_DIRECT);
    SIO_FilterEcho(si, 1);

    /* now actually change the line settings */
    SIO_WriteSettings(si);

    /* trigger ATR from a Smartcard */
    if(i = SCT0_GetATR(si, buffer, 32)) {
      atr=SC_DecodeATR(buffer, i);
      fprintf(stderr,"ATR: %s\n", SC_ATR2Text(atr, 0));
      
      SIO_Delay(si,10000);
      SIO_WriteBuffer(si, selectfile, 5);
      SIO_WaitForData(si, 1000);
      SIO_ReadBuffer(si, buffer, 32);

      SIO_WriteBuffer(si, gsm_file, 2);
      SIO_WaitForData(si, 1000);
      SIO_ReadBuffer(si, buffer, 32);

      if(buffer[0] != 0x9f) {
	printf("selecting gsm_file failed, trying DCS1800!\n");

	SIO_WriteBuffer(si, selectfile, 5);
	SIO_WaitForData(si, 1000);
	SIO_ReadBuffer(si, buffer, 32);

	SIO_WriteBuffer(si, gsm2_file, 2);
	SIO_WaitForData(si, 1000);
	SIO_ReadBuffer(si, buffer, 32);

	if(buffer[0] != 0x9f) {
	  printf("selecting gsm_file failed!\n");
	  exit(1);
	}
      }
      if (do_pin != 0) {
        get_res[4] = buffer[1];
        memcpy(buffer, get_res, 5);
        SIO_WriteBuffer(si, buffer, 5);
        SIO_WaitForData(si, 1000);
        i = SIO_ReadBuffer(si, buffer, 32);

        SIO_WriteBuffer(si, verify_pin, 5);
        SIO_WaitForData(si, 1000);
        i = SIO_ReadBuffer(si, buffer, 32);

        SIO_WriteBuffer(si, pin, 8);
        SIO_Delay(si,100000);
        SIO_WaitForData(si, 1000);
        i = SIO_ReadBuffer(si, buffer, 32);

        if(buffer[0] != 0x90) {
	  printf("pin verification failed!\n");
	  for(int j=0; j<i; j++) {
	    printf("0x%02X ", buffer[j]);
	  }
	printf("\n");
	exit(1);
        }
      }

    } else {
      fprintf(stderr,"cannot establish link to smartcard\n");
      exit(1);
    }
  } else {
    fprintf(stderr,"opening device %s failed.\n", devicename);
    exit(1);
  }
}


void get_imsi(byte imsi[11]) {
  byte buffer[32];
  int i;

  SIO_WriteBuffer(si, imsi_file, 2);
  SIO_WaitForData(si, 1000);
  SIO_ReadBuffer(si, buffer, 32);
  fprintf(stderr,"\n");
  for (i=0; i<2; i++)
	fprintf(stderr,"%02x",buffer[i]);
  fprintf(stderr,"\n");
  //if (buffer[1] != 0x9f) {
  //  fprintf(stderr,"selecting imsi-file failed!\n");
  //  exit(1);
  //}
  //get_res[4] = buffer[1];
  memcpy(buffer, read_data, 5);
  SIO_WriteBuffer(si, buffer, 5);
  SIO_WaitForData(si, 1000);
  i = SIO_ReadBuffer(si, buffer, 32);
  get_res[4] = 0x09; 
  SIO_WriteBuffer(si, get_res, 5);
  SIO_Delay(si, 1000);
  SIO_WaitForData(si, 1000);
  i = SIO_ReadBuffer(si, buffer, 32);
  for (i=0; i<11; i++)
    imsi[i] = buffer[i+1];
}
   
void get_response(byte challenge[16], byte response[12]) {
  byte buffer[32];
  int i;
  int delay;
  delay = 1;

  memcpy(buffer, generate_sres, 5);
  SIO_WriteBuffer(si, buffer, 5);
  do {
    SIO_WaitForData(si, delay);
    i = SIO_ReadBuffer(si, buffer, 32);
  } while (i==0);

  memcpy(buffer, challenge, 16);
  SIO_WriteBuffer(si, buffer, 16);
  do {
    SIO_WaitForData(si, delay);
    i = SIO_ReadBuffer(si, buffer, 32);
  } while (i==0);

  if(buffer[0] != 0x9f) {
    printf("getting response failed!\n");
    exit(1);
  }

  get_res[4] = buffer[1];
  memcpy(buffer, get_res, 5);
  SIO_WriteBuffer(si, buffer, 5);
  SIO_WaitForData(si, delay);
  i = SIO_ReadBuffer(si, buffer, 32);

  memcpy(response, buffer + 1, 12);
}

void set_timeout(int t) {
  timeoutval = t;
}

#ifdef 0
int main(int argc, char** argv) {
  byte challenge[16] = { 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
			 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
  byte pin[8] = { 0x35, 0x35, 0x35, 0x35, 0xff, 0xff, 0xff, 0xff };

  byte response[12];
  int do_pin;
  init_card("/dev/cuaa1", 0, pin);
  get_response(challenge, response);
}
#endif
