#!WHICH_PERL
# deceptive defense - wear down the attackers and all their port scanners and so forth
# Copyright (c), 1998, Fred Cohen - All Right Reserved

# NOTICE: By taking this copy, you agree that all updates and modifications
# will be reported back to us, that you will only use it to defend systems and
# not to figure out how to attack them, that we retain all right to the
# software provided to you and any revisions, enhancements, or derivitive
# works that may result from it, that you will retain all copyright notices on
# all copies you distribute elsewhere, and that anyone you give it to will
# also agree to these terms.

sub getremoteportnumber
	{local $otherport;local $junk;
	if (-x "/usr/bin/getpeername")
		{($otherport, $junk)=split(/\n/,`/usr/bin/getpeername 2>/dev/null`,2);}	# get remote system's port
	else	{$otherport='-1';}
	if ($otherport=='') {$otherport='-1';}
	return $otherport;
	}

sub getlocalIPaddress
	{local $toIPaddr;local $junk;
	if (-x "/usr/bin/getsockname")
		{($junk, $toIPaddr)=split(/\n/,`/usr/bin/getsockname 2>/dev/null`,2);chop($toIPaddr);} # get your system's IP address
	else	{$toIPaddr='0.0.0.0';}
	if ($toIPaddr=='') {$toIPaddr='0.0.0.0';}
	return $toIPaddr;
	}

$compress=LOG_COMPRESSED;		# 1 for compressed logfile format - saves a lot of space
					# 2 for database format - ammenable to database analysis
					# 3 for syslog format - by request
$painlevel=MAX_LENGTH;		# Maximum logged entry size (for buffer overflow attempts and so forth)
			# set this real high if you want to collect the details of the overflow
			# set is real low if you want only to limit having to look at their garbage

if ($compress == 3) {require "syslog.pl";}

# time (if compression it's a Delta time)
sub DATE {if ($compress == 1)
		{if ($realtime == 0)
			{$realtime=time; $dtime=0;
			($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
			$year = $year+1900;
			$Z=sprintf("%4d/%02d/%02d %02d:%02d:%02d", $year, $mon+1, $mday, $hour, $min, $sec);}
		else {$dtime=time-$realtime;$realtime=time;$Z=sprintf("+%d",$dtime);}}
	else	{($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
		$year = $year+1900;
		$Z=sprintf("%4d/%02d/%02d %02d:%02d:%02d", $year, $mon+1, $mday, $hour, $min, $sec);}}

# log all activities
sub LOG {if ($compress == 3)
		{&openlog("dtk",'cons,pid','user');
		&syslog('info',"$ipadd $otherport $toIPaddr $OurPort $Z $$ $listenPID:$con $progname S0 $resp $IN");
		&closelog();return TRUE;}
	while ((index($IN,"\n",$[) > $[) || (index($IN,"\r",$[) > $[)) {chop($IN);}	# kill end of line stuff
	if ($compress == 1)
		{$ocompress=$compress;$compress=0;DATE();$compress=$ocompress;}
	else	{DATE();}
	$realtime=time; $dtime=0;
	open(LOGFILE, ">>WORKING_DIR/log");
	open(IPLOGFILE, ">>WORKING_DIR/IP/$ipadd");
	$resp="R"."$response-" . $ResponseTable{"I$infocon"};
	if ($compress == 2)
		{print LOGFILE "'$ipadd', '$otherport', '$toIPaddr', '$OurPort', '$Z', '$$', '$listenPID', '$con', '$progname', 'S0', '$resp', '$IN'\n";
		print IPLOGFILE "'$ipadd', '$otherport', '$toIPaddr', '$OurPort', '$Z', '$$', '$listenPID', '$con', '$progname', 'S0', '$resp', '$IN'\n";}
	else 	{print LOGFILE "$ipadd $otherport $toIPaddr $OurPort $Z $$ $listenPID:$con $progname S0 $resp $IN\n";
		print IPLOGFILE "$ipadd $otherport $toIPaddr $OurPort $Z $$ $listenPID:$con $progname S0 $resp $IN\n";}
	close(LOGFILE);close(IPLOGFILE);
	}

# initial and ongoing please
sub LOGON {if ($compress == 3)
		{&openlog("dtk",'cons,pid','user');
		&syslog('info',"$ipadd $otherport $toIPaddr $OurPort $Z $$ $listenPID:$con $progname S0 $resp $IN");
		&closelog();return TRUE;}
	while ((index($IN,"\n",$[) > $[) || (index($IN,"\r",$[) > $[)) {chop($IN);}	# kill end of line stuff
	if ($realtime == 0) {LOG();}
	else	{DATE();				# get the date
		if (length($IN) > $painlevel)		# limit $IN length - buffer overflow try
			{$tmp=substr($IN,$],($]+$painlevel));$IN="BufferOverflow $tmp";}
		open(LOGFILE, ">>WORKING_DIR/log");
		open(IPLOGFILE, ">>WORKING_DIR/IP/$ipadd");
		$resp="R"."$response-" . $ResponseTable{"I$infocon"};
		if ($compress == 0)
			{print LOGFILE "$ipadd $otherport $toIPaddr $OurPort $Z $$ $listenPID:$con $progname S$state $resp $IN\n";
			print IPLOGFILE "$ipadd $otherport $toIPaddr $OurPort $Z $$ $listenPID:$con $progname S$state $resp $IN\n";}
		elsif ($compress == 2)
			{print LOGFILE "'$ipadd', '$otherport', '$toIPaddr', '$OurPort', '$Z', '$$', '$listenPID', '$con', '$progname', 'S$state', '$resp', '$IN'\n";
			print IPLOGFILE "'$ipadd', '$otherport', '$toIPaddr', '$OurPort', '$Z', '$$', '$listenPID', '$con', '$progname', 'S$state', '$resp', '$IN'\n";}
		else	{print LOGFILE "- - - $Z - - $listenPID:$con - S$state $resp $IN\n";
			print IPLOGFILE "- - - $Z - - $listenPID:$con - S$state $resp $IN\n";}
		close(LOGFILE);close(IPLOGFILE);}
	}
return(TRUE);
